/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.testing.internal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalLogger {
    private static boolean checkedEnabled;
    private static boolean loggingEnabled;
    public final boolean LOG_ENABLED = InternalLogger.isLog4jEnabled();
    public final Logger log;

    private static boolean isLog4jEnabled() {
        if (!checkedEnabled) {
            checkedEnabled = true;
            try {
                Class.forName("org.slf4j.impl.StaticMDCBinder");
            }
            catch (Throwable t) {
                loggingEnabled = false;
                return false;
            }
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            loggingEnabled = tccl.getResource("log4j.properties") != null || tccl.getResource("log4j.xml") != null || System.getProperty("log4j.configuration") != null;
        }
        return loggingEnabled;
    }

    public static InternalLogger get(Class<?> clazz) {
        return new InternalLogger(clazz);
    }

    private InternalLogger(Class<?> clazz) {
        this.log = this.LOG_ENABLED ? LoggerFactory.getLogger(clazz) : null;
    }

    public void debug(String msg) {
        if (this.LOG_ENABLED) {
            this.log.debug(msg);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.LOG_ENABLED) {
            this.log.debug(msg, t);
        }
    }

    public void info(String msg) {
        if (this.LOG_ENABLED) {
            this.log.info(msg);
        } else {
            System.out.println("[INFO] " + msg);
        }
    }

    public void warn(String msg) {
        if (this.LOG_ENABLED) {
            this.log.warn(msg);
        } else {
            System.out.println("[WARN] " + msg);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.LOG_ENABLED) {
            this.log.warn(msg, t);
        } else {
            System.out.println("[WARN] " + msg);
            t.printStackTrace();
        }
    }

    public void error(String msg) {
        if (this.LOG_ENABLED) {
            this.log.error(msg);
        } else {
            System.out.println("[ERROR] " + msg);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.LOG_ENABLED) {
            this.log.error(msg, t);
        } else {
            System.out.println("[ERROR] " + msg);
            t.printStackTrace();
        }
    }
}

