/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.testing;

import java.net.MalformedURLException;
import java.net.URL;
import org.microshed.testing.ApplicationEnvironment;

public class ManuallyStartedConfiguration
implements ApplicationEnvironment {
    public static final String MICROSHED_HOSTNAME = "microshed_hostname";
    public static final String MICROSHED_HTTP_PORT = "microshed_http_port";
    public static final String MICROSHED_HTTPS_PORT = "microshed_https_port";
    public static final String MICROSHED_APP_CONTEXT_ROOT = "microshed_app_context_root";
    public static final String MANUAL_ENALBED = "microshed_manual_env";
    private static URL runtimeURL;

    @Override
    public boolean isAvailable() {
        if (!Boolean.valueOf(ManuallyStartedConfiguration.resolveProperty(MANUAL_ENALBED)).booleanValue()) {
            return false;
        }
        String host = ManuallyStartedConfiguration.resolveProperty(MICROSHED_HOSTNAME);
        String httpPort = ManuallyStartedConfiguration.resolveProperty(MICROSHED_HTTP_PORT);
        String httpsPort = ManuallyStartedConfiguration.resolveProperty(MICROSHED_HTTPS_PORT);
        return !host.isEmpty() && (!httpPort.isEmpty() || !httpsPort.isEmpty());
    }

    @Override
    public int getPriority() {
        return -10;
    }

    public static void setRuntimeURL(String url) {
        try {
            runtimeURL = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getHostname() {
        if (runtimeURL != null) {
            return runtimeURL.getHost();
        }
        return ManuallyStartedConfiguration.resolveProperty(MICROSHED_HOSTNAME);
    }

    public static int getHttpPort() {
        if (runtimeURL != null && runtimeURL.toString().startsWith("http://")) {
            return runtimeURL.getPort() == -1 ? runtimeURL.getDefaultPort() : runtimeURL.getPort();
        }
        String port = ManuallyStartedConfiguration.resolveProperty(MICROSHED_HTTP_PORT);
        return port.isEmpty() ? -1 : Integer.valueOf(port);
    }

    public static int getHttpsPort() {
        if (runtimeURL != null && runtimeURL.toString().startsWith("https://")) {
            return runtimeURL.getPort() == -1 ? runtimeURL.getDefaultPort() : runtimeURL.getPort();
        }
        String port = ManuallyStartedConfiguration.resolveProperty(MICROSHED_HTTPS_PORT);
        return port.isEmpty() ? -1 : Integer.valueOf(port);
    }

    public static String getBasePath() {
        Object basePath;
        Object object = basePath = runtimeURL != null ? runtimeURL.getPath() : ManuallyStartedConfiguration.resolveProperty(MICROSHED_APP_CONTEXT_ROOT);
        if (!((String)basePath).startsWith("/")) {
            basePath = "/" + (String)basePath;
        }
        return basePath;
    }

    public static String getRuntimeURL() {
        if (runtimeURL != null) {
            return runtimeURL.toString();
        }
        String host = ManuallyStartedConfiguration.getHostname();
        int httpPort = ManuallyStartedConfiguration.getHttpPort();
        int httpsPort = ManuallyStartedConfiguration.getHttpsPort();
        if (host.isEmpty() || httpPort == -1 && httpsPort == -1) {
            throw new IllegalStateException("The properties 'microshed_hostname' and 'microshed_http_port' or 'microshed_https_port' must be set in order to use this ApplicationEnvironment");
        }
        String basePath = ManuallyStartedConfiguration.getBasePath();
        if (httpsPort != -1) {
            return "https://" + host + ":" + httpsPort + basePath;
        }
        return "http://" + host + ":" + httpPort + basePath;
    }

    private static String resolveProperty(String key) {
        String value = System.getProperty(key, System.getenv(key));
        return value == null ? "" : value;
    }

    @Override
    public void start() {
    }

    @Override
    public String getApplicationURL() {
        return ManuallyStartedConfiguration.getRuntimeURL();
    }
}

