/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.boost.runtimes.openliberty;

import io.openliberty.tools.common.plugins.util.OSUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.microshed.boost.common.BoostLoggerI;
import org.microshed.boost.common.boosters.JDBCBoosterConfig;
import org.microshed.boost.common.config.BoostProperties;
import org.microshed.boost.common.utils.BoostUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LibertyServerConfigGenerator {
    public static final String CONFIG_DROPINS_DIR = "/configDropins/defaults";
    private final String serverPath;
    private final String libertyInstallPath;
    private final String encryptionKey;
    private final BoostLoggerI logger;
    private Document serverXml;
    private Element featureManager;
    private Element serverRoot;
    private Element httpEndpoint;
    private Document variablesXml;
    private Element variablesRoot;
    private Set<String> featuresAdded;

    public LibertyServerConfigGenerator(String serverPath, String encryptionKey, BoostLoggerI logger) throws ParserConfigurationException {
        this.serverPath = serverPath;
        this.libertyInstallPath = serverPath + "/../../..";
        this.encryptionKey = encryptionKey;
        this.logger = logger;
        this.generateServerXml();
        this.generateVariablesXml();
        this.featuresAdded = new HashSet<String>();
    }

    private void generateServerXml() throws ParserConfigurationException {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.serverXml = docBuilder.newDocument();
        this.serverRoot = this.serverXml.createElement("server");
        this.serverRoot.setAttribute("description", "Liberty server generated by Boost");
        this.serverXml.appendChild(this.serverRoot);
        this.featureManager = this.serverXml.createElement("featureManager");
        this.serverRoot.appendChild(this.featureManager);
        this.httpEndpoint = this.serverXml.createElement("httpEndpoint");
        this.httpEndpoint.setAttribute("id", "defaultHttpEndpoint");
        this.serverRoot.appendChild(this.httpEndpoint);
    }

    private void generateVariablesXml() throws ParserConfigurationException {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.variablesXml = docBuilder.newDocument();
        this.variablesRoot = this.variablesXml.createElement("server");
        this.variablesRoot.setAttribute("description", "Boost variables");
        this.variablesXml.appendChild(this.variablesRoot);
    }

    public void addFeature(String featureName) {
        if (!this.featuresAdded.contains(featureName)) {
            Element feature = this.serverXml.createElement("feature");
            feature.appendChild(this.serverXml.createTextNode(featureName));
            this.featureManager.appendChild(feature);
            this.featuresAdded.add(featureName);
        }
    }

    public void addFeatures(List<String> features) {
        for (String featureName : features) {
            this.addFeature(featureName);
        }
    }

    public void writeToServer() throws TransformerException, IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("encoding", "UTF-8");
        DOMSource server = new DOMSource(this.serverXml);
        StreamResult serverResult = new StreamResult(new File(this.serverPath + "/server.xml"));
        transformer.transform(server, serverResult);
        Path configDropins = Paths.get(this.serverPath + CONFIG_DROPINS_DIR, new String[0]);
        Files.createDirectories(configDropins, new FileAttribute[0]);
        DOMSource variables = new DOMSource(this.variablesXml);
        StreamResult variablesResult = new StreamResult(new File(this.serverPath + CONFIG_DROPINS_DIR + "/variables.xml"));
        transformer.transform(variables, variablesResult);
    }

    public void addConfigVariables(Properties properties) throws IOException {
        if (properties != null) {
            for (String key : properties.stringPropertyNames()) {
                String value = properties.getProperty(key);
                this.addConfigVariable(key, value);
            }
        }
    }

    private void addConfigVariable(String key, String value) throws IOException {
        Map propertiesToEncrypt = BoostProperties.getPropertiesToEncrypt();
        if (propertiesToEncrypt.containsKey(key) && value != null && !value.equals("")) {
            value = this.encrypt(key, value);
        }
        Element variable = this.variablesXml.createElement("variable");
        variable.setAttribute("name", key);
        variable.setAttribute("defaultValue", value);
        this.variablesRoot.appendChild(variable);
    }

    public void addKeystore(Map<String, String> keystoreProps, Map<String, String> keyProps) {
        Element keystore = this.serverXml.createElement("keyStore");
        keystore.setAttribute("id", "defaultKeyStore");
        for (String key : keystoreProps.keySet()) {
            keystore.setAttribute(key, keystoreProps.get(key));
        }
        if (!keyProps.isEmpty()) {
            Element keyEntry = this.serverXml.createElement("keyEntry");
            for (String key : keyProps.keySet()) {
                keyEntry.setAttribute(key, keyProps.get(key));
            }
            keystore.appendChild(keyEntry);
        }
        this.serverRoot.appendChild(keystore);
    }

    public void addApplication(String appName) {
        Element appCfg = this.serverXml.createElement("application");
        appCfg.setAttribute("context-root", "/");
        appCfg.setAttribute("location", appName + "." + "war");
        appCfg.setAttribute("type", "war");
        this.serverRoot.appendChild(appCfg);
    }

    public void addHostname(String hostname) throws Exception {
        this.httpEndpoint.setAttribute("host", BoostUtil.makeVariable((String)"boost_http_host"));
        this.addConfigVariable("boost_http_host", hostname);
    }

    public void addHttpPort(String httpPort) throws Exception {
        this.httpEndpoint.setAttribute("httpPort", BoostUtil.makeVariable((String)"boost_http_port"));
        this.addConfigVariable("boost_http_port", httpPort);
    }

    public void addHttpsPort(String httpsPort) throws Exception {
        this.httpEndpoint.setAttribute("httpsPort", BoostUtil.makeVariable((String)"boost_http_securePort"));
        this.addConfigVariable("boost_http_securePort", httpsPort);
    }

    public Document getServerXmlDoc() {
        return this.serverXml;
    }

    private String getSecurityUtilCmd(String libertyInstallPath) {
        if (OSUtil.isWindows()) {
            return libertyInstallPath + "/bin/securityUtility.bat";
        }
        return libertyInstallPath + "/bin/securityUtility";
    }

    private String encrypt(String propertyKey, String propertyValue) throws IOException {
        if (!this.isEncoded(propertyValue)) {
            Runtime rt = Runtime.getRuntime();
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(this.getSecurityUtilCmd(this.libertyInstallPath));
            commands.add("encode");
            commands.add(propertyValue);
            String encryptionType = (String)BoostProperties.getPropertiesToEncrypt().get(propertyKey);
            if (encryptionType != null && !encryptionType.equals("")) {
                commands.add("--encoding=" + encryptionType);
            } else {
                commands.add("--encoding=aes");
            }
            if (this.encryptionKey != null && !this.encryptionKey.equals("")) {
                commands.add("--key=" + this.encryptionKey);
            }
            Process proc = rt.exec(commands.toArray(new String[0]));
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            String s = null;
            StringBuilder out = new StringBuilder();
            while ((s = stdInput.readLine()) != null) {
                out.append(s);
            }
            StringBuilder error = new StringBuilder();
            while ((s = stdError.readLine()) != null) {
                error.append(s + "\n");
            }
            if (error.length() != 0) {
                throw new IOException("Password encryption failed: " + error);
            }
            return out.toString();
        }
        return propertyValue;
    }

    public boolean isEncoded(String property) {
        return property.contains("{aes}") || property.contains("{hash}") || property.contains("{xor}");
    }

    public void addDataSource(Map<String, String> driverInfo, Properties datasourceProperties) throws Exception {
        String datasourcePropertiesElement = null;
        String driverName = driverInfo.get(JDBCBoosterConfig.DRIVER_NAME);
        if (driverName.equals(JDBCBoosterConfig.DERBY_DRIVER_NAME)) {
            datasourcePropertiesElement = "properties.derby.embedded";
        } else if (driverName.equals(JDBCBoosterConfig.DB2_DRIVER_NAME)) {
            datasourcePropertiesElement = "properties.db2.jcc";
        } else if (driverName.equals(JDBCBoosterConfig.MYSQL_DRIVER_NAME)) {
            datasourcePropertiesElement = "properties";
        } else if (driverName.equals(JDBCBoosterConfig.POSTGRESQL_DRIVER_NAME)) {
            datasourcePropertiesElement = "properties.postgresql";
        }
        Element lib = this.serverXml.createElement("library");
        lib.setAttribute("id", "Library1");
        Element fileLoc = this.serverXml.createElement("fileset");
        fileLoc.setAttribute("dir", "resources");
        fileLoc.setAttribute("includes", driverInfo.get(JDBCBoosterConfig.DRIVER_JAR));
        lib.appendChild(fileLoc);
        this.serverRoot.appendChild(lib);
        Element dataSource = this.serverXml.createElement("dataSource");
        dataSource.setAttribute("id", "DefaultDataSource");
        dataSource.setAttribute("jdbcDriverRef", "JdbcDriver1");
        Element props = this.serverXml.createElement(datasourcePropertiesElement);
        this.addDatasourceProperties(datasourceProperties, props);
        dataSource.appendChild(props);
        this.serverRoot.appendChild(dataSource);
        Element jdbcDriver = this.serverXml.createElement("jdbcDriver");
        jdbcDriver.setAttribute("id", "JdbcDriver1");
        jdbcDriver.setAttribute("libraryRef", "Library1");
        this.serverRoot.appendChild(jdbcDriver);
        this.addConfigVariables(datasourceProperties);
    }

    private void addDatasourceProperties(Properties serverProperties, Element propertiesElement) {
        for (String property : serverProperties.stringPropertyNames()) {
            String attribute = property.replace("boost_db_", "");
            propertiesElement.setAttribute(attribute, BoostUtil.makeVariable((String)property));
        }
    }

    public void addElementWithAttributes(String elementName, Map<String, String> attributes) {
        Element element = this.serverXml.createElement(elementName);
        for (String attributeName : attributes.keySet()) {
            element.setAttribute(attributeName, attributes.get(attributeName));
        }
        this.serverRoot.appendChild(element);
    }
}

