/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.boost.runtimes.openliberty;

import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.microshed.boost.common.BoostException;
import org.microshed.boost.common.BoostLoggerI;
import org.microshed.boost.common.boosters.AbstractBoosterConfig;
import org.microshed.boost.common.config.BoosterConfigurator;
import org.microshed.boost.common.runtimes.RuntimeI;
import org.microshed.boost.maven.runtimes.RuntimeParams;
import org.microshed.boost.maven.utils.BoostLogger;
import org.microshed.boost.maven.utils.MavenProjectUtil;
import org.microshed.boost.runtimes.openliberty.LibertyServerConfigGenerator;
import org.microshed.boost.runtimes.openliberty.boosters.LibertyBoosterI;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class LibertyRuntime
implements RuntimeI {
    private final List<AbstractBoosterConfig> boosterConfigs;
    private final Properties boostProperties;
    private final MojoExecutor.ExecutionEnvironment env;
    private final MavenProject project;
    private final Plugin mavenDepPlugin;
    private final String serverName = "defaultServer";
    private final String projectBuildDir;
    private final String libertyServerPath;
    private final String runtimeGroupId = "io.openliberty";
    private final String runtimeArtifactId = "openliberty-runtime";
    private final String runtimeVersion = "19.0.0.9";
    private String libertyMavenPluginGroupId = "io.openliberty.tools";
    private String libertyMavenPluginArtifactId = "liberty-maven-plugin";
    private String libertyMavenPluginVersion = "3.0.1";

    public LibertyRuntime() {
        this.boosterConfigs = null;
        this.boostProperties = null;
        this.env = null;
        this.project = null;
        this.projectBuildDir = null;
        this.libertyServerPath = null;
        this.mavenDepPlugin = null;
    }

    public LibertyRuntime(RuntimeParams runtimeParams) {
        this.boosterConfigs = runtimeParams.getBoosterConfigs();
        this.boostProperties = runtimeParams.getBoostProperties();
        this.env = runtimeParams.getEnv();
        this.project = runtimeParams.getProject();
        this.projectBuildDir = this.project.getBuild().getDirectory();
        this.libertyServerPath = this.projectBuildDir + "/liberty/wlp/usr/servers/" + "defaultServer";
        this.mavenDepPlugin = runtimeParams.getMavenDepPlugin();
    }

    private Plugin getPlugin() throws MojoExecutionException {
        return MojoExecutor.plugin((String)MojoExecutor.groupId((String)this.libertyMavenPluginGroupId), (String)MojoExecutor.artifactId((String)this.libertyMavenPluginArtifactId), (String)MojoExecutor.version((String)this.libertyMavenPluginVersion));
    }

    public void doPackage() throws BoostException {
        String javaCompilerTargetVersion = MavenProjectUtil.getJavaCompilerTargetVersion((MavenProject)this.project);
        System.setProperty("boost.internal.compiler.target", javaCompilerTargetVersion);
        try {
            this.packageLiberty(this.boosterConfigs);
        }
        catch (MojoExecutionException e) {
            throw new BoostException("Error packaging Liberty server", (Throwable)e);
        }
    }

    private void packageLiberty(List<AbstractBoosterConfig> boosterConfigs) throws MojoExecutionException {
        this.createLibertyServer();
        this.copyBoosterDependencies(boosterConfigs);
        this.generateServerConfig(boosterConfigs);
        this.installMissingFeatures();
        if (this.project.getPackaging().equals("war")) {
            this.installApp("all");
        } else {
            this.installApp("dependencies");
        }
        this.createUberJar();
    }

    private void copyBoosterDependencies(List<AbstractBoosterConfig> boosterConfigs) throws MojoExecutionException {
        List dependenciesToCopy = BoosterConfigurator.getDependenciesToCopy(boosterConfigs, (BoostLoggerI)BoostLogger.getSystemStreamLogger());
        for (String dep : dependenciesToCopy) {
            String[] dependencyInfo = dep.split(":");
            MojoExecutor.executeMojo((Plugin)this.mavenDepPlugin, (String)MojoExecutor.goal((String)"copy"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)(this.libertyServerPath + "/resources")), MojoExecutor.element((String)MojoExecutor.name((String)"artifactItems"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"artifactItem"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)dependencyInfo[0]), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)dependencyInfo[1]), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)dependencyInfo[2])})})}), (MojoExecutor.ExecutionEnvironment)this.env);
        }
    }

    private void generateServerConfig(List<AbstractBoosterConfig> boosterConfigs) throws MojoExecutionException {
        try {
            this.generateLibertyServerConfig(boosterConfigs);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to generate server configuration for the Liberty server.", e);
        }
    }

    private String getWarName() throws BoostException {
        String retVal = null;
        if (this.project.getPackaging().equals("war")) {
            retVal = this.project.getBuild().getFinalName();
        } else {
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!artifact.getType().equals("war")) continue;
                retVal = artifact.getArtifactId() + "-" + artifact.getVersion();
                break;
            }
            if (retVal == null) {
                BoostLogger log = BoostLogger.getSystemStreamLogger();
                String msg = "With non-WAR packaging type, we require a WAR dependency";
                log.error(msg);
                throw new BoostException(msg);
            }
        }
        return retVal;
    }

    private void generateLibertyServerConfig(List<AbstractBoosterConfig> boosterConfigurators) throws Exception {
        String encryptionKey = (String)this.boostProperties.get("boost_aes_key");
        LibertyServerConfigGenerator libertyConfig = new LibertyServerConfigGenerator(this.libertyServerPath, encryptionKey, (BoostLoggerI)BoostLogger.getSystemStreamLogger());
        String host = (String)this.boostProperties.getOrDefault((Object)"boost_http_host", "*");
        libertyConfig.addHostname(host);
        String httpPort = (String)this.boostProperties.getOrDefault((Object)"boost_http_port", "9080");
        libertyConfig.addHttpPort(httpPort);
        String httpsPort = (String)this.boostProperties.getOrDefault((Object)"boost_http_securePort", "9443");
        libertyConfig.addHttpsPort(httpsPort);
        String warName = this.getWarName();
        libertyConfig.addApplication(warName);
        for (AbstractBoosterConfig configurator : boosterConfigurators) {
            if (!(configurator instanceof LibertyBoosterI)) continue;
            ((LibertyBoosterI)configurator).addServerConfig(libertyConfig);
            libertyConfig.addFeature(((LibertyBoosterI)configurator).getFeature());
        }
        libertyConfig.writeToServer();
    }

    private void createLibertyServer() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)this.getPlugin(), (String)MojoExecutor.goal((String)"create"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"serverName"), (String)"defaultServer"), this.getRuntimeArtifactElement()}), (MojoExecutor.ExecutionEnvironment)this.env);
    }

    private void installMissingFeatures() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)this.getPlugin(), (String)MojoExecutor.goal((String)"install-feature"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"serverName"), (String)"defaultServer"), MojoExecutor.element((String)MojoExecutor.name((String)"features"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"acceptLicense"), (String)"false")})}), (MojoExecutor.ExecutionEnvironment)this.env);
    }

    private void installApp(String installAppPackagesVal) throws MojoExecutionException {
        MojoExecutor.Element deployPackages = MojoExecutor.element((String)MojoExecutor.name((String)"deployPackages"), (String)installAppPackagesVal);
        MojoExecutor.Element serverNameElement = MojoExecutor.element((String)MojoExecutor.name((String)"serverName"), (String)"defaultServer");
        Xpp3Dom configuration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{deployPackages, serverNameElement, this.getRuntimeArtifactElement()});
        configuration.addChild(MojoExecutor.element((String)MojoExecutor.name((String)"appsDirectory"), (String)"apps").toDom());
        MojoExecutor.executeMojo((Plugin)this.getPlugin(), (String)MojoExecutor.goal((String)"deploy"), (Xpp3Dom)configuration, (MojoExecutor.ExecutionEnvironment)this.env);
    }

    private MojoExecutor.Element getRuntimeArtifactElement() {
        return MojoExecutor.element((String)MojoExecutor.name((String)"assemblyArtifact"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)"io.openliberty"), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)"openliberty-runtime"), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)"19.0.0.9"), MojoExecutor.element((String)MojoExecutor.name((String)"type"), (String)"zip")});
    }

    private void createUberJar() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)this.getPlugin(), (String)MojoExecutor.goal((String)"package"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"isInstall"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"minify"), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)"target/liberty-alt-output-dir"), MojoExecutor.element((String)MojoExecutor.name((String)"packageType"), (String)"jar"), MojoExecutor.element((String)MojoExecutor.name((String)"serverName"), (String)"defaultServer")}), (MojoExecutor.ExecutionEnvironment)this.env);
    }

    public void doDebug(boolean clean) throws BoostException {
        try {
            MojoExecutor.executeMojo((Plugin)this.getPlugin(), (String)MojoExecutor.goal((String)"debug"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"serverName"), (String)"defaultServer"), MojoExecutor.element((String)MojoExecutor.name((String)"clean"), (String)String.valueOf(clean)), this.getRuntimeArtifactElement()}), (MojoExecutor.ExecutionEnvironment)this.env);
        }
        catch (MojoExecutionException e) {
            throw new BoostException("Error debugging Liberty server", (Throwable)e);
        }
    }

    public void doRun(boolean clean) throws BoostException {
        try {
            MojoExecutor.executeMojo((Plugin)this.getPlugin(), (String)MojoExecutor.goal((String)"run"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"serverName"), (String)"defaultServer"), MojoExecutor.element((String)MojoExecutor.name((String)"clean"), (String)String.valueOf(clean)), this.getRuntimeArtifactElement()}), (MojoExecutor.ExecutionEnvironment)this.env);
        }
        catch (MojoExecutionException e) {
            throw new BoostException("Error running Liberty server", (Throwable)e);
        }
    }

    public void doStart(boolean clean, int verifyTimeout, int serverStartTimeout) throws BoostException {
        try {
            MojoExecutor.executeMojo((Plugin)this.getPlugin(), (String)MojoExecutor.goal((String)"start"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"serverName"), (String)"defaultServer"), MojoExecutor.element((String)MojoExecutor.name((String)"verifyTimeout"), (String)String.valueOf(verifyTimeout)), MojoExecutor.element((String)MojoExecutor.name((String)"serverStartTimeout"), (String)String.valueOf(serverStartTimeout)), MojoExecutor.element((String)MojoExecutor.name((String)"clean"), (String)String.valueOf(clean)), this.getRuntimeArtifactElement()}), (MojoExecutor.ExecutionEnvironment)this.env);
        }
        catch (MojoExecutionException e) {
            throw new BoostException("Error starting Liberty server", (Throwable)e);
        }
    }

    public void doStop() throws BoostException {
        try {
            MojoExecutor.executeMojo((Plugin)this.getPlugin(), (String)MojoExecutor.goal((String)"stop"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"serverName"), (String)"defaultServer"), this.getRuntimeArtifactElement()}), (MojoExecutor.ExecutionEnvironment)this.env);
        }
        catch (MojoExecutionException e) {
            throw new BoostException("Error stopping Liberty server", (Throwable)e);
        }
    }
}

