/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.boost.maven.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.microshed.boost.maven.utils.BoostLogger;

public class MavenProjectUtil {
    public static Map<String, String> getAllDependencies(MavenProject project, RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepos, BoostLogger logger) throws ArtifactDescriptorException {
        logger.debug("Processing project for dependencies.");
        HashMap<String, String> dependencies = new HashMap<String, String>();
        for (org.apache.maven.artifact.Artifact artifact : project.getArtifacts()) {
            logger.debug("Found dependency while processing project: " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getType() + ":" + artifact.getScope());
            if (artifact.getType().equals("war")) {
                logger.debug("Resolving transitive booster dependencies for war");
                DefaultArtifact pomArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "pom", artifact.getVersion());
                List<Artifact> warArtifacts = MavenProjectUtil.getWarArtifacts((Artifact)pomArtifact, repoSystem, repoSession, remoteRepos);
                for (Artifact warArtifact : warArtifacts) {
                    if (!warArtifact.getGroupId().equals("org.microshed.boost.boosters")) continue;
                    logger.debug("Found booster dependency: " + warArtifact.getGroupId() + ":" + warArtifact.getArtifactId() + ":" + warArtifact.getVersion());
                    dependencies.put(warArtifact.getGroupId() + ":" + warArtifact.getArtifactId(), warArtifact.getVersion());
                }
                continue;
            }
            dependencies.put(artifact.getGroupId() + ":" + artifact.getArtifactId(), artifact.getVersion());
        }
        return dependencies;
    }

    public static String getJavaCompilerTargetVersion(MavenProject project) {
        Properties mavenProperties = project.getProperties();
        for (Map.Entry<Object, Object> property : mavenProperties.entrySet()) {
            String propertyKey = property.getKey().toString();
            String propertyValue = property.getValue().toString();
            if (!propertyKey.equals("maven.compiler.target") && !propertyKey.equals("maven.compiler.release")) continue;
            return propertyValue;
        }
        String release = io.openliberty.tools.maven.utils.MavenProjectUtil.getPluginConfiguration((MavenProject)project, (String)"org.apache.maven.plugins", (String)"maven-compiler-plugin", (String)"release");
        if (release != null) {
            return release;
        }
        String target = io.openliberty.tools.maven.utils.MavenProjectUtil.getPluginConfiguration((MavenProject)project, (String)"org.apache.maven.plugins", (String)"maven-compiler-plugin", (String)"target");
        if (target != null) {
            return target;
        }
        return "";
    }

    private static List<Artifact> getWarArtifacts(Artifact artifact, RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepos) throws ArtifactDescriptorException {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
        descriptorRequest.setArtifact(artifact);
        for (RemoteRepository remoteRepo : remoteRepos) {
            descriptorRequest.addRepository(remoteRepo);
        }
        ArtifactDescriptorResult descriptorResult = repoSystem.readArtifactDescriptor(repoSession, descriptorRequest);
        for (Dependency dependency : descriptorResult.getDependencies()) {
            artifacts.add(dependency.getArtifact());
        }
        return artifacts;
    }
}

