/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.boost.maven.plugin;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.pluginsupport.MojoSupport;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.microshed.boost.common.BoostLoggerI;
import org.microshed.boost.common.boosters.AbstractBoosterConfig;
import org.microshed.boost.common.config.BoostProperties;
import org.microshed.boost.common.config.BoosterConfigurator;
import org.microshed.boost.common.runtimes.RuntimeI;
import org.microshed.boost.maven.runtimes.RuntimeParams;
import org.microshed.boost.maven.utils.BoostLogger;
import org.microshed.boost.maven.utils.MavenProjectUtil;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class AbstractMojo
extends MojoSupport {
    private ClassLoader projectClassLoader;
    private List<AbstractBoosterConfig> boosterConfigs;
    private Properties boostProperties;
    protected String mavenDependencyPluginGroupId = "org.apache.maven.plugins";
    protected String mavenDependencyPluginArtifactId = "maven-dependency-plugin";
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    protected String projectBuildDir;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    protected List<RemoteRepository> remoteRepos;
    @Component
    protected BuildPluginManager pluginManager;
    @Component
    protected RepositorySystem repoSystem;
    protected Map<String, String> dependencies;

    protected Plugin getMavenDependencyPlugin() throws MojoExecutionException {
        return MojoExecutor.plugin((String)MojoExecutor.groupId((String)this.mavenDependencyPluginGroupId), (String)MojoExecutor.artifactId((String)this.mavenDependencyPluginArtifactId));
    }

    protected MojoExecutor.ExecutionEnvironment getExecutionEnvironment() {
        return MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager);
    }

    public void execute() throws MojoExecutionException {
        try {
            this.init();
            BoostLogger boostLogger = new BoostLogger(this.getLog());
            this.dependencies = MavenProjectUtil.getAllDependencies(this.project, this.repoSystem, this.repoSession, this.remoteRepos, boostLogger);
            ArrayList<File> compileClasspathJars = new ArrayList<File>();
            ArrayList<URL> pathUrls = new ArrayList<URL>();
            for (String compilePathElement : this.project.getCompileClasspathElements()) {
                pathUrls.add(new File(compilePathElement).toURI().toURL());
                if (!compilePathElement.endsWith(".jar")) continue;
                compileClasspathJars.add(new File(compilePathElement));
            }
            URL[] urlsForClassLoader = pathUrls.toArray(new URL[pathUrls.size()]);
            this.projectClassLoader = new URLClassLoader(urlsForClassLoader, ((Object)((Object)this)).getClass().getClassLoader());
            this.boostProperties = BoostProperties.getConfiguredBoostProperties((Properties)this.project.getProperties(), (BoostLoggerI)boostLogger);
            this.boosterConfigs = BoosterConfigurator.getBoosterConfigs(compileClasspathJars, (ClassLoader)this.projectClassLoader, this.dependencies, (Properties)this.boostProperties, (BoostLoggerI)boostLogger);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected RuntimeI getRuntimeInstance() throws MojoExecutionException {
        RuntimeI runtime = null;
        RuntimeParams params = new RuntimeParams(this.boosterConfigs, this.boostProperties, this.getExecutionEnvironment(), this.project, this.getLog(), this.repoSystem, this.repoSession, this.remoteRepos, this.getMavenDependencyPlugin());
        try {
            ServiceLoader<RuntimeI> runtimes = ServiceLoader.load(RuntimeI.class, this.projectClassLoader);
            if (!runtimes.iterator().hasNext()) {
                throw new MojoExecutionException("No target Boost runtime was detected. Please add a runtime and restart the build.");
            }
            for (RuntimeI runtimeI : runtimes) {
                if (runtime != null) {
                    throw new MojoExecutionException("There are multiple Boost runtimes on the classpath. Configure the project to use one runtime and restart the build.");
                }
                runtime = (RuntimeI)runtimeI.getClass().getConstructor(params.getClass()).newInstance(params);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new MojoExecutionException("Error while looking for Boost runtime.");
        }
        return runtime;
    }

    protected ClassLoader getProjectClassLoader() {
        return this.projectClassLoader;
    }
}

