/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.kubernetes.controller;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.microbean.development.annotation.Blocking;
import org.microbean.development.annotation.NonBlocking;
import org.microbean.kubernetes.controller.AbstractEvent;
import org.microbean.kubernetes.controller.Event;
import org.microbean.kubernetes.controller.EventCache;
import org.microbean.kubernetes.controller.EventQueue;
import org.microbean.kubernetes.controller.HasMetadatas;
import org.microbean.kubernetes.controller.SynchronizationEvent;

@ThreadSafe
public class EventQueueCollection<T extends HasMetadata>
implements EventCache<T>,
Supplier<EventQueue<T>>,
AutoCloseable {
    private final PropertyChangeSupport propertyChangeSupport;
    private volatile boolean closing;
    @GuardedBy(value="this")
    private boolean populated;
    @GuardedBy(value="this")
    private int initialPopulationCount;
    @GuardedBy(value="this")
    private final LinkedHashMap<Object, EventQueue<T>> eventQueueMap;
    @GuardedBy(value="itself")
    private final Map<?, ? extends T> knownObjects;
    @GuardedBy(value="this")
    private ScheduledExecutorService consumerExecutor;
    @GuardedBy(value="this")
    private Future<?> eventQueueConsumptionTask;
    private final Function<? super Throwable, Boolean> errorHandler;
    protected final Logger logger;

    public EventQueueCollection() {
        this(null, null, 16, 0.75f);
    }

    public EventQueueCollection(Map<?, ? extends T> knownObjects) {
        this(knownObjects, null, 16, 0.75f);
    }

    public EventQueueCollection(Map<?, ? extends T> knownObjects, int initialCapacity, float loadFactor) {
        this(knownObjects, null, initialCapacity, loadFactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventQueueCollection(Map<?, ? extends T> knownObjects, Function<? super Throwable, Boolean> errorHandler, int initialCapacity, float loadFactor) {
        String cn = this.getClass().getName();
        String mn = "<init>";
        this.logger = this.createLogger();
        if (this.logger == null) {
            throw new IllegalStateException();
        }
        if (this.logger.isLoggable(Level.FINER)) {
            String knownObjectsString;
            if (knownObjects == null) {
                knownObjectsString = null;
            } else {
                Map<?, T> map = knownObjects;
                synchronized (map) {
                    knownObjectsString = knownObjects.toString();
                }
            }
            this.logger.entering(cn, "<init>", new Object[]{knownObjectsString, initialCapacity, Float.valueOf(loadFactor)});
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.eventQueueMap = new LinkedHashMap(initialCapacity, loadFactor);
        this.knownObjects = knownObjects;
        this.errorHandler = errorHandler == null ? t -> {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.logp(Level.SEVERE, this.getClass().getName(), "<eventQueueConsumptionTask>", t.getMessage(), (Throwable)t);
            }
            return true;
        } : errorHandler;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "<init>");
        }
    }

    protected Logger createLogger() {
        return Logger.getLogger(this.getClass().getName());
    }

    private final Map<?, ? extends T> getKnownObjects() {
        return this.knownObjects;
    }

    private final synchronized boolean isEmpty() {
        return this.eventQueueMap.isEmpty();
    }

    public final synchronized boolean isSynchronized() {
        return this.populated && this.initialPopulationCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void synchronize() {
        String cn = this.getClass().getName();
        String mn = "synchronize";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "synchronize");
        }
        EventQueueCollection eventQueueCollection = this;
        synchronized (eventQueueCollection) {
            Map<?, T> knownObjects = this.getKnownObjects();
            if (knownObjects != null) {
                Map<?, T> map = knownObjects;
                synchronized (map) {
                    Collection<T> values;
                    if (!knownObjects.isEmpty() && (values = knownObjects.values()) != null && !values.isEmpty()) {
                        for (HasMetadata knownObject : values) {
                            EventQueue<T> eventQueue;
                            Object key;
                            if (knownObject == null || (key = this.getKey(knownObject)) == null || (eventQueue = this.eventQueueMap.get(key)) != null && !eventQueue.isEmpty()) continue;
                            this.addSynchronizationEvent(this, AbstractEvent.Type.MODIFICATION, knownObject);
                        }
                    }
                }
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "synchronize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public final synchronized void replace(Collection<? extends T> incomingResources, Object resourceVersion) {
        Set replacementKeys;
        int size;
        String cn = this.getClass().getName();
        String mn = "replace";
        if (this.logger.isLoggable(Level.FINER)) {
            String incomingResourcesString;
            if (incomingResources == null) {
                incomingResourcesString = null;
            } else {
                Collection<T> collection = incomingResources;
                synchronized (collection) {
                    incomingResourcesString = incomingResources.toString();
                }
            }
            this.logger.entering(cn, "replace", new Object[]{incomingResourcesString, resourceVersion});
        }
        boolean oldSynchronized = this.isSynchronized();
        if (incomingResources == null) {
            size = 0;
            replacementKeys = Collections.emptySet();
        } else {
            Collection<T> collection = incomingResources;
            synchronized (collection) {
                if (incomingResources.isEmpty()) {
                    size = 0;
                    replacementKeys = Collections.emptySet();
                } else {
                    size = incomingResources.size();
                    assert (size > 0);
                    replacementKeys = new HashSet();
                    for (Object resource : incomingResources) {
                        if (resource == null) continue;
                        replacementKeys.add(this.getKey(resource));
                        this.addSynchronizationEvent(this, AbstractEvent.Type.ADDITION, resource, false);
                    }
                }
            }
        }
        int queuedDeletions = 0;
        Map<?, T> knownObjects = this.getKnownObjects();
        if (knownObjects == null) {
            for (EventQueue eventQueue : this.eventQueueMap.values()) {
                void var13_21;
                Object key;
                assert (eventQueue != null);
                EventQueue eventQueue2 = eventQueue;
                synchronized (eventQueue2) {
                    if (eventQueue.isEmpty()) {
                        key = null;
                        Object var13_22 = null;
                        throw new IllegalStateException("eventQueue.isEmpty(): " + eventQueue);
                    }
                    key = eventQueue.getKey();
                    if (key == null) {
                        throw new IllegalStateException();
                    }
                    if (replacementKeys.contains(key)) {
                        Object var13_23 = null;
                    } else {
                        AbstractEvent abstractEvent = eventQueue.getLast();
                        assert (abstractEvent != null);
                    }
                }
                if (var13_21 == null) continue;
                assert (key != null);
                Object resourceToBeDeleted = var13_21.getResource();
                assert (resourceToBeDeleted != null);
                Event event = this.createEvent(this, AbstractEvent.Type.DELETION, resourceToBeDeleted);
                if (event == null) {
                    throw new IllegalStateException("createEvent() == null");
                }
                event.setKey(key);
                this.add(event, false);
            }
        } else {
            Object resource;
            assert (knownObjects != null);
            resource = knownObjects;
            synchronized (resource) {
                Set<Map.Entry<?, T>> set;
                if (!knownObjects.isEmpty() && (set = knownObjects.entrySet()) != null && !set.isEmpty()) {
                    for (Map.Entry entry : set) {
                        Object knownKey;
                        if (entry == null || replacementKeys.contains(knownKey = entry.getKey())) continue;
                        Event<HasMetadata> event = this.createEvent(this, AbstractEvent.Type.DELETION, (HasMetadata)entry.getValue());
                        if (event == null) {
                            throw new IllegalStateException("createEvent() == null");
                        }
                        event.setKey(knownKey);
                        this.add(event, false);
                        ++queuedDeletions;
                    }
                }
            }
        }
        if (!this.populated) {
            this.populated = true;
            assert (size >= 0);
            assert (queuedDeletions >= 0);
            int oldInitialPopulationCount = this.initialPopulationCount;
            this.initialPopulationCount = size + queuedDeletions;
            this.firePropertyChange("populated", false, true);
            this.firePropertyChange("initialPopulationCount", oldInitialPopulationCount, this.initialPopulationCount);
            if (this.initialPopulationCount == 0) {
                assert (this.isSynchronized());
                this.firePropertyChange("synchronized", oldSynchronized, true);
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "replace");
        }
    }

    protected Object getKey(T resource) {
        String cn = this.getClass().getName();
        String mn = "getKey";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "getKey", resource);
        }
        Object returnValue = HasMetadatas.getKey(resource);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "getKey", returnValue);
        }
        return returnValue;
    }

    protected EventQueue<T> createEventQueue(Object key) {
        String cn = this.getClass().getName();
        String mn = "createEventQueue";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "createEventQueue", key);
        }
        EventQueue returnValue = new EventQueue(key);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "createEventQueue", returnValue);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonBlocking
    public final Future<?> start(Consumer<? super EventQueue<? extends T>> eventQueueConsumer) {
        Future<?> returnValue;
        String cn = this.getClass().getName();
        String mn = "start";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "start", eventQueueConsumer);
        }
        Objects.requireNonNull(eventQueueConsumer);
        EventQueueCollection eventQueueCollection = this;
        synchronized (eventQueueCollection) {
            if (this.consumerExecutor == null) {
                this.consumerExecutor = EventQueueCollection.createScheduledThreadPoolExecutor();
                assert (this.consumerExecutor != null) : "createScheduledThreadPoolExecutor() == null";
            }
            if (this.eventQueueConsumptionTask == null) {
                this.eventQueueConsumptionTask = this.consumerExecutor.scheduleWithFixedDelay(this.createEventQueueConsumptionTask(eventQueueConsumer), 0L, 1L, TimeUnit.SECONDS);
            }
            assert (this.eventQueueConsumptionTask != null);
            returnValue = this.eventQueueConsumptionTask;
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "start", returnValue);
        }
        return returnValue;
    }

    private static final ScheduledThreadPoolExecutor createScheduledThreadPoolExecutor() {
        ScheduledThreadPoolExecutor returnValue = new ScheduledThreadPoolExecutor(1);
        returnValue.setRemoveOnCancelPolicy(true);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        String cn;
        block14: {
            cn = this.getClass().getName();
            String mn = "close";
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.entering(cn, "close");
            }
            this.closing = true;
            try {
                ScheduledExecutorService consumerExecutor;
                EventQueueCollection eventQueueCollection = this;
                synchronized (eventQueueCollection) {
                    if (this.eventQueueConsumptionTask != null) {
                        this.eventQueueConsumptionTask.cancel(true);
                        this.eventQueueConsumptionTask = null;
                    }
                    consumerExecutor = this.consumerExecutor;
                    this.consumerExecutor = null;
                }
                if (consumerExecutor == null) break block14;
                consumerExecutor.shutdown();
                consumerExecutor.shutdownNow();
                try {
                    if (!consumerExecutor.awaitTermination(60L, TimeUnit.SECONDS) && this.logger.isLoggable(Level.WARNING)) {
                        this.logger.logp(Level.WARNING, cn, "close", "this.consumerExecutor.awaitTermination() failed");
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                this.closing = false;
            }
        }
        assert (this.eventQueueConsumptionTask == null);
        assert (this.consumerExecutor == null);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "close");
        }
    }

    private final Runnable createEventQueueConsumptionTask(Consumer<? super EventQueue<? extends T>> eventQueueConsumer) {
        Objects.requireNonNull(eventQueueConsumer);
        Runnable returnValue = () -> {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    @Blocking Object eventQueue = this.get();
                    if (eventQueue == null) continue;
                    Throwable unhandledThrowable = null;
                    Object object = eventQueue;
                    synchronized (object) {
                        try {
                            eventQueueConsumer.accept((EventQueue<? extends T>)eventQueue);
                        }
                        catch (TransientException transientException) {
                            this.eventQueueMap.putIfAbsent(((EventQueue)eventQueue).getKey(), (EventQueue<T>)eventQueue);
                        }
                        catch (Throwable e) {
                            unhandledThrowable = e;
                        }
                    }
                    if (unhandledThrowable == null || this.errorHandler.apply(unhandledThrowable).booleanValue()) continue;
                    if (unhandledThrowable instanceof RuntimeException) {
                        throw (RuntimeException)unhandledThrowable;
                    }
                    if (unhandledThrowable instanceof Error) {
                        throw (Error)unhandledThrowable;
                    }
                    assert (!(unhandledThrowable instanceof Exception)) : "unhandledThrowable instanceof Exception: " + unhandledThrowable;
                }
            }
            catch (Error | RuntimeException unhandledRuntimeExceptionOrError) {
                if (this.logger.isLoggable(Level.SEVERE)) {
                    this.logger.logp(Level.SEVERE, this.getClass().getName(), "<eventQueueConsumptionTask>", unhandledRuntimeExceptionOrError.getMessage(), unhandledRuntimeExceptionOrError);
                }
                throw unhandledRuntimeExceptionOrError;
            }
        };
        return returnValue;
    }

    @Override
    @Blocking
    public final EventQueue<T> get() {
        String cn = this.getClass().getName();
        String mn = "get";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "get");
        }
        EventQueue<T> returnValue = null;
        try {
            returnValue = this.take();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            returnValue = null;
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "get", returnValue);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blocking
    private final EventQueue<T> take() throws InterruptedException {
        EventQueue<T> returnValue;
        String cn = this.getClass().getName();
        String mn = "take";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "take");
        }
        EventQueueCollection eventQueueCollection = this;
        synchronized (eventQueueCollection) {
            while (this.isEmpty() && !this.closing) {
                this.wait();
            }
            assert (this.populated) : "this.populated == false";
            if (this.isEmpty()) {
                assert (this.closing) : "this.isEmpty() && !this.closing";
                returnValue = null;
            } else {
                Iterator<EventQueue<T>> iterator = this.eventQueueMap.values().iterator();
                assert (iterator != null);
                assert (iterator.hasNext());
                returnValue = iterator.next();
                assert (returnValue != null);
                iterator.remove();
                if (this.initialPopulationCount > 0) {
                    assert (!this.isSynchronized());
                    int oldInitialPopulationCount = this.initialPopulationCount--;
                    this.firePropertyChange("initialPopulationCount", oldInitialPopulationCount, this.initialPopulationCount);
                    this.firePropertyChange("synchronized", false, this.isSynchronized());
                }
                this.firePropertyChange("empty", false, this.isEmpty());
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            String eventQueueString;
            EventQueue<T> eventQueue = returnValue;
            synchronized (eventQueue) {
                eventQueueString = returnValue.toString();
            }
            this.logger.exiting(cn, "take", eventQueueString);
        }
        return returnValue;
    }

    protected Event<T> createEvent(Object source, AbstractEvent.Type eventType, T resource) {
        String cn = this.getClass().getName();
        String mn = "createEvent";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "createEvent", new Object[]{source, eventType, resource});
        }
        Objects.requireNonNull(source);
        Objects.requireNonNull(eventType);
        Objects.requireNonNull(resource);
        Event<Object> returnValue = new Event<Object>(source, eventType, null, resource);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "createEvent", returnValue);
        }
        return returnValue;
    }

    protected SynchronizationEvent<T> createSynchronizationEvent(Object source, AbstractEvent.Type eventType, T resource) {
        String cn = this.getClass().getName();
        String mn = "createSynchronizationEvent";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "createSynchronizationEvent", new Object[]{source, eventType, resource});
        }
        Objects.requireNonNull(source);
        Objects.requireNonNull(eventType);
        Objects.requireNonNull(resource);
        SynchronizationEvent<Object> returnValue = new SynchronizationEvent<Object>(source, eventType, null, resource);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "createSynchronizationEvent", returnValue);
        }
        return returnValue;
    }

    private final SynchronizationEvent<T> addSynchronizationEvent(Object source, AbstractEvent.Type eventType, T resource) {
        return this.addSynchronizationEvent(source, eventType, resource, true);
    }

    private final SynchronizationEvent<T> addSynchronizationEvent(Object source, AbstractEvent.Type eventType, T resource, boolean populate) {
        String cn = this.getClass().getName();
        String mn = "addSynchronizationEvent";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "addSynchronizationEvent", new Object[]{source, eventType, resource, populate});
        }
        Objects.requireNonNull(source);
        Objects.requireNonNull(eventType);
        Objects.requireNonNull(resource);
        if (!eventType.equals((Object)AbstractEvent.Type.ADDITION) && !eventType.equals((Object)AbstractEvent.Type.MODIFICATION)) {
            throw new IllegalArgumentException("Illegal eventType: " + (Object)((Object)eventType));
        }
        SynchronizationEvent<T> event = this.createSynchronizationEvent(source, eventType, resource);
        if (event == null) {
            throw new IllegalStateException("createSynchronizationEvent() == null");
        }
        SynchronizationEvent<T> returnValue = this.add(event, populate);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "addSynchronizationEvent", returnValue);
        }
        return returnValue;
    }

    @Override
    public final Event<T> add(Object source, AbstractEvent.Type eventType, T resource) {
        return this.add(source, eventType, resource, true);
    }

    private final Event<T> add(Object source, AbstractEvent.Type eventType, T resource, boolean populate) {
        Event<T> event;
        String cn = this.getClass().getName();
        String mn = "add";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "add", new Object[]{source, eventType, resource, populate});
        }
        if ((event = this.createEvent(source, eventType, resource)) == null) {
            throw new IllegalStateException("createEvent() == null");
        }
        Event<T> returnValue = this.add(event, populate);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "add", returnValue);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <E extends AbstractEvent<T>> E add(E event, boolean populate) {
        String cn = this.getClass().getName();
        String mn = "add";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "add", new Object[]{event, populate});
        }
        if (this.closing) {
            throw new IllegalStateException();
        }
        Objects.requireNonNull(event);
        Object key = event.getKey();
        if (key == null) {
            throw new IllegalArgumentException("event.getKey() == null");
        }
        E returnValue = null;
        EventQueueCollection eventQueueCollection = this;
        synchronized (eventQueueCollection) {
            boolean eventQueueIsEmpty;
            boolean eventAdded;
            EventQueue<T> eventQueue;
            boolean eventQueueExisted;
            if (populate && !this.populated) {
                this.populated = true;
                this.firePropertyChange("populated", false, true);
            }
            boolean bl = eventQueueExisted = (eventQueue = this.eventQueueMap.get(key)) != null;
            if (!eventQueueExisted && (eventQueue = this.createEventQueue(key)) == null) {
                throw new IllegalStateException("createEventQueue(key) == null: " + key);
            }
            assert (eventQueue != null);
            EventQueue<T> eventQueue2 = eventQueue;
            synchronized (eventQueue2) {
                eventAdded = eventQueue.addEvent(event);
                eventQueueIsEmpty = eventQueue.isEmpty();
            }
            if (eventAdded) {
                returnValue = event;
            }
            if (eventQueueIsEmpty) {
                if (eventQueueExisted) {
                    returnValue = null;
                    boolean oldEmpty = this.isEmpty();
                    Object oldEventQueue = this.eventQueueMap.remove(key);
                    assert (oldEventQueue != null);
                    this.firePropertyChange("empty", oldEmpty, this.isEmpty());
                }
            } else if (!eventQueueExisted) {
                boolean oldEmpty = this.isEmpty();
                EventQueue<T> oldEventQueue = this.eventQueueMap.put(key, eventQueue);
                assert (oldEventQueue == null);
                this.firePropertyChange("empty", oldEmpty, this.isEmpty());
                this.notifyAll();
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "add", returnValue);
        }
        return returnValue;
    }

    public final void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeSupport.addPropertyChangeListener(name, listener);
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    public final void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeSupport.removePropertyChangeListener(name, listener);
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    public final PropertyChangeListener[] getPropertyChangeListeners(String name) {
        return this.propertyChangeSupport.getPropertyChangeListeners(name);
    }

    public final PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    protected final void firePropertyChange(String propertyName, Object old, Object newValue) {
        String cn = this.getClass().getName();
        String mn = "firePropertyChange";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "firePropertyChange", new Object[]{propertyName, old, newValue});
        }
        this.propertyChangeSupport.firePropertyChange(propertyName, old, newValue);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "firePropertyChange");
        }
    }

    protected final void firePropertyChange(String propertyName, int old, int newValue) {
        String cn = this.getClass().getName();
        String mn = "firePropertyChange";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "firePropertyChange", new Object[]{propertyName, old, newValue});
        }
        this.propertyChangeSupport.firePropertyChange(propertyName, old, newValue);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "firePropertyChange");
        }
    }

    protected final void firePropertyChange(String name, boolean old, boolean newValue) {
        String cn = this.getClass().getName();
        String mn = "firePropertyChange";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "firePropertyChange", new Object[]{name, old, newValue});
        }
        this.propertyChangeSupport.firePropertyChange(name, old, newValue);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "firePropertyChange");
        }
    }

    public static final class SynchronizationAwaitingPropertyChangeListener
    implements PropertyChangeListener {
        private final CountDownLatch latch = new CountDownLatch(1);

        @Override
        public final void propertyChange(PropertyChangeEvent event) {
            if (event != null && event.getSource() instanceof EventQueueCollection && "synchronized".equals(event.getPropertyName()) && Boolean.TRUE.equals(event.getNewValue())) {
                this.latch.countDown();
            }
        }

        @Blocking
        public final void await() throws InterruptedException {
            this.latch.await();
        }

        @Blocking
        public final boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
            return this.latch.await(timeout, timeUnit);
        }
    }

    public static final class TransientException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TransientException() {
        }

        public TransientException(String message) {
            super(message);
        }

        public TransientException(Throwable cause) {
            super(cause);
        }

        public TransientException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

