/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.kubernetes.controller;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.GuardedBy;
import org.microbean.kubernetes.controller.AbstractEvent;
import org.microbean.kubernetes.controller.Event;
import org.microbean.kubernetes.controller.EventQueue;
import org.microbean.kubernetes.controller.SynchronizationEvent;

public abstract class ResourceTrackingEventQueueConsumer<T extends HasMetadata>
implements Consumer<EventQueue<? extends T>> {
    @GuardedBy(value="itself")
    private final Map<Object, T> knownObjects;
    protected final Logger logger = this.createLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceTrackingEventQueueConsumer(Map<Object, T> knownObjects) {
        if (this.logger == null) {
            throw new IllegalStateException("createLogger() == null");
        }
        String cn = this.getClass().getName();
        String mn = "<init>";
        if (this.logger.isLoggable(Level.FINER)) {
            String knownObjectsString;
            if (knownObjects == null) {
                knownObjectsString = null;
            } else {
                Map<Object, T> map = knownObjects;
                synchronized (map) {
                    knownObjectsString = knownObjects.toString();
                }
            }
            this.logger.entering(cn, "<init>", knownObjectsString);
        }
        this.knownObjects = knownObjects;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "<init>");
        }
    }

    protected Logger createLogger() {
        return Logger.getLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void accept(EventQueue<? extends T> eventQueue) {
        String cn = this.getClass().getName();
        String mn = "accept";
        if (eventQueue == null) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.entering(cn, "accept", null);
            }
        } else {
            EventQueue<T> eventQueue2 = eventQueue;
            synchronized (eventQueue2) {
                Object key;
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.entering(cn, "accept", eventQueue);
                }
                if ((key = eventQueue.getKey()) == null) {
                    throw new IllegalStateException("eventQueue.getKey() == null; eventQueue: " + eventQueue);
                }
                for (AbstractEvent<T> event : eventQueue) {
                    Map<Object, T> map;
                    AbstractEvent<Object> newEvent;
                    HasMetadata priorResource;
                    if (event == null) continue;
                    assert (key.equals(event.getKey()));
                    AbstractEvent.Type eventType = event.getType();
                    assert (eventType != null);
                    T newResource = event.getResource();
                    if (event.getPriorResource() != null && this.logger.isLoggable(Level.FINE)) {
                        this.logger.logp(Level.FINE, cn, "accept", "Unexpected state; event has a priorResource: {0}", event.getPriorResource());
                    }
                    if (this.knownObjects == null) {
                        priorResource = null;
                        newEvent = event;
                    } else if (AbstractEvent.Type.DELETION.equals((Object)eventType)) {
                        map = this.knownObjects;
                        synchronized (map) {
                            priorResource = (HasMetadata)this.knownObjects.remove(key);
                        }
                        newEvent = event;
                    } else {
                        assert (eventType.equals((Object)AbstractEvent.Type.ADDITION) || eventType.equals((Object)AbstractEvent.Type.MODIFICATION));
                        map = this.knownObjects;
                        synchronized (map) {
                            priorResource = (HasMetadata)this.knownObjects.put(key, newResource);
                        }
                        if (event instanceof SynchronizationEvent) {
                            if (priorResource == null) {
                                assert (AbstractEvent.Type.ADDITION.equals((Object)eventType)) : "!Event.Type.ADDITION.equals(eventType): " + (Object)((Object)eventType);
                                newEvent = event;
                            } else {
                                assert (AbstractEvent.Type.MODIFICATION.equals((Object)eventType)) : "!Event.Type.MODIFICATION.equals(eventType): " + (Object)((Object)eventType);
                                newEvent = this.createSynchronizationEvent(AbstractEvent.Type.MODIFICATION, priorResource, newResource);
                            }
                        } else {
                            newEvent = priorResource == null ? (AbstractEvent.Type.ADDITION.equals((Object)eventType) ? event : this.createEvent(AbstractEvent.Type.ADDITION, null, newResource)) : this.createEvent(AbstractEvent.Type.MODIFICATION, priorResource, newResource);
                        }
                    }
                    assert (newEvent != null);
                    assert (newEvent instanceof SynchronizationEvent || newEvent instanceof Event);
                    this.accept(newEvent);
                }
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "accept");
        }
    }

    protected Event<T> createEvent(AbstractEvent.Type eventType, T priorResource, T resource) {
        String cn = this.getClass().getName();
        String mn = "createEvent";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "createEvent", new Object[]{eventType, priorResource, resource});
        }
        Objects.requireNonNull(eventType);
        Event<T> returnValue = new Event<T>(this, eventType, priorResource, resource);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "createEvent", returnValue);
        }
        return returnValue;
    }

    protected SynchronizationEvent<T> createSynchronizationEvent(AbstractEvent.Type eventType, T priorResource, T resource) {
        String cn = this.getClass().getName();
        String mn = "createSynchronizationEvent";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "createSynchronizationEvent", new Object[]{eventType, priorResource, resource});
        }
        Objects.requireNonNull(eventType);
        SynchronizationEvent<T> returnValue = new SynchronizationEvent<T>(this, eventType, priorResource, resource);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "createSynchronizationEvent", returnValue);
        }
        return returnValue;
    }

    @Override
    protected abstract void accept(AbstractEvent<? extends T> var1);
}

