/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.kubernetes.controller;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.VersionWatchable;
import io.fabric8.kubernetes.client.dsl.Versionable;
import io.fabric8.kubernetes.client.dsl.Watchable;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.dsl.internal.CustomResourceOperationsImpl;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import okhttp3.OkHttpClient;
import org.microbean.development.annotation.Issue;
import org.microbean.development.annotation.NonBlocking;
import org.microbean.kubernetes.controller.AbstractEvent;
import org.microbean.kubernetes.controller.EventCache;

@ThreadSafe
public class Reflector<T extends HasMetadata>
implements Closeable {
    private final Object operation;
    private volatile Object lastSynchronizationResourceVersion;
    private final ScheduledExecutorService synchronizationExecutorService;
    @GuardedBy(value="this")
    private ScheduledFuture<?> synchronizationTask;
    private final boolean shutdownSynchronizationExecutorServiceOnClose;
    private final long synchronizationIntervalInSeconds;
    @GuardedBy(value="this")
    private Closeable watch;
    @GuardedBy(value="itself")
    private final EventCache<T> eventCache;
    protected final Logger logger = this.createLogger();

    public <X extends Listable<? extends KubernetesResourceList> & VersionWatchable<? extends Closeable, Watcher<T>>> Reflector(X operation, EventCache<T> eventCache) {
        this(operation, eventCache, (ScheduledExecutorService)null, (Duration)null);
    }

    public <X extends Listable<? extends KubernetesResourceList> & VersionWatchable<? extends Closeable, Watcher<T>>> Reflector(X operation, EventCache<T> eventCache, Duration synchronizationInterval) {
        this(operation, eventCache, (ScheduledExecutorService)null, synchronizationInterval);
    }

    public <X extends Listable<? extends KubernetesResourceList> & VersionWatchable<? extends Closeable, Watcher<T>>> Reflector(X operation, EventCache<T> eventCache, ScheduledExecutorService synchronizationExecutorService, Duration synchronizationInterval) {
        if (this.logger == null) {
            throw new IllegalStateException("createLogger() == null");
        }
        String cn = this.getClass().getName();
        String mn = "<init>";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "<init>", new Object[]{operation, eventCache, synchronizationExecutorService, synchronizationInterval});
        }
        Objects.requireNonNull(operation);
        this.eventCache = Objects.requireNonNull(eventCache);
        this.operation = this.withResourceVersion((Versionable)operation, "0");
        this.synchronizationIntervalInSeconds = synchronizationInterval == null ? 0L : synchronizationInterval.get(ChronoUnit.SECONDS);
        if (this.synchronizationIntervalInSeconds <= 0L) {
            this.synchronizationExecutorService = null;
            this.shutdownSynchronizationExecutorServiceOnClose = false;
        } else if (synchronizationExecutorService == null) {
            this.synchronizationExecutorService = Executors.newScheduledThreadPool(1);
            this.shutdownSynchronizationExecutorServiceOnClose = true;
        } else {
            this.synchronizationExecutorService = synchronizationExecutorService;
            this.shutdownSynchronizationExecutorServiceOnClose = false;
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "<init>");
        }
    }

    protected Logger createLogger() {
        return Logger.getLogger(this.getClass().getName());
    }

    @Override
    public final synchronized void close() throws IOException {
        String cn = this.getClass().getName();
        String mn = "close";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "close");
        }
        try {
            this.closeSynchronizationExecutorService();
            if (this.watch != null) {
                this.watch.close();
            }
        }
        finally {
            this.onClose();
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "close");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final synchronized void closeSynchronizationExecutorService() {
        String cn = this.getClass().getName();
        String mn = "closeSynchronizationExecutorService";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "closeSynchronizationExecutorService");
        }
        if (this.synchronizationExecutorService != null && this.shutdownSynchronizationExecutorServiceOnClose) {
            this.synchronizationExecutorService.shutdown();
            ScheduledFuture<?> synchronizationTask = this.synchronizationTask;
            if (synchronizationTask != null) {
                synchronizationTask.cancel(true);
            }
            try {
                if (!this.synchronizationExecutorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.synchronizationExecutorService.shutdownNow();
                    if (this.synchronizationExecutorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                        // empty if block
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.synchronizationExecutorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "closeSynchronizationExecutorService");
        }
    }

    private final synchronized void setUpSynchronization() {
        String cn = this.getClass().getName();
        String mn = "setUpSynchronization";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "setUpSynchronization");
        }
        if (this.synchronizationExecutorService != null && this.synchronizationTask == null) {
            assert (this.synchronizationIntervalInSeconds > 0L);
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.logp(Level.INFO, cn, "setUpSynchronization", "Scheduling downstream synchronization every {0} seconds", this.synchronizationIntervalInSeconds);
            }
            ScheduledFuture<?> job = this.synchronizationExecutorService.scheduleWithFixedDelay(() -> {
                if (this.shouldSynchronize()) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.logp(Level.FINE, cn, "setUpSynchronization", "Synchronizing event cache with its downstream consumers");
                    }
                    EventCache<T> eventCache = this.eventCache;
                    synchronized (eventCache) {
                        this.eventCache.synchronize();
                    }
                }
            }, 0L, this.synchronizationIntervalInSeconds, TimeUnit.SECONDS);
            assert (job != null);
            this.synchronizationTask = job;
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "setUpSynchronization");
        }
    }

    protected boolean shouldSynchronize() {
        boolean returnValue;
        String cn = this.getClass().getName();
        String mn = "shouldSynchronize";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "shouldSynchronize");
        }
        boolean bl = returnValue = this.synchronizationExecutorService != null;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "shouldSynchronize", returnValue);
        }
        return returnValue;
    }

    private final Object getLastSynchronizationResourceVersion() {
        return this.lastSynchronizationResourceVersion;
    }

    private final void setLastSynchronizationResourceVersion(Object resourceVersion) {
        this.lastSynchronizationResourceVersion = resourceVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonBlocking
    public final void start() {
        String cn = this.getClass().getName();
        String mn = "start";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "start");
        }
        Reflector reflector = this;
        synchronized (reflector) {
            if (this.watch == null) {
                KubernetesResourceList list = (KubernetesResourceList)((Listable)this.operation).list();
                assert (list != null);
                ListMeta metadata = list.getMetadata();
                assert (metadata != null);
                String resourceVersion = metadata.getResourceVersion();
                assert (resourceVersion != null);
                List items = list.getItems();
                Collection<Object> replacementItems = items == null || items.isEmpty() ? Collections.emptySet() : Collections.unmodifiableCollection(new ArrayList(items));
                EventCache<T> eventCache = this.eventCache;
                synchronized (eventCache) {
                    this.eventCache.replace(replacementItems, resourceVersion);
                }
                this.setLastSynchronizationResourceVersion(resourceVersion);
                this.setUpSynchronization();
                Versionable versionableOperation = (Versionable)this.operation;
                this.watch = (Closeable)this.withResourceVersion(versionableOperation, resourceVersion).watch((Object)new WatchHandler());
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "start");
        }
    }

    protected synchronized void onClose() {
    }

    @Issue(id="kubernetes-client/1099", uri="https://github.com/fabric8io/kubernetes-client/issues/1099")
    private final @Issue(id="kubernetes-client/1099", uri="https://github.com/fabric8io/kubernetes-client/issues/1099") Watchable<? extends Closeable, Watcher<T>> withResourceVersion(Versionable<? extends Watchable<? extends Closeable, Watcher<T>>> operation, String resourceVersion) {
        Objects.requireNonNull(operation);
        Objects.requireNonNull(resourceVersion);
        Watchable returnValue = null;
        if (operation instanceof CustomResourceOperationsImpl) {
            CustomResourceOperationsImpl old = (CustomResourceOperationsImpl)operation;
            try {
                returnValue = new CustomResourceOperationsImpl(Reflector.getClient((OperationSupport)old), old.getConfig(), Reflector.getApiGroup((OperationSupport)old), old.getAPIVersion(), Reflector.getResourceT((OperationSupport)old), old.getNamespace(), old.getName(), old.isCascading(), (HasMetadata)old.getItem(), resourceVersion, old.isReloadingFromServer(), old.getType(), old.getListType(), old.getDoneableType());
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new KubernetesClientException(reflectiveOperationException.getMessage(), (Throwable)reflectiveOperationException);
            }
        } else {
            returnValue = (Watchable)operation.withResourceVersion("0");
        }
        assert (returnValue != null);
        return returnValue;
    }

    private static final OkHttpClient getClient(OperationSupport operation) throws ReflectiveOperationException {
        Objects.requireNonNull(operation);
        Field clientField = OperationSupport.class.getDeclaredField("client");
        assert (!clientField.isAccessible());
        assert (OkHttpClient.class.equals(clientField.getType()));
        OkHttpClient returnValue = null;
        try {
            clientField.setAccessible(true);
            returnValue = (OkHttpClient)clientField.get(operation);
        }
        finally {
            clientField.setAccessible(false);
        }
        return returnValue;
    }

    private static final String getApiGroup(OperationSupport operation) throws ReflectiveOperationException {
        Objects.requireNonNull(operation);
        Field apiGroupField = OperationSupport.class.getDeclaredField("apiGroup");
        assert (!apiGroupField.isAccessible());
        assert (String.class.equals(apiGroupField.getType()));
        String returnValue = null;
        try {
            apiGroupField.setAccessible(true);
            returnValue = (String)apiGroupField.get(operation);
        }
        finally {
            apiGroupField.setAccessible(false);
        }
        return returnValue;
    }

    private static final String getResourceT(OperationSupport operation) throws ReflectiveOperationException {
        Objects.requireNonNull(operation);
        Field resourceTField = OperationSupport.class.getDeclaredField("resourceT");
        assert (!resourceTField.isAccessible());
        assert (String.class.equals(resourceTField.getType()));
        String returnValue = null;
        try {
            resourceTField.setAccessible(true);
            returnValue = (String)resourceTField.get(operation);
        }
        finally {
            resourceTField.setAccessible(false);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map<String, String> getFields(BaseOperation<?, ?, ?, ?> operation) throws ReflectiveOperationException {
        Objects.requireNonNull(operation);
        Method getFieldsMethod = BaseOperation.class.getDeclaredMethod("getFields", new Class[0]);
        assert (!getFieldsMethod.isAccessible());
        assert (Map.class.equals(getFieldsMethod.getReturnType()));
        Map returnValue = null;
        try {
            Map temp;
            getFieldsMethod.setAccessible(true);
            returnValue = temp = (Map)getFieldsMethod.invoke(operation, new Object[0]);
        }
        finally {
            getFieldsMethod.setAccessible(false);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map<String, String> getLabels(BaseOperation<?, ?, ?, ?> operation) throws ReflectiveOperationException {
        Objects.requireNonNull(operation);
        Method getLabelsMethod = BaseOperation.class.getDeclaredMethod("getLabels", new Class[0]);
        assert (!getLabelsMethod.isAccessible());
        assert (Map.class.equals(getLabelsMethod.getReturnType()));
        Map returnValue = null;
        try {
            Map temp;
            getLabelsMethod.setAccessible(true);
            returnValue = temp = (Map)getLabelsMethod.invoke(operation, new Object[0]);
        }
        finally {
            getLabelsMethod.setAccessible(false);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map<String, String[]> getLabelsIn(BaseOperation<?, ?, ?, ?> operation) throws ReflectiveOperationException {
        Objects.requireNonNull(operation);
        Method getLabelsInMethod = BaseOperation.class.getDeclaredMethod("getLabelsIn", new Class[0]);
        assert (!getLabelsInMethod.isAccessible());
        assert (Map.class.equals(getLabelsInMethod.getReturnType()));
        Map returnValue = null;
        try {
            Map temp;
            getLabelsInMethod.setAccessible(true);
            returnValue = temp = (Map)getLabelsInMethod.invoke(operation, new Object[0]);
        }
        finally {
            getLabelsInMethod.setAccessible(false);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map<String, String> getLabelsNot(BaseOperation<?, ?, ?, ?> operation) throws ReflectiveOperationException {
        Objects.requireNonNull(operation);
        Method getLabelsNotMethod = BaseOperation.class.getDeclaredMethod("getLabelsNot", new Class[0]);
        assert (!getLabelsNotMethod.isAccessible());
        assert (Map.class.equals(getLabelsNotMethod.getReturnType()));
        Map returnValue = null;
        try {
            Map temp;
            getLabelsNotMethod.setAccessible(true);
            returnValue = temp = (Map)getLabelsNotMethod.invoke(operation, new Object[0]);
        }
        finally {
            getLabelsNotMethod.setAccessible(false);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map<String, String[]> getLabelsNotIn(BaseOperation<?, ?, ?, ?> operation) throws ReflectiveOperationException {
        Objects.requireNonNull(operation);
        Method getLabelsNotInMethod = BaseOperation.class.getDeclaredMethod("getLabelsNotIn", new Class[0]);
        assert (!getLabelsNotInMethod.isAccessible());
        assert (Map.class.equals(getLabelsNotInMethod.getReturnType()));
        Map returnValue = null;
        try {
            Map temp;
            getLabelsNotInMethod.setAccessible(true);
            returnValue = temp = (Map)getLabelsNotInMethod.invoke(operation, new Object[0]);
        }
        finally {
            getLabelsNotInMethod.setAccessible(false);
        }
        return returnValue;
    }

    private final class WatchHandler
    implements Watcher<T> {
        private WatchHandler() {
            String cn = this.getClass().getName();
            String mn = "<init>";
            if (Reflector.this.logger.isLoggable(Level.FINER)) {
                Reflector.this.logger.entering(cn, "<init>");
                Reflector.this.logger.exiting(cn, "<init>");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void eventReceived(Watcher.Action action, T resource) {
            AbstractEvent.Type eventType;
            String cn = this.getClass().getName();
            String mn = "eventReceived";
            if (Reflector.this.logger.isLoggable(Level.FINER)) {
                Reflector.this.logger.entering(cn, "eventReceived", new Object[]{action, resource});
            }
            Objects.requireNonNull(action);
            Objects.requireNonNull(resource);
            ObjectMeta metadata = resource.getMetadata();
            assert (metadata != null);
            switch (action) {
                case ADDED: {
                    eventType = AbstractEvent.Type.ADDITION;
                    break;
                }
                case MODIFIED: {
                    eventType = AbstractEvent.Type.MODIFICATION;
                    break;
                }
                case DELETED: {
                    eventType = AbstractEvent.Type.DELETION;
                    break;
                }
                default: {
                    Object eventType2 = null;
                    throw new IllegalStateException();
                }
            }
            if (eventType != null) {
                if (Reflector.this.logger.isLoggable(Level.FINE)) {
                    Reflector.this.logger.logp(Level.FINE, cn, "eventReceived", "Adding event to cache: {0} {1}", new Object[]{eventType, resource});
                }
                EventCache eventCache = Reflector.this.eventCache;
                synchronized (eventCache) {
                    Reflector.this.eventCache.add(Reflector.this, eventType, resource);
                }
            }
            Reflector.this.setLastSynchronizationResourceVersion(metadata.getResourceVersion());
            if (Reflector.this.logger.isLoggable(Level.FINER)) {
                Reflector.this.logger.exiting(cn, "eventReceived");
            }
        }

        public final void onClose(KubernetesClientException exception) {
            String cn = this.getClass().getName();
            String mn = "onClose";
            if (Reflector.this.logger.isLoggable(Level.FINER)) {
                Reflector.this.logger.entering(cn, "onClose", exception);
            }
            if (exception != null && Reflector.this.logger.isLoggable(Level.WARNING)) {
                Reflector.this.logger.logp(Level.WARNING, cn, "onClose", exception.getMessage(), (Throwable)exception);
            }
            if (Reflector.this.logger.isLoggable(Level.FINER)) {
                Reflector.this.logger.exiting(cn, "onClose", exception);
            }
        }
    }
}

