/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.kubernetes.controller;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.VersionWatchable;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.microbean.development.annotation.NonBlocking;
import org.microbean.kubernetes.controller.AbstractEvent;
import org.microbean.kubernetes.controller.Event;
import org.microbean.kubernetes.controller.EventQueue;
import org.microbean.kubernetes.controller.EventQueueCollection;
import org.microbean.kubernetes.controller.HasMetadatas;
import org.microbean.kubernetes.controller.Reflector;

@Immutable
@ThreadSafe
public class Controller<T extends HasMetadata>
implements Closeable {
    protected final Logger logger = this.createLogger();
    private final Reflector<T> reflector;
    private final EventQueueCollection<T> eventCache;
    private final Consumer<? super EventQueue<? extends T>> siphon;

    public <X extends Listable<? extends KubernetesResourceList> & VersionWatchable<? extends Closeable, Watcher<T>>> Controller(X operation, Consumer<? super EventQueue<? extends T>> siphon) {
        this(operation, (ScheduledExecutorService)null, (Duration)null, (Map<Object, T>)null, (Consumer<EventQueue<T>>)siphon);
    }

    public <X extends Listable<? extends KubernetesResourceList> & VersionWatchable<? extends Closeable, Watcher<T>>> Controller(X operation, Map<Object, T> knownObjects, Consumer<? super EventQueue<? extends T>> siphon) {
        this(operation, (ScheduledExecutorService)null, (Duration)null, knownObjects, (Consumer<EventQueue<T>>)siphon);
    }

    public <X extends Listable<? extends KubernetesResourceList> & VersionWatchable<? extends Closeable, Watcher<T>>> Controller(X operation, Duration synchronizationInterval, Consumer<? super EventQueue<? extends T>> siphon) {
        this(operation, (ScheduledExecutorService)null, synchronizationInterval, (Map<Object, T>)null, (Consumer<EventQueue<T>>)siphon);
    }

    public <X extends Listable<? extends KubernetesResourceList> & VersionWatchable<? extends Closeable, Watcher<T>>> Controller(X operation, Duration synchronizationInterval, Map<Object, T> knownObjects, Consumer<? super EventQueue<? extends T>> siphon) {
        this(operation, (ScheduledExecutorService)null, synchronizationInterval, knownObjects, (Consumer<EventQueue<T>>)siphon);
    }

    public <X extends Listable<? extends KubernetesResourceList> & VersionWatchable<? extends Closeable, Watcher<T>>> Controller(X operation, ScheduledExecutorService synchronizationExecutorService, Duration synchronizationInterval, Map<Object, T> knownObjects, Consumer<? super EventQueue<? extends T>> siphon) {
        if (this.logger == null) {
            throw new IllegalStateException("createLogger() == null");
        }
        String cn = this.getClass().getName();
        String mn = "<init>";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "<init>", new Object[]{operation, synchronizationExecutorService, synchronizationInterval, knownObjects, siphon});
        }
        this.siphon = Objects.requireNonNull(siphon);
        this.eventCache = new ControllerEventQueueCollection(knownObjects);
        this.reflector = new ControllerReflector(this, (Listable)operation, synchronizationExecutorService, synchronizationInterval);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "<init>");
        }
    }

    protected Logger createLogger() {
        return Logger.getLogger(this.getClass().getName());
    }

    @NonBlocking
    public final void start() {
        String cn = this.getClass().getName();
        String mn = "start";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "start");
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.logp(Level.INFO, cn, "start", "Starting {0}", this.siphon);
        }
        Future<?> siphonTask = this.eventCache.start(this.siphon);
        assert (siphonTask != null);
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.logp(Level.INFO, cn, "start", "Starting {0}", this.reflector);
        }
        try {
            this.reflector.start();
        }
        catch (RuntimeException runtimeException) {
            try {
                this.reflector.close();
            }
            catch (IOException suppressMe) {
                runtimeException.addSuppressed(suppressMe);
            }
            siphonTask.cancel(true);
            assert (siphonTask.isDone());
            try {
                this.eventCache.close();
            }
            catch (RuntimeException suppressMe) {
                runtimeException.addSuppressed(suppressMe);
            }
            throw runtimeException;
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "start");
        }
    }

    @Override
    public final void close() throws IOException {
        String cn = this.getClass().getName();
        String mn = "close";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "close");
        }
        Exception throwMe = null;
        try {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.logp(Level.INFO, cn, "close", "Closing {0}", this.reflector);
            }
            this.reflector.close();
        }
        catch (Exception everything) {
            throwMe = everything;
        }
        try {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.logp(Level.INFO, cn, "close", "Closing {0}", this.eventCache);
            }
            this.eventCache.close();
        }
        catch (RuntimeException runtimeException) {
            if (throwMe == null) {
                throw runtimeException;
            }
            throwMe.addSuppressed(runtimeException);
        }
        if (throwMe instanceof IOException) {
            throw (IOException)throwMe;
        }
        if (throwMe instanceof RuntimeException) {
            throw (RuntimeException)throwMe;
        }
        if (throwMe != null) {
            throw new IllegalStateException(throwMe.getMessage(), throwMe);
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "close");
        }
    }

    protected boolean shouldSynchronize() {
        String cn = this.getClass().getName();
        String mn = "shouldSynchronize";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "shouldSynchronize");
        }
        boolean returnValue = true;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "shouldSynchronize", true);
        }
        return true;
    }

    protected void onClose() {
    }

    protected Object getKey(T resource) {
        String cn = this.getClass().getName();
        String mn = "getKey";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "getKey", resource);
        }
        Object returnValue = HasMetadatas.getKey((HasMetadata)Objects.requireNonNull(resource));
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "getKey", returnValue);
        }
        return returnValue;
    }

    protected Event<T> createEvent(Object source, AbstractEvent.Type eventType, T resource) {
        String cn = this.getClass().getName();
        String mn = "createEvent";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "createEvent", new Object[]{source, eventType, resource});
        }
        Event<HasMetadata> returnValue = new Event<HasMetadata>(Objects.requireNonNull(source), Objects.requireNonNull(eventType), null, (HasMetadata)Objects.requireNonNull(resource));
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "createEvent", returnValue);
        }
        return returnValue;
    }

    protected EventQueue<T> createEventQueue(Object key) {
        String cn = this.getClass().getName();
        String mn = "createEventQueue";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "createEventQueue", key);
        }
        EventQueue returnValue = new EventQueue(key);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "createEventQueue", returnValue);
        }
        return returnValue;
    }

    private static final class ControllerReflector
    extends Reflector<T> {
        final /* synthetic */ Controller this$0;

        private <X extends Listable<? extends KubernetesResourceList> & VersionWatchable<? extends Closeable, Watcher<T>>> ControllerReflector(X operation, ScheduledExecutorService synchronizationExecutorService, Duration synchronizationInterval) {
            this.this$0 = var1_1;
            super(operation, ((Controller)var1_1).eventCache, synchronizationExecutorService, synchronizationInterval);
        }

        @Override
        protected final boolean shouldSynchronize() {
            return this.this$0.shouldSynchronize();
        }

        @Override
        protected final void onClose() {
            this.this$0.onClose();
        }
    }

    private final class ControllerEventQueueCollection
    extends EventQueueCollection<T> {
        private ControllerEventQueueCollection(Map<?, ? extends T> knownObjects) {
            super(knownObjects);
        }

        @Override
        protected final Event<T> createEvent(Object source, AbstractEvent.Type eventType, T resource) {
            return Controller.this.createEvent(source, eventType, resource);
        }

        @Override
        protected final EventQueue<T> createEventQueue(Object key) {
            return Controller.this.createEventQueue(key);
        }

        @Override
        protected final Object getKey(T resource) {
            return Controller.this.getKey(resource);
        }
    }
}

