/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.kubernetes.controller;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.EventObject;
import java.util.Objects;
import org.microbean.kubernetes.controller.Event;
import org.microbean.kubernetes.controller.HasMetadatas;
import org.microbean.kubernetes.controller.SynchronizationEvent;

public abstract class AbstractEvent<T extends HasMetadata>
extends EventObject {
    private static final long serialVersionUID = 1L;
    private volatile Object key;
    private final Type type;
    private final T priorResource;
    private final T resource;

    private AbstractEvent() {
        this(null, null, null, null);
    }

    AbstractEvent(Object source, Type type, T priorResource, T resource) {
        super(source);
        if (!Event.class.isAssignableFrom(this.getClass()) && !SynchronizationEvent.class.isAssignableFrom(this.getClass())) {
            throw new IllegalStateException("Unexpected subclass");
        }
        this.type = Objects.requireNonNull(type);
        this.priorResource = priorResource;
        this.resource = (HasMetadata)Objects.requireNonNull(resource);
    }

    public final Type getType() {
        return this.type;
    }

    public final T getPriorResource() {
        return this.priorResource;
    }

    public final T getResource() {
        return this.resource;
    }

    public final boolean isFinalStateKnown() {
        return this.key == null;
    }

    final void setKey(Object key) {
        this.key = key;
    }

    public Object getKey() {
        Object returnValue = this.key;
        if (returnValue == null) {
            returnValue = HasMetadatas.getKey(this.getResource());
        }
        return returnValue;
    }

    public int hashCode() {
        int hashCode = 37;
        Object source = this.getSource();
        int c = source == null ? 0 : source.hashCode();
        hashCode = hashCode * 17 + c;
        Object key = this.getKey();
        c = key == null ? 0 : key.hashCode();
        hashCode = hashCode * 17 + c;
        Type type = this.getType();
        c = type == null ? 0 : ((Object)((Object)type)).hashCode();
        hashCode = hashCode * 17 + c;
        T resource = this.getResource();
        c = resource == null ? 0 : resource.hashCode();
        hashCode = hashCode * 17 + c;
        T priorResource = this.getPriorResource();
        c = priorResource == null ? 0 : priorResource.hashCode();
        hashCode = hashCode * 17 + c;
        return hashCode;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof AbstractEvent) {
            AbstractEvent her = (AbstractEvent)other;
            Object source = this.getSource();
            if (source == null ? her.getSource() != null : !source.equals(her.getSource())) {
                return false;
            }
            Object key = this.getKey();
            if (key == null ? her.getKey() != null : !key.equals(her.getKey())) {
                return false;
            }
            Type type = this.getType();
            if (type == null ? her.getType() != null : !((Object)((Object)type)).equals((Object)her.getType())) {
                return false;
            }
            T resource = this.getResource();
            if (resource == null ? her.getResource() != null : !resource.equals(her.getResource())) {
                return false;
            }
            T priorResource = this.getPriorResource();
            return !(priorResource == null ? her.getPriorResource() != null : !priorResource.equals(her.getPriorResource()));
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append((Object)this.getType()).append(": ");
        T priorResource = this.getPriorResource();
        if (priorResource != null) {
            sb.append(priorResource).append(" --> ");
        }
        sb.append(this.getResource());
        return sb.toString();
    }

    public static enum Type {
        ADDITION,
        MODIFICATION,
        DELETION;

    }
}

