/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.kubernetes.controller;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.microbean.development.annotation.Blocking;
import org.microbean.development.annotation.NonBlocking;
import org.microbean.kubernetes.controller.AbstractEvent;
import org.microbean.kubernetes.controller.Event;
import org.microbean.kubernetes.controller.EventCache;
import org.microbean.kubernetes.controller.EventQueue;
import org.microbean.kubernetes.controller.HasMetadatas;
import org.microbean.kubernetes.controller.SynchronizationEvent;

@ThreadSafe
public class EventQueueCollection<T extends HasMetadata>
implements EventCache<T>,
Supplier<EventQueue<T>>,
AutoCloseable {
    private final PropertyChangeSupport propertyChangeSupport;
    private volatile boolean closing;
    @GuardedBy(value="this")
    private boolean populated;
    @GuardedBy(value="this")
    private int initialPopulationCount;
    @GuardedBy(value="this")
    private final LinkedHashMap<Object, EventQueue<T>> map;
    @GuardedBy(value="itself")
    private final Map<?, ? extends T> knownObjects;
    @GuardedBy(value="this")
    private ScheduledExecutorService consumerExecutor;
    protected final Logger logger;

    public EventQueueCollection() {
        this(null, 16, 0.75f);
    }

    public EventQueueCollection(Map<?, ? extends T> knownObjects) {
        this(knownObjects, 16, 0.75f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventQueueCollection(Map<?, ? extends T> knownObjects, int initialCapacity, float loadFactor) {
        String cn = this.getClass().getName();
        String mn = "<init>";
        this.logger = this.createLogger();
        if (this.logger == null) {
            throw new IllegalStateException();
        }
        if (this.logger.isLoggable(Level.FINER)) {
            String knownObjectsString;
            if (knownObjects == null) {
                knownObjectsString = null;
            } else {
                Map<?, T> map = knownObjects;
                synchronized (map) {
                    knownObjectsString = knownObjects.toString();
                }
            }
            this.logger.entering(cn, "<init>", new Object[]{knownObjectsString, initialCapacity, Float.valueOf(loadFactor)});
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.map = new LinkedHashMap(initialCapacity, loadFactor);
        this.knownObjects = knownObjects;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "<init>");
        }
    }

    protected Logger createLogger() {
        return Logger.getLogger(this.getClass().getName());
    }

    private final Map<?, ? extends T> getKnownObjects() {
        return this.knownObjects;
    }

    private final synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    public final synchronized boolean isSynchronized() {
        return this.populated && this.initialPopulationCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void synchronize() {
        String cn = this.getClass().getName();
        String mn = "synchronize";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "synchronize");
        }
        EventQueueCollection eventQueueCollection = this;
        synchronized (eventQueueCollection) {
            Map<?, T> knownObjects = this.getKnownObjects();
            if (knownObjects != null) {
                Map<?, T> map = knownObjects;
                synchronized (map) {
                    Collection<T> values;
                    if (!knownObjects.isEmpty() && (values = knownObjects.values()) != null && !values.isEmpty()) {
                        for (HasMetadata knownObject : values) {
                            EventQueue<T> eventQueue;
                            Object key;
                            if (knownObject == null || (key = this.getKey(knownObject)) == null || (eventQueue = this.map.get(key)) != null && !eventQueue.isEmpty()) continue;
                            this.synchronize(this, AbstractEvent.Type.MODIFICATION, knownObject, true);
                        }
                    }
                }
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "synchronize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public final synchronized void replace(Collection<? extends T> incomingResources, Object resourceVersion) {
        Set replacementKeys;
        int size;
        String cn = this.getClass().getName();
        String mn = "replace";
        if (this.logger.isLoggable(Level.FINER)) {
            String incomingResourcesString;
            if (incomingResources == null) {
                incomingResourcesString = null;
            } else {
                Collection<T> collection = incomingResources;
                synchronized (collection) {
                    incomingResourcesString = incomingResources.toString();
                }
            }
            this.logger.entering(cn, "replace", new Object[]{incomingResourcesString, resourceVersion});
        }
        boolean oldSynchronized = this.isSynchronized();
        if (incomingResources == null) {
            size = 0;
            replacementKeys = Collections.emptySet();
        } else {
            Collection<T> collection = incomingResources;
            synchronized (collection) {
                if (incomingResources.isEmpty()) {
                    size = 0;
                    replacementKeys = Collections.emptySet();
                } else {
                    size = incomingResources.size();
                    assert (size > 0);
                    replacementKeys = new HashSet();
                    for (Object resource : incomingResources) {
                        if (resource == null) continue;
                        replacementKeys.add(this.getKey(resource));
                        this.synchronize(this, AbstractEvent.Type.ADDITION, resource, false);
                    }
                }
            }
        }
        int queuedDeletions = 0;
        Map<?, T> knownObjects = this.getKnownObjects();
        if (knownObjects == null) {
            for (EventQueue eventQueue : this.map.values()) {
                void var13_21;
                Object key;
                assert (eventQueue != null);
                EventQueue eventQueue2 = eventQueue;
                synchronized (eventQueue2) {
                    if (eventQueue.isEmpty()) {
                        Object var13_22 = null;
                        key = null;
                        assert (false) : "eventQueue.isEmpty(): " + eventQueue;
                    } else {
                        key = eventQueue.getKey();
                        if (key == null) {
                            throw new IllegalStateException();
                        }
                        if (replacementKeys.contains(key)) {
                            Object var13_23 = null;
                        } else {
                            AbstractEvent abstractEvent = eventQueue.getLast();
                            assert (abstractEvent != null);
                        }
                    }
                }
                if (var13_21 == null) continue;
                assert (key != null);
                Object resourceToBeDeleted = var13_21.getResource();
                assert (resourceToBeDeleted != null);
                Event event = this.createEvent(this, AbstractEvent.Type.DELETION, resourceToBeDeleted);
                if (event == null) {
                    throw new IllegalStateException("createEvent() == null");
                }
                event.setKey(key);
                this.add(event, false);
            }
        } else {
            Object resource;
            resource = knownObjects;
            synchronized (resource) {
                Set<Map.Entry<?, T>> set;
                if (!knownObjects.isEmpty() && (set = knownObjects.entrySet()) != null && !set.isEmpty()) {
                    for (Map.Entry entry : set) {
                        Object knownKey;
                        if (entry == null || replacementKeys.contains(knownKey = entry.getKey())) continue;
                        Event<HasMetadata> event = this.createEvent(this, AbstractEvent.Type.DELETION, (HasMetadata)entry.getValue());
                        if (event == null) {
                            throw new IllegalStateException("createEvent() == null");
                        }
                        event.setKey(knownKey);
                        this.add(event, false);
                        ++queuedDeletions;
                    }
                }
            }
        }
        if (!this.populated) {
            this.populated = true;
            this.firePropertyChange("populated", false, true);
            assert (size >= 0);
            assert (queuedDeletions >= 0);
            int oldInitialPopulationCount = this.initialPopulationCount;
            this.initialPopulationCount = size + queuedDeletions;
            this.firePropertyChange("initialPopulationCount", oldInitialPopulationCount, this.initialPopulationCount);
            if (this.initialPopulationCount == 0) {
                this.firePropertyChange("synchronized", oldSynchronized, true);
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "replace");
        }
    }

    protected Object getKey(T resource) {
        String cn = this.getClass().getName();
        String mn = "getKey";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "getKey", resource);
        }
        Object returnValue = HasMetadatas.getKey(resource);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "getKey", returnValue);
        }
        return returnValue;
    }

    protected EventQueue<T> createEventQueue(Object key) {
        String cn = this.getClass().getName();
        String mn = "createEventQueue";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "createEventQueue", key);
        }
        EventQueue returnValue = new EventQueue(key);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "createEventQueue", returnValue);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonBlocking
    public final Future<?> start(Consumer<? super EventQueue<? extends T>> siphon) {
        ScheduledFuture<?> returnValue;
        String cn = this.getClass().getName();
        String mn = "start";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "start", siphon);
        }
        Objects.requireNonNull(siphon);
        EventQueueCollection eventQueueCollection = this;
        synchronized (eventQueueCollection) {
            if (this.consumerExecutor == null) {
                this.consumerExecutor = this.createScheduledThreadPoolExecutor();
                if (this.consumerExecutor == null) {
                    throw new IllegalStateException();
                }
                returnValue = this.consumerExecutor.scheduleWithFixedDelay(this.createEventQueueConsumptionTask(siphon), 0L, 1L, TimeUnit.SECONDS);
            } else {
                returnValue = null;
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "start", returnValue);
        }
        return returnValue;
    }

    private final ScheduledThreadPoolExecutor createScheduledThreadPoolExecutor() {
        ScheduledThreadPoolExecutor returnValue = new ScheduledThreadPoolExecutor(1);
        returnValue.setRemoveOnCancelPolicy(true);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        ScheduledExecutorService consumerExecutor;
        String cn = this.getClass().getName();
        String mn = "close";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "close");
        }
        EventQueueCollection eventQueueCollection = this;
        synchronized (eventQueueCollection) {
            this.closing = true;
            consumerExecutor = this.consumerExecutor;
        }
        if (consumerExecutor != null) {
            consumerExecutor.shutdown();
            try {
                if (!consumerExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    consumerExecutor.shutdownNow();
                    if (!consumerExecutor.awaitTermination(60L, TimeUnit.SECONDS) && this.logger.isLoggable(Level.WARNING)) {
                        this.logger.logp(Level.WARNING, cn, "close", "consumerExecutor.awaitTermination() failed");
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                consumerExecutor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "close");
        }
    }

    private final Runnable createEventQueueConsumptionTask(Consumer<? super EventQueue<? extends T>> siphon) {
        Objects.requireNonNull(siphon);
        Runnable returnValue = () -> {
            while (!Thread.currentThread().isInterrupted()) {
                @Blocking Object eventQueue = this.get();
                if (eventQueue == null) continue;
                Object object = eventQueue;
                synchronized (object) {
                    try {
                        siphon.accept((EventQueue<? extends T>)eventQueue);
                    }
                    catch (TransientException transientException) {
                        this.map.putIfAbsent(((EventQueue)eventQueue).getKey(), (EventQueue<T>)eventQueue);
                    }
                }
            }
        };
        return returnValue;
    }

    @Override
    @Blocking
    public final EventQueue<T> get() {
        String cn = this.getClass().getName();
        String mn = "get";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "get");
        }
        EventQueue<T> returnValue = null;
        try {
            returnValue = this.take();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            returnValue = null;
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "get", returnValue);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blocking
    private final EventQueue<T> take() throws InterruptedException {
        EventQueue<T> returnValue;
        String cn = this.getClass().getName();
        String mn = "take";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "take");
        }
        EventQueueCollection eventQueueCollection = this;
        synchronized (eventQueueCollection) {
            while (this.isEmpty() && !this.closing) {
                this.wait();
            }
            assert (this.populated) : "this.populated == false";
            if (this.isEmpty()) {
                assert (this.closing) : "this.isEmpty() && !this.closing";
                returnValue = null;
            } else {
                Iterator<EventQueue<T>> iterator = this.map.values().iterator();
                assert (iterator != null);
                assert (iterator.hasNext());
                returnValue = iterator.next();
                assert (returnValue != null);
                iterator.remove();
                if (this.initialPopulationCount > 0) {
                    assert (!this.isSynchronized());
                    int oldInitialPopulationCount = this.initialPopulationCount--;
                    this.firePropertyChange("initialPopulationCount", oldInitialPopulationCount, this.initialPopulationCount);
                    this.firePropertyChange("synchronized", false, this.isSynchronized());
                }
                this.firePropertyChange("empty", false, this.isEmpty());
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            String eventQueueString;
            EventQueue<T> eventQueue = returnValue;
            synchronized (eventQueue) {
                eventQueueString = returnValue.toString();
            }
            this.logger.exiting(cn, "take", eventQueueString);
        }
        return returnValue;
    }

    protected Event<T> createEvent(Object source, AbstractEvent.Type eventType, T resource) {
        String cn = this.getClass().getName();
        String mn = "createEvent";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "createEvent", new Object[]{source, eventType, resource});
        }
        Objects.requireNonNull(source);
        Objects.requireNonNull(eventType);
        Objects.requireNonNull(resource);
        Event<Object> returnValue = new Event<Object>(source, eventType, null, resource);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "createEvent", returnValue);
        }
        return returnValue;
    }

    protected SynchronizationEvent<T> createSynchronizationEvent(Object source, AbstractEvent.Type eventType, T resource) {
        String cn = this.getClass().getName();
        String mn = "createSynchronizationEvent";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "createSynchronizationEvent", new Object[]{source, eventType, resource});
        }
        Objects.requireNonNull(source);
        Objects.requireNonNull(eventType);
        Objects.requireNonNull(resource);
        SynchronizationEvent<Object> returnValue = new SynchronizationEvent<Object>(source, eventType, null, resource);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "createSynchronizationEvent", returnValue);
        }
        return returnValue;
    }

    private final SynchronizationEvent<T> synchronize(Object source, AbstractEvent.Type eventType, T resource, boolean populate) {
        String cn = this.getClass().getName();
        String mn = "synchronize";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "synchronize", new Object[]{source, eventType, resource});
        }
        Objects.requireNonNull(source);
        Objects.requireNonNull(eventType);
        Objects.requireNonNull(resource);
        if (!eventType.equals((Object)AbstractEvent.Type.ADDITION) && !eventType.equals((Object)AbstractEvent.Type.MODIFICATION)) {
            throw new IllegalArgumentException("Illegal eventType: " + (Object)((Object)eventType));
        }
        SynchronizationEvent<T> event = this.createSynchronizationEvent(source, eventType, resource);
        if (event == null) {
            throw new IllegalStateException("createSynchronizationEvent() == null");
        }
        SynchronizationEvent<T> returnValue = this.add(event, populate);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "synchronize", returnValue);
        }
        return returnValue;
    }

    @Override
    public final Event<T> add(Object source, AbstractEvent.Type eventType, T resource) {
        return this.add(source, eventType, resource, true);
    }

    private final Event<T> add(Object source, AbstractEvent.Type eventType, T resource, boolean populate) {
        Event<T> event;
        String cn = this.getClass().getName();
        String mn = "add";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "add", new Object[]{source, eventType, resource, populate});
        }
        if ((event = this.createEvent(source, eventType, resource)) == null) {
            throw new IllegalStateException("createEvent() == null");
        }
        Event<T> returnValue = this.add(event, populate);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "add", returnValue);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <E extends AbstractEvent<T>> E add(E event, boolean populate) {
        String cn = this.getClass().getName();
        String mn = "add";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "add", new Object[]{event, populate});
        }
        if (this.closing) {
            throw new IllegalStateException();
        }
        Objects.requireNonNull(event);
        Object key = event.getKey();
        if (key == null) {
            throw new IllegalArgumentException("event.getKey() == null");
        }
        E returnValue = null;
        EventQueueCollection eventQueueCollection = this;
        synchronized (eventQueueCollection) {
            boolean eventQueueIsEmpty;
            boolean eventAdded;
            EventQueue<T> eventQueue;
            boolean eventQueueExisted;
            if (populate) {
                boolean old = this.populated;
                this.populated = true;
                this.firePropertyChange("populated", old, true);
            }
            boolean bl = eventQueueExisted = (eventQueue = this.map.get(key)) != null;
            if (!eventQueueExisted && (eventQueue = this.createEventQueue(key)) == null) {
                throw new IllegalStateException("createEventQueue(key) == null: " + key);
            }
            assert (eventQueue != null);
            EventQueue<T> eventQueue2 = eventQueue;
            synchronized (eventQueue2) {
                eventAdded = eventQueue.addEvent(event);
                eventQueueIsEmpty = eventQueue.isEmpty();
            }
            if (eventAdded) {
                returnValue = event;
            }
            if (eventQueueIsEmpty) {
                if (eventQueueExisted) {
                    returnValue = null;
                    boolean old = this.isEmpty();
                    this.map.remove(key);
                    this.firePropertyChange("empty", old, this.isEmpty());
                }
            } else if (!eventQueueExisted) {
                boolean old = this.isEmpty();
                this.map.put(key, eventQueue);
                this.firePropertyChange("empty", old, this.isEmpty());
                this.notifyAll();
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "add", returnValue);
        }
        return returnValue;
    }

    public final void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeSupport.addPropertyChangeListener(name, listener);
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    public final void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeSupport.removePropertyChangeListener(name, listener);
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    public final PropertyChangeListener[] getPropertyChangeListeners(String name) {
        return this.propertyChangeSupport.getPropertyChangeListeners(name);
    }

    public final PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    protected final void firePropertyChange(String propertyName, Object old, Object newValue) {
        String cn = this.getClass().getName();
        String mn = "firePropertyChange";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "firePropertyChange", new Object[]{propertyName, old, newValue});
        }
        this.propertyChangeSupport.firePropertyChange(propertyName, old, newValue);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "firePropertyChange");
        }
    }

    protected final void firePropertyChange(String propertyName, int old, int newValue) {
        String cn = this.getClass().getName();
        String mn = "firePropertyChange";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "firePropertyChange", new Object[]{propertyName, old, newValue});
        }
        this.propertyChangeSupport.firePropertyChange(propertyName, old, newValue);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "firePropertyChange");
        }
    }

    protected final void firePropertyChange(String name, boolean old, boolean newValue) {
        String cn = this.getClass().getName();
        String mn = "firePropertyChange";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "firePropertyChange", new Object[]{name, old, newValue});
        }
        this.propertyChangeSupport.firePropertyChange(name, old, newValue);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "firePropertyChange");
        }
    }

    public static final class TransientException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TransientException() {
        }

        public TransientException(String message) {
            super(message);
        }

        public TransientException(Throwable cause) {
            super(cause);
        }

        public TransientException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

