/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.kubernetes.controller;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.VersionWatchable;
import io.fabric8.kubernetes.client.dsl.Versionable;
import io.fabric8.kubernetes.client.dsl.Watchable;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.microbean.development.annotation.NonBlocking;
import org.microbean.kubernetes.controller.AbstractEvent;
import org.microbean.kubernetes.controller.EventCache;

@ThreadSafe
public class Reflector<T extends HasMetadata>
implements Closeable {
    private final Object operation;
    private volatile Object lastSynchronizationResourceVersion;
    private final ScheduledExecutorService synchronizationExecutorService;
    @GuardedBy(value="this")
    private ScheduledFuture<?> synchronizationTask;
    private final boolean shutdownSynchronizationExecutorServiceOnClose;
    private final Duration synchronizationInterval;
    @GuardedBy(value="this")
    private Closeable watch;
    @GuardedBy(value="itself")
    private final EventCache<T> eventCache;
    protected final Logger logger = this.createLogger();

    public <X extends Listable<? extends KubernetesResourceList> & VersionWatchable<? extends Closeable, Watcher<T>>> Reflector(X operation, EventCache<T> eventCache) {
        this(operation, eventCache, (ScheduledExecutorService)null, (Duration)null);
    }

    public <X extends Listable<? extends KubernetesResourceList> & VersionWatchable<? extends Closeable, Watcher<T>>> Reflector(X operation, EventCache<T> eventCache, Duration synchronizationInterval) {
        this(operation, eventCache, (ScheduledExecutorService)null, synchronizationInterval);
    }

    public <X extends Listable<? extends KubernetesResourceList> & VersionWatchable<? extends Closeable, Watcher<T>>> Reflector(X operation, EventCache<T> eventCache, ScheduledExecutorService synchronizationExecutorService, Duration synchronizationInterval) {
        if (this.logger == null) {
            throw new IllegalStateException("createLogger() == null");
        }
        String cn = this.getClass().getName();
        String mn = "<init>";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "<init>", new Object[]{operation, eventCache, synchronizationExecutorService, synchronizationInterval});
        }
        Objects.requireNonNull(operation);
        this.eventCache = Objects.requireNonNull(eventCache);
        this.operation = ((Versionable)operation).withResourceVersion("0");
        this.synchronizationInterval = synchronizationInterval;
        if (synchronizationExecutorService == null) {
            if (synchronizationInterval == null) {
                this.synchronizationExecutorService = null;
                this.shutdownSynchronizationExecutorServiceOnClose = false;
            } else {
                this.synchronizationExecutorService = Executors.newScheduledThreadPool(1);
                this.shutdownSynchronizationExecutorServiceOnClose = true;
            }
        } else {
            this.synchronizationExecutorService = synchronizationExecutorService;
            this.shutdownSynchronizationExecutorServiceOnClose = false;
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "<init>");
        }
    }

    protected Logger createLogger() {
        return Logger.getLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void close() throws IOException {
        String cn = this.getClass().getName();
        String mn = "close";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "close");
        }
        try {
            ScheduledFuture<?> synchronizationTask = this.synchronizationTask;
            if (synchronizationTask != null) {
                synchronizationTask.cancel(false);
            }
            this.closeSynchronizationExecutorService();
            if (this.watch != null) {
                this.watch.close();
            }
        }
        finally {
            this.onClose();
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "close");
        }
    }

    private final synchronized void closeSynchronizationExecutorService() {
        String cn = this.getClass().getName();
        String mn = "closeSynchronizationExecutorService";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "closeSynchronizationExecutorService");
        }
        if (this.synchronizationExecutorService != null && this.shutdownSynchronizationExecutorServiceOnClose) {
            this.synchronizationExecutorService.shutdown();
            try {
                if (!this.synchronizationExecutorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.synchronizationExecutorService.shutdownNow();
                    if (!this.synchronizationExecutorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                        this.synchronizationExecutorService.shutdownNow();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.synchronizationExecutorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "closeSynchronizationExecutorService");
        }
    }

    private final synchronized void setUpSynchronization() {
        Duration synchronizationDuration;
        long seconds;
        String cn = this.getClass().getName();
        String mn = "setUpSynchronization";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "setUpSynchronization");
        }
        if (this.synchronizationExecutorService != null && (seconds = (synchronizationDuration = this.getSynchronizationInterval()) == null ? 0L : synchronizationDuration.get(ChronoUnit.SECONDS)) > 0L) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.logp(Level.INFO, cn, "setUpSynchronization", "Scheduling downstream synchronization every {0} seconds", seconds);
            }
            ScheduledFuture<?> job = this.synchronizationExecutorService.scheduleWithFixedDelay(() -> {
                if (this.shouldSynchronize()) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.logp(Level.FINE, cn, "setUpSynchronization", "Synchronizing event cache with its downstream consumers");
                    }
                    EventCache<T> eventCache = this.eventCache;
                    synchronized (eventCache) {
                        this.eventCache.synchronize();
                    }
                }
            }, 0L, seconds, TimeUnit.SECONDS);
            assert (job != null);
            this.synchronizationTask = job;
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "setUpSynchronization");
        }
    }

    protected boolean shouldSynchronize() {
        boolean returnValue;
        String cn = this.getClass().getName();
        String mn = "shouldSynchronize";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "shouldSynchronize");
        }
        boolean bl = returnValue = this.synchronizationExecutorService != null;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "shouldSynchronize", returnValue);
        }
        return returnValue;
    }

    private final Duration getSynchronizationInterval() {
        return this.synchronizationInterval;
    }

    private final Object getLastSynchronizationResourceVersion() {
        return this.lastSynchronizationResourceVersion;
    }

    private final void setLastSynchronizationResourceVersion(Object resourceVersion) {
        this.lastSynchronizationResourceVersion = resourceVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonBlocking
    public final synchronized void start() {
        String cn = this.getClass().getName();
        String mn = "start";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "start");
        }
        if (this.watch == null) {
            KubernetesResourceList list = (KubernetesResourceList)((Listable)this.operation).list();
            assert (list != null);
            ListMeta metadata = list.getMetadata();
            assert (metadata != null);
            String resourceVersion = metadata.getResourceVersion();
            assert (resourceVersion != null);
            List items = list.getItems();
            Collection<Object> replacementItems = items == null || items.isEmpty() ? Collections.emptySet() : Collections.unmodifiableCollection(new ArrayList(items));
            EventCache<T> eventCache = this.eventCache;
            synchronized (eventCache) {
                this.eventCache.replace(replacementItems, resourceVersion);
            }
            this.setLastSynchronizationResourceVersion(resourceVersion);
            this.setUpSynchronization();
            try {
                Closeable temp = (Closeable)((Watchable)((VersionWatchable)this.operation).withResourceVersion(resourceVersion)).watch((Object)new WatchHandler());
                assert (temp != null);
                this.watch = temp;
            }
            finally {
                this.closeSynchronizationExecutorService();
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "start");
        }
    }

    protected synchronized void onClose() {
    }

    private final class WatchHandler
    implements Watcher<T> {
        private WatchHandler() {
            String cn = this.getClass().getName();
            String mn = "<init>";
            if (Reflector.this.logger.isLoggable(Level.FINER)) {
                Reflector.this.logger.entering(cn, "<init>");
                Reflector.this.logger.exiting(cn, "<init>");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void eventReceived(Watcher.Action action, T resource) {
            AbstractEvent.Type eventType;
            String cn = this.getClass().getName();
            String mn = "eventReceived";
            if (Reflector.this.logger.isLoggable(Level.FINER)) {
                Reflector.this.logger.entering(cn, "eventReceived", new Object[]{action, resource});
            }
            Objects.requireNonNull(action);
            Objects.requireNonNull(resource);
            ObjectMeta metadata = resource.getMetadata();
            assert (metadata != null);
            switch (action) {
                case ADDED: {
                    eventType = AbstractEvent.Type.ADDITION;
                    break;
                }
                case MODIFIED: {
                    eventType = AbstractEvent.Type.MODIFICATION;
                    break;
                }
                case DELETED: {
                    eventType = AbstractEvent.Type.DELETION;
                    break;
                }
                default: {
                    Object eventType2 = null;
                    throw new IllegalStateException();
                }
            }
            if (eventType != null) {
                if (Reflector.this.logger.isLoggable(Level.FINE)) {
                    Reflector.this.logger.logp(Level.FINE, cn, "eventReceived", "Adding event to cache: {0} {1}", new Object[]{eventType, resource});
                }
                EventCache eventCache = Reflector.this.eventCache;
                synchronized (eventCache) {
                    Reflector.this.eventCache.add(Reflector.this, eventType, resource);
                }
            }
            Reflector.this.setLastSynchronizationResourceVersion(metadata.getResourceVersion());
            if (Reflector.this.logger.isLoggable(Level.FINER)) {
                Reflector.this.logger.exiting(cn, "eventReceived");
            }
        }

        public final void onClose(KubernetesClientException exception) {
            String cn = this.getClass().getName();
            String mn = "onClose";
            if (Reflector.this.logger.isLoggable(Level.FINER)) {
                Reflector.this.logger.entering(cn, "onClose", exception);
            }
            if (exception != null && Reflector.this.logger.isLoggable(Level.WARNING)) {
                Reflector.this.logger.logp(Level.WARNING, cn, "onClose", exception.getMessage(), (Throwable)exception);
            }
            if (Reflector.this.logger.isLoggable(Level.FINER)) {
                Reflector.this.logger.exiting(cn, "onClose", exception);
            }
        }
    }
}

