/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.kubernetes.controller;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.microbean.kubernetes.controller.AbstractEvent;
import org.microbean.kubernetes.controller.SynchronizationEvent;

@ThreadSafe
public class EventQueue<T extends HasMetadata>
extends AbstractCollection<AbstractEvent<T>> {
    protected final Logger logger = this.createLogger();
    private final Object key;
    @GuardedBy(value="this")
    private final LinkedList<AbstractEvent<T>> events;

    protected EventQueue(Object key) {
        if (this.logger == null) {
            throw new IllegalStateException("createLogger() == null");
        }
        String cn = this.getClass().getName();
        String mn = "<init>";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "<init>", key);
        }
        this.key = Objects.requireNonNull(key);
        this.events = new LinkedList();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "<init>");
        }
    }

    protected Logger createLogger() {
        return Logger.getLogger(this.getClass().getName());
    }

    public final Object getKey() {
        String cn = this.getClass().getName();
        String mn = "getKey";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "getKey");
        }
        Object returnValue = this.key;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "getKey", returnValue);
        }
        return returnValue;
    }

    @Override
    public final synchronized boolean isEmpty() {
        String cn = this.getClass().getName();
        String mn = "isEmpty";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "isEmpty");
        }
        boolean returnValue = this.events.isEmpty();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "isEmpty", returnValue);
        }
        return returnValue;
    }

    @Override
    public final synchronized int size() {
        String cn = this.getClass().getName();
        String mn = "size";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "size");
        }
        int returnValue = this.events.size();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "size", returnValue);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean addEvent(AbstractEvent<T> event) {
        String cn = this.getClass().getName();
        String mn = "addEvent";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "addEvent", event);
        }
        Objects.requireNonNull(event);
        Object key = this.getKey();
        if (!key.equals(event.getKey())) {
            throw new IllegalArgumentException("!this.getKey().equals(event.getKey()): " + key + ", " + event.getKey());
        }
        boolean returnValue = false;
        AbstractEvent.Type eventType = event.getType();
        assert (eventType != null);
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            if (!(event instanceof SynchronizationEvent && this.resultsInDeletion() || !(returnValue = this.events.add(event)))) {
                this.deduplicate();
                Collection<AbstractEvent<T>> readOnlyEvents = Collections.unmodifiableCollection(this.events);
                Collection<AbstractEvent<T>> newEvents = this.compress(readOnlyEvents);
                if (newEvents != readOnlyEvents) {
                    this.events.clear();
                    if (newEvents != null && !newEvents.isEmpty()) {
                        this.events.addAll(newEvents);
                    }
                }
                returnValue = !this.isEmpty();
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "addEvent", returnValue);
        }
        return returnValue;
    }

    final synchronized AbstractEvent<T> getLast() {
        String cn = this.getClass().getName();
        String mn = "getLast";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "getLast");
        }
        AbstractEvent<T> returnValue = this.events.getLast();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "getLast", returnValue);
        }
        return returnValue;
    }

    @Override
    public final synchronized void forEach(Consumer<? super AbstractEvent<T>> action) {
        super.forEach(action);
    }

    @Override
    public final synchronized Iterator<AbstractEvent<T>> iterator() {
        return Collections.unmodifiableCollection(this.events).iterator();
    }

    private final synchronized void deduplicate() {
        int size;
        String cn = this.getClass().getName();
        String mn = "deduplicate";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "deduplicate");
        }
        if ((size = this.size()) > 2) {
            AbstractEvent<T> lastEvent = this.events.get(size - 1);
            AbstractEvent<T> nextToLastEvent = this.events.get(size - 2);
            AbstractEvent<T> event = lastEvent != null && nextToLastEvent != null && AbstractEvent.Type.DELETION.equals((Object)lastEvent.getType()) && AbstractEvent.Type.DELETION.equals((Object)nextToLastEvent.getType()) ? (nextToLastEvent.isFinalStateKnown() ? nextToLastEvent : lastEvent) : null;
            if (event != null) {
                this.events.set(size - 2, event);
                this.events.remove(size - 1);
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "deduplicate");
        }
    }

    final synchronized boolean resultsInDeletion() {
        boolean returnValue;
        String cn = this.getClass().getName();
        String mn = "resultsInDeletion";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(cn, "resultsInDeletion");
        }
        boolean bl = returnValue = !this.isEmpty() && this.getLast().getType().equals((Object)AbstractEvent.Type.DELETION);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(cn, "resultsInDeletion", returnValue);
        }
        return returnValue;
    }

    protected Collection<AbstractEvent<T>> compress(Collection<AbstractEvent<T>> events) {
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int hashCode() {
        int hashCode = 17;
        LinkedList<AbstractEvent<T>> value = this.getKey();
        int c = value == null ? 0 : ((Object)value).hashCode();
        hashCode = 37 * hashCode + c;
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            value = this.events;
            c = value == null ? 0 : ((Object)value).hashCode();
        }
        hashCode = 37 * hashCode + c;
        return hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof EventQueue) {
            EventQueue her = (EventQueue)other;
            Object key = this.getKey();
            if (key == null ? her.getKey() != null : !key.equals(her.getKey())) {
                return false;
            }
            EventQueue eventQueue = this;
            synchronized (eventQueue) {
                LinkedList<AbstractEvent<T>> events = this.events;
                if (events == null) {
                    EventQueue eventQueue2 = her;
                    synchronized (eventQueue2) {
                        if (her.events != null) {
                            return false;
                        }
                    }
                }
                EventQueue eventQueue3 = her;
                synchronized (eventQueue3) {
                    if (!((Object)events).equals(her.events)) {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public final synchronized String toString() {
        return this.getKey() + ": " + this.events;
    }
}

