/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.jersey.netty.cdi;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.bootstrap.ServerBootstrapConfig;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.DefaultSelectStrategyFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SelectStrategyFactory;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.DefaultEventExecutorChooserFactory;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Named;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.microbean.configuration.api.Configurations;
import org.microbean.jaxrs.cdi.JaxRsExtension;
import org.microbean.jersey.netty.JerseyChannelInitializer;

public class JerseyNettyExtension
implements Extension {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private static final String cn = JerseyNettyExtension.class.getName();
    private static final Logger logger = Logger.getLogger(cn);
    private final Collection<Throwable> shutdownProblems;
    private volatile Collection<EventExecutorGroup> eventExecutorGroups;
    private volatile CountDownLatch bindLatch;
    private volatile CountDownLatch runLatch;
    private volatile CountDownLatch shutdownLatch;
    private volatile CreationalContext<?> cc;

    public JerseyNettyExtension() {
        Thread containerThread = Thread.currentThread();
        JerseyNettyExtension.workAroundLoggingBug(containerThread);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(cn, "<init>");
        }
        System.setProperty("org.jboss.weld.se.shutdownHook", "false");
        this.shutdownProblems = new ArrayList<Throwable>();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(this.getClass().getName(), "<shutdown hook>");
            }
            JerseyNettyExtension.unblock(this.runLatch);
            JerseyNettyExtension.unblock(this.bindLatch);
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, cn, "<shutdown hook>", "Waiting for CDI container thread to complete");
                }
                containerThread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(this.getClass().getName(), "<shutdown hook>");
            }
        }));
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(cn, "<init>");
        }
    }

    protected Logger createLogger() {
        return Logger.getLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onStartup(@Observes @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) throws URISyntaxException {
        String mn = "onStartup";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(cn, "onStartup", new Object[]{event, beanManager});
        }
        Objects.requireNonNull(beanManager);
        JaxRsExtension extension = (JaxRsExtension)beanManager.getExtension(JaxRsExtension.class);
        assert (extension != null);
        Set applicationQualifierSets = extension.getAllApplicationQualifiers();
        if (applicationQualifierSets != null && !applicationQualifierSets.isEmpty()) {
            CreationalContext cc = beanManager.createCreationalContext(null);
            assert (cc != null);
            this.cc = cc;
            Configurations configurations = (Configurations)JerseyNettyExtension.acquire(beanManager, cc, Configurations.class);
            assert (configurations != null);
            Map<String, String> baseConfigurationCoordinates = configurations.getConfigurationCoordinates();
            int size = applicationQualifierSets.size();
            assert (size > 0);
            this.shutdownLatch = new CountDownLatch(size);
            this.bindLatch = new CountDownLatch(size);
            ArrayList bindProblems = new ArrayList();
            for (Set applicationQualifiers : applicationQualifierSets) {
                if (Thread.currentThread().isInterrupted()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, cn, "onStartup", "Not binding because the current thread has been interrupted");
                    }
                    JerseyNettyExtension.unblock(this.bindLatch);
                    this.bindLatch = null;
                    break;
                }
                try {
                    ChannelFuture bindFuture;
                    Collection<EventExecutorGroup> newEventExecutorGroups;
                    Map<String, String> configurationCoordinates;
                    Map<String, String> qualifierCoordinates = JerseyNettyExtension.toConfigurationCoordinates(applicationQualifiers);
                    if (baseConfigurationCoordinates == null || baseConfigurationCoordinates.isEmpty()) {
                        configurationCoordinates = qualifierCoordinates == null || qualifierCoordinates.isEmpty() ? baseConfigurationCoordinates : qualifierCoordinates;
                    } else if (qualifierCoordinates == null || qualifierCoordinates.isEmpty()) {
                        configurationCoordinates = baseConfigurationCoordinates;
                    } else {
                        configurationCoordinates = new HashMap<String, String>(baseConfigurationCoordinates);
                        configurationCoordinates.putAll(qualifierCoordinates);
                    }
                    Annotation[] applicationQualifiersArray = applicationQualifiers == null ? null : (applicationQualifiers.isEmpty() ? EMPTY_ANNOTATION_ARRAY : applicationQualifiers.toArray(new Annotation[applicationQualifiers.size()]));
                    ServerBootstrap serverBootstrap = JerseyNettyExtension.getServerBootstrap(beanManager, cc, applicationQualifiersArray, configurations, configurationCoordinates);
                    assert (serverBootstrap != null);
                    JerseyChannelInitializer jerseyChannelInitializer = JerseyNettyExtension.getJerseyChannelInitializer(beanManager, cc, applicationQualifiersArray, configurations, configurationCoordinates);
                    assert (jerseyChannelInitializer != null);
                    serverBootstrap.childHandler((ChannelHandler)jerseyChannelInitializer);
                    serverBootstrap.validate();
                    ServerBootstrapConfig serverBootstrapConfig = serverBootstrap.config();
                    assert (serverBootstrapConfig != null);
                    EventLoopGroup eventLoopGroup = serverBootstrapConfig.group();
                    assert (eventLoopGroup != null);
                    eventLoopGroup.terminationFuture().addListener(f -> {
                        block10: {
                            try {
                                Throwable throwable;
                                if (f.isSuccess()) {
                                    if (logger.isLoggable(Level.FINE)) {
                                        logger.logp(Level.FINE, cn, "<ChannelFuture listener>", "EventLoopGroup terminated successfully");
                                    }
                                    break block10;
                                }
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, cn, "<ChannelFuture listener>", "EventLoopGroup terminated with problems: {0}", f.cause());
                                }
                                if ((throwable = f.cause()) == null) break block10;
                                Collection<Throwable> collection = this.shutdownProblems;
                                synchronized (collection) {
                                    this.shutdownProblems.add(throwable);
                                }
                            }
                            finally {
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, cn, "<ChannelFuture listener>", "Counting down shutdownLatch");
                                }
                                this.shutdownLatch.countDown();
                            }
                        }
                    });
                    EventExecutorGroup jerseyEventExecutorGroup = jerseyChannelInitializer.getJerseyEventExecutorGroup();
                    assert (jerseyEventExecutorGroup != null);
                    Collection<EventExecutorGroup> eventExecutorGroups = this.eventExecutorGroups;
                    if (eventExecutorGroups == null) {
                        newEventExecutorGroups = new LinkedHashSet<EventExecutorGroup>();
                        newEventExecutorGroups.add((EventExecutorGroup)eventLoopGroup);
                        newEventExecutorGroups.add(jerseyEventExecutorGroup);
                        this.eventExecutorGroups = newEventExecutorGroups;
                    } else {
                        newEventExecutorGroups = eventExecutorGroups;
                        synchronized (newEventExecutorGroups) {
                            eventExecutorGroups.add((EventExecutorGroup)eventLoopGroup);
                            eventExecutorGroups.add(jerseyEventExecutorGroup);
                        }
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        bindFuture = null;
                        CountDownLatch bindLatch = this.bindLatch;
                        if (bindLatch != null) {
                            JerseyNettyExtension.unblock(bindLatch);
                            this.bindLatch = null;
                        }
                    } else if (serverBootstrapConfig.localAddress() == null) {
                        URI baseUri = jerseyChannelInitializer.getBaseUri();
                        bindFuture = serverBootstrap.bind(baseUri.getHost(), baseUri.getPort());
                    } else {
                        bindFuture = serverBootstrap.bind();
                    }
                    if (bindFuture == null) continue;
                    bindFuture.addListener(f -> {
                        block11: {
                            try {
                                if (f.isSuccess()) {
                                    if (logger.isLoggable(Level.FINE)) {
                                        logger.logp(Level.FINE, cn, "<ChannelFuture listener>", "ServerBootstrap bound successfully");
                                    }
                                    break block11;
                                }
                                Throwable throwable = f.cause();
                                if (logger.isLoggable(Level.WARNING)) {
                                    logger.logp(Level.WARNING, cn, "<ChannelFuture listener>", "ServerBootstrap binding failed: {0}", throwable);
                                }
                                if (throwable == null) break block11;
                                Collection collection = bindProblems;
                                synchronized (collection) {
                                    bindProblems.add(throwable);
                                }
                            }
                            finally {
                                CountDownLatch bindLatch = this.bindLatch;
                                if (bindLatch != null) {
                                    if (logger.isLoggable(Level.FINE)) {
                                        logger.logp(Level.FINE, cn, "<ChannelFuture listener>", "Counting down bindLatch");
                                    }
                                    bindLatch.countDown();
                                }
                            }
                        }
                    });
                }
                catch (RuntimeException | URISyntaxException throwMe) {
                    JerseyNettyExtension.unblock(this.bindLatch);
                    JerseyNettyExtension.unblock(this.shutdownLatch);
                    ArrayList arrayList = bindProblems;
                    synchronized (arrayList) {
                        for (Throwable bindProblem : bindProblems) {
                            throwMe.addSuppressed(bindProblem);
                        }
                    }
                    cc.release();
                    throw throwMe;
                }
            }
            CountDownLatch bindLatch = this.bindLatch;
            if (!Thread.currentThread().isInterrupted() && bindLatch != null && bindLatch.getCount() > 0L) {
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, cn, "onStartup", "Awaiting bindLatch");
                    }
                    bindLatch.await();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, cn, "onStartup", "bindLatch released");
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, cn, "onStartup", "bindLatch.await() interrupted");
                    }
                    Thread.currentThread().interrupt();
                    JerseyNettyExtension.unblock(bindLatch);
                    bindLatch = null;
                    this.bindLatch = null;
                }
            }
            DeploymentException throwMe = null;
            ArrayList arrayList = bindProblems;
            synchronized (arrayList) {
                for (Throwable bindProblem : bindProblems) {
                    if (throwMe == null) {
                        throwMe = new DeploymentException(bindProblem);
                        continue;
                    }
                    throwMe.addSuppressed(bindProblem);
                }
                bindProblems.clear();
            }
            if (throwMe != null) {
                JerseyNettyExtension.unblock(this.shutdownLatch);
                cc.release();
                throw throwMe;
            }
            if (bindLatch != null) {
                assert (bindLatch.getCount() <= 0L);
                this.bindLatch = null;
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, cn, "onStartup", "Creating runLatch");
                }
                this.runLatch = new CountDownLatch(1);
            }
        }
        assert (this.bindLatch == null);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(cn, "onStartup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitForAllServersToStop(@Observes @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        CreationalContext<?> cc;
        CountDownLatch shutdownLatch;
        Collection<EventExecutorGroup> eventExecutorGroups;
        CountDownLatch runLatch;
        String mn = "waitForAllServersToStop";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(cn, "waitForAllServersToStop", event);
        }
        if ((runLatch = this.runLatch) != null) {
            if (Thread.currentThread().isInterrupted()) {
                JerseyNettyExtension.unblock(runLatch);
            } else {
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, cn, "waitForAllServersToStop", "Awaiting runLatch");
                    }
                    runLatch.await();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, cn, "waitForAllServersToStop", "runLatch released");
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, cn, "waitForAllServersToStop", "runLatch.await() interrupted");
                    }
                    Thread.currentThread().interrupt();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, cn, "waitForAllServersToStop", "Unblocking runLatch");
                    }
                    JerseyNettyExtension.unblock(runLatch);
                }
            }
            assert (runLatch.getCount() <= 0L);
            runLatch = null;
            this.runLatch = null;
        }
        if ((eventExecutorGroups = this.eventExecutorGroups) != null) {
            Collection<EventExecutorGroup> collection = eventExecutorGroups;
            synchronized (collection) {
                if (!eventExecutorGroups.isEmpty()) {
                    for (EventExecutorGroup eventExecutorGroup : eventExecutorGroups) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, cn, "waitForAllServersToStop", "Shutting down {0} gracefully", eventExecutorGroup);
                        }
                        eventExecutorGroup.shutdownGracefully();
                    }
                    eventExecutorGroups.clear();
                }
            }
            this.eventExecutorGroups = null;
        }
        if ((shutdownLatch = this.shutdownLatch) != null) {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, cn, "waitForAllServersToStop", "Awaiting shutdownLatch");
                }
                shutdownLatch.await();
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, cn, "waitForAllServersToStop", "shutdownLatch released");
                }
            }
            catch (InterruptedException interruptedException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, cn, "waitForAllServersToStop", "shutdownLatch.await() interrupted");
                }
                Thread.currentThread().interrupt();
            }
            assert (shutdownLatch.getCount() <= 0L);
            this.shutdownLatch = null;
        }
        if ((cc = this.cc) != null) {
            cc.release();
        }
        DeploymentException throwMe = null;
        Collection<Throwable> collection = this.shutdownProblems;
        synchronized (collection) {
            for (Throwable shutdownProblem : this.shutdownProblems) {
                if (throwMe == null) {
                    throwMe = new DeploymentException(shutdownProblem);
                    continue;
                }
                throwMe.addSuppressed(shutdownProblem);
            }
            this.shutdownProblems.clear();
        }
        if (throwMe != null) {
            throw throwMe;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(cn, "waitForAllServersToStop");
        }
    }

    private static final Application getApplication(BeanManager beanManager, CreationalContext<?> cc, Annotation[] qualifiersArray) {
        return (Application)JerseyNettyExtension.acquire(beanManager, cc, Application.class, qualifiersArray);
    }

    private static final JerseyChannelInitializer getJerseyChannelInitializer(BeanManager beanManager, CreationalContext<?> cc, Annotation[] qualifiersArray, Configurations configurations, Map<String, String> configurationCoordinates) throws URISyntaxException {
        String applicationPath;
        Application application = JerseyNettyExtension.getApplication(beanManager, cc, qualifiersArray);
        if (application == null) {
            applicationPath = "/";
        } else {
            AnnotatedType applicationType = beanManager.createAnnotatedType(application.getClass());
            assert (applicationType != null);
            ApplicationPath applicationPathAnnotation = (ApplicationPath)applicationType.getAnnotation(ApplicationPath.class);
            applicationPath = applicationPathAnnotation == null ? "/" : applicationPathAnnotation.value();
        }
        assert (applicationPath != null);
        String host = (String)configurations.getValue(configurationCoordinates, "host", String.class, "0.0.0.0");
        SslContext sslContext = JerseyNettyExtension.getSslContext(beanManager, cc, qualifiersArray);
        URI baseUri = sslContext == null ? new URI("http", null, host, (Integer)configurations.getValue(configurationCoordinates, "port", Integer.TYPE, "8080"), applicationPath, null, null) : new URI("https", null, host, (Integer)configurations.getValue(configurationCoordinates, "port", Integer.TYPE, "443"), applicationPath, null, null);
        assert (baseUri != null);
        EventExecutorGroup jerseyEventExecutorGroup = JerseyNettyExtension.getJerseyEventExecutorGroup(beanManager, cc, qualifiersArray, configurations, configurationCoordinates);
        assert (jerseyEventExecutorGroup != null);
        JerseyChannelInitializer returnValue = new JerseyChannelInitializer(baseUri, sslContext, ((Boolean)configurations.getValue(configurationCoordinates, "http2Support", Boolean.TYPE, "true")).booleanValue(), ((Long)configurations.getValue(configurationCoordinates, "maxIncomingContentLength", Long.TYPE, String.valueOf(Long.MAX_VALUE))).longValue(), jerseyEventExecutorGroup, application, ((Integer)configurations.getValue(configurationCoordinates, "flushThreshold", Integer.TYPE, "8192")).intValue(), Unpooled::wrappedBuffer);
        return returnValue;
    }

    private static final SslContext getSslContext(BeanManager beanManager, CreationalContext<?> cc, Annotation[] qualifiersArray) {
        return JerseyNettyExtension.acquire(beanManager, cc, SslContext.class, qualifiersArray, true, (bm, cctx, qa) -> null);
    }

    private static final ServerBootstrap getServerBootstrap(BeanManager beanManager, CreationalContext<?> cc, Annotation[] qualifiersArray, Configurations configurations, Map<String, String> configurationCoordinates) {
        return JerseyNettyExtension.acquire(beanManager, cc, ServerBootstrap.class, qualifiersArray, true, (bm, cctx, qa) -> {
            ServerBootstrap returnValue = new ServerBootstrap();
            returnValue.group(JerseyNettyExtension.getEventLoopGroup(bm, cctx, qa, configurations, configurationCoordinates));
            returnValue.channelFactory(JerseyNettyExtension.getChannelFactory(bm, cctx, qa));
            beanManager.getEvent().select(ServerBootstrap.class, qualifiersArray).fire((Object)returnValue);
            return returnValue;
        });
    }

    private static final ChannelFactory<? extends ServerChannel> getChannelFactory(BeanManager beanManager, CreationalContext<?> cc, Annotation[] qualifiersArray) {
        return JerseyNettyExtension.acquire(beanManager, cc, new TypeLiteral<ChannelFactory<? extends ServerChannel>>(){
            private static final long serialVersionUID = 1L;
        }.getType(), qualifiersArray, true, (bm, cctx, qa) -> {
            if (Epoll.isAvailable()) {
                return () -> new EpollServerSocketChannel();
            }
            if (KQueue.isAvailable()) {
                return () -> new KQueueServerSocketChannel();
            }
            return () -> new NioServerSocketChannel(JerseyNettyExtension.getSelectorProvider(bm, cctx, qa));
        });
    }

    private static final EventLoopGroup getEventLoopGroup(BeanManager beanManager, CreationalContext<?> cc, Annotation[] qualifiersArray, Configurations configurations, Map<String, String> configurationCoordinates) {
        return JerseyNettyExtension.acquire(beanManager, cc, EventLoopGroup.class, qualifiersArray, true, (bm, cctx, qa) -> {
            int threadCount = (Integer)configurations.getValue(configurationCoordinates, "io.netty.eventLoopThreads", Integer.TYPE, "0");
            Executor executor = JerseyNettyExtension.getExecutor(bm, cctx, qa);
            EventExecutorChooserFactory eventExecutorChooserFactory = JerseyNettyExtension.getEventExecutorChooserFactory(bm, cctx, qa);
            SelectStrategyFactory selectStrategyFactory = JerseyNettyExtension.getSelectStrategyFactory(bm, cctx, qa);
            RejectedExecutionHandler rejectedExecutionHandler = JerseyNettyExtension.getRejectedExecutionHandler(bm, cctx, qa);
            Object returnValue = Epoll.isAvailable() ? new EpollEventLoopGroup(threadCount, executor, eventExecutorChooserFactory, selectStrategyFactory, rejectedExecutionHandler) : (KQueue.isAvailable() ? new KQueueEventLoopGroup(threadCount, executor, eventExecutorChooserFactory, selectStrategyFactory, rejectedExecutionHandler) : new NioEventLoopGroup(threadCount, executor, eventExecutorChooserFactory, JerseyNettyExtension.getSelectorProvider(bm, cctx, qa), selectStrategyFactory, rejectedExecutionHandler));
            beanManager.getEvent().select(EventLoopGroup.class, qa).fire(returnValue);
            return returnValue;
        });
    }

    private static final Executor getExecutor(BeanManager beanManager, CreationalContext<?> cc, Annotation[] qualifiersArray) {
        return (Executor)JerseyNettyExtension.acquire(beanManager, cc, Executor.class, qualifiersArray);
    }

    private static final RejectedExecutionHandler getRejectedExecutionHandler(BeanManager beanManager, CreationalContext<?> cc, Annotation[] qualifiersArray) {
        return JerseyNettyExtension.acquire(beanManager, cc, RejectedExecutionHandler.class, qualifiersArray, true, (bm, cctx, qa) -> RejectedExecutionHandlers.reject());
    }

    private static final SelectorProvider getSelectorProvider(BeanManager beanManager, CreationalContext<?> cc, Annotation[] qualifiersArray) {
        return JerseyNettyExtension.acquire(beanManager, cc, SelectorProvider.class, qualifiersArray, true, (bm, cctx, qa) -> SelectorProvider.provider());
    }

    private static final SelectStrategyFactory getSelectStrategyFactory(BeanManager beanManager, CreationalContext<?> cc, Annotation[] qualifiersArray) {
        return JerseyNettyExtension.acquire(beanManager, cc, SelectStrategyFactory.class, qualifiersArray, true, (bm, cctx, qa) -> DefaultSelectStrategyFactory.INSTANCE);
    }

    private static final EventExecutorChooserFactory getEventExecutorChooserFactory(BeanManager beanManager, CreationalContext<?> cc, Annotation[] qualifiersArray) {
        return (EventExecutorChooserFactory)JerseyNettyExtension.acquire(beanManager, cc, EventExecutorChooserFactory.class, qualifiersArray, true, (bm, cctx, qa) -> DefaultEventExecutorChooserFactory.INSTANCE);
    }

    private static final EventExecutorGroup getJerseyEventExecutorGroup(BeanManager beanManager, CreationalContext<?> cc, Annotation[] qualifiersArray, Configurations configurations, Map<String, String> configurationCoordinates) {
        return (EventExecutorGroup)JerseyNettyExtension.acquire(beanManager, cc, EventExecutorGroup.class, qualifiersArray, true, (bm, cctx, qa) -> new DefaultEventExecutorGroup(((Integer)configurations.getValue(configurationCoordinates, "jerseyThreads", Integer.TYPE, String.valueOf(2 * Runtime.getRuntime().availableProcessors()))).intValue()));
    }

    private static final <T> T acquire(BeanManager beanManager, CreationalContext<?> cc, Type type) {
        return (T)JerseyNettyExtension.acquire(beanManager, cc, type, null, false, (bm, cctx, qa) -> null);
    }

    private static final <T> T acquire(BeanManager beanManager, CreationalContext<?> cc, Type type, Annotation[] qualifiersArray) {
        return (T)JerseyNettyExtension.acquire(beanManager, cc, type, qualifiersArray, false, (bm, cctx, qa) -> null);
    }

    private static final <T> T acquire(BeanManager beanManager, CreationalContext<?> cc, Type type, Annotation[] qualifiersArray, boolean fallbackWithDefaultQualifier) {
        return (T)JerseyNettyExtension.acquire(beanManager, cc, type, qualifiersArray, fallbackWithDefaultQualifier, (bm, cctx, qa) -> null);
    }

    private static final <T> T acquire(BeanManager beanManager, CreationalContext<?> cc, Type type, Annotation[] qualifiersArray, boolean fallbackWithDefaultQualifier, DefaultValueFunction<? extends T> defaultValueFunction) {
        Object returnValue;
        Objects.requireNonNull(beanManager);
        Objects.requireNonNull(type);
        Objects.requireNonNull(defaultValueFunction);
        Set beans = null;
        if (qualifiersArray == null || qualifiersArray.length <= 0 || qualifiersArray.length == 1 && qualifiersArray[0] instanceof Default) {
            beans = beanManager.getBeans(type, new Annotation[0]);
        } else {
            beans = beanManager.getBeans(type, qualifiersArray);
            if (fallbackWithDefaultQualifier && (beans == null || beans.isEmpty())) {
                beans = beanManager.getBeans(type, new Annotation[0]);
            }
        }
        if (beans == null || beans.isEmpty()) {
            returnValue = defaultValueFunction.getDefaultValue(beanManager, cc, qualifiersArray);
        } else {
            Bean bean = beanManager.resolve(beans);
            if (bean == null) {
                returnValue = defaultValueFunction.getDefaultValue(beanManager, cc, qualifiersArray);
            } else {
                Object temp = beanManager.getReference(bean, type, cc);
                returnValue = temp;
            }
        }
        return returnValue;
    }

    private static final void unblock(CountDownLatch latch) {
        if (latch != null) {
            while (latch.getCount() > 0L) {
                latch.countDown();
            }
        }
    }

    private static final Map<String, String> toConfigurationCoordinates(Set<? extends Annotation> qualifiers) {
        HashMap<String, String> returnValue = new HashMap<String, String>();
        if (qualifiers != null && !qualifiers.isEmpty()) {
            for (Annotation annotation : qualifiers) {
                if (annotation instanceof Named) {
                    returnValue.put("name", ((Named)annotation).value());
                    continue;
                }
                if (annotation instanceof Default || annotation instanceof Any) continue;
                returnValue.put(annotation.toString(), "");
            }
        }
        return returnValue;
    }

    private static final void workAroundLoggingBug(Thread containerThread) {
        boolean rootHandlersIsEmpty;
        Logger rootLogger = Logger.getLogger("");
        assert (rootLogger != null);
        Handler[] rootHandlers = rootLogger.getHandlers();
        boolean bl = rootHandlersIsEmpty = rootHandlers == null || rootHandlers.length <= 0;
        if (!rootHandlersIsEmpty) {
            for (Handler rootHandler : rootHandlers) {
                rootLogger.removeHandler(rootHandler);
            }
        }
        rootLogger.addHandler(new NoOpHandler(containerThread));
        if (!rootHandlersIsEmpty) {
            for (Handler rootHandler : rootHandlers) {
                rootLogger.addHandler(rootHandler);
            }
        }
    }

    private static final class NoOpHandler
    extends Handler {
        private final Thread thread;

        private NoOpHandler(Thread t) {
            this.thread = Objects.requireNonNull(t);
        }

        @Override
        public final void close() {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public final void flush() {
        }

        @Override
        public final void publish(LogRecord logRecord) {
        }
    }

    @FunctionalInterface
    private static interface DefaultValueFunction<T> {
        public T getDefaultValue(BeanManager var1, CreationalContext<?> var2, Annotation[] var3);
    }
}

