/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.jersey.netty.cdi;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.bootstrap.ServerBootstrapConfig;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.DefaultSelectStrategyFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SelectStrategyFactory;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.DefaultEventExecutorChooserFactory;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Named;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.server.ApplicationHandler;
import org.microbean.configuration.api.Configurations;
import org.microbean.jaxrs.cdi.JaxRsExtension;
import org.microbean.jersey.netty.JerseyChannelInitializer;

public class JerseyNettyExtension
implements Extension {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final Collection<Throwable> shutdownProblems = new ArrayList<Throwable>();
    private volatile Collection<EventExecutorGroup> eventExecutorGroups;
    private volatile CountDownLatch bindLatch;
    private volatile CountDownLatch runLatch;
    private volatile CountDownLatch shutdownLatch;

    public JerseyNettyExtension() {
        Thread containerThread = Thread.currentThread();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            JerseyNettyExtension.zeroOut(this.runLatch);
            JerseyNettyExtension.zeroOut(this.bindLatch);
            containerThread.interrupt();
            try {
                containerThread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onStartup(@Observes @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) throws URISyntaxException {
        Set applicationQualifierSets;
        JaxRsExtension extension;
        if (beanManager != null && (extension = (JaxRsExtension)beanManager.getExtension(JaxRsExtension.class)) != null && (applicationQualifierSets = extension.getAllApplicationQualifiers()) != null && !applicationQualifierSets.isEmpty()) {
            CountDownLatch bindLatch;
            Instance instance = beanManager.createInstance();
            assert (instance != null);
            Configurations configurations = (Configurations)instance.select(Configurations.class, new Annotation[0]).get();
            Map<String, String> baseConfigurationCoordinates = configurations.getConfigurationCoordinates();
            int size = applicationQualifierSets.size();
            assert (size > 0);
            this.shutdownLatch = new CountDownLatch(size);
            this.bindLatch = new CountDownLatch(size);
            ArrayList bindProblems = new ArrayList();
            for (Set applicationQualifiers : applicationQualifierSets) {
                if (Thread.currentThread().isInterrupted()) {
                    JerseyNettyExtension.zeroOut(this.bindLatch);
                    this.bindLatch = null;
                    break;
                }
                Annotation[] applicationQualifiersArray = applicationQualifiers == null ? null : (applicationQualifiers.isEmpty() ? EMPTY_ANNOTATION_ARRAY : applicationQualifiers.toArray(new Annotation[applicationQualifiers.size()]));
                Set applicationBeans = beanManager.getBeans(Application.class, applicationQualifiersArray);
                assert (applicationBeans != null);
                assert (!applicationBeans.isEmpty());
                try {
                    Map<String, String> configurationCoordinates;
                    Bean applicationBean = beanManager.resolve(applicationBeans);
                    assert (applicationBean != null);
                    Application application = (Application)beanManager.getReference(applicationBean, Application.class, beanManager.createCreationalContext((Contextual)applicationBean));
                    assert (application != null);
                    ApplicationPath applicationPathAnnotation = application.getClass().getAnnotation(ApplicationPath.class);
                    String applicationPath = applicationPathAnnotation == null ? "/" : applicationPathAnnotation.value();
                    assert (applicationPath != null);
                    ServerBootstrap serverBootstrap = JerseyNettyExtension.getServerBootstrap(beanManager, (Instance<Object>)instance, applicationQualifiersArray, true);
                    assert (serverBootstrap != null);
                    SslContext sslContext = JerseyNettyExtension.getSslContext(beanManager, (Instance<Object>)instance, applicationQualifiersArray, true);
                    Map<String, String> qualifierCoordinates = JerseyNettyExtension.toConfigurationCoordinates(applicationQualifiers);
                    if (baseConfigurationCoordinates == null || baseConfigurationCoordinates.isEmpty()) {
                        configurationCoordinates = qualifierCoordinates == null || qualifierCoordinates.isEmpty() ? baseConfigurationCoordinates : qualifierCoordinates;
                    } else if (qualifierCoordinates == null || qualifierCoordinates.isEmpty()) {
                        configurationCoordinates = baseConfigurationCoordinates;
                    } else {
                        configurationCoordinates = new HashMap<String, String>(baseConfigurationCoordinates);
                        configurationCoordinates.putAll(qualifierCoordinates);
                    }
                    URI baseUri = sslContext == null ? new URI("http", null, configurations.getValue(configurationCoordinates, "host", "0.0.0.0"), (Integer)configurations.getValue(configurationCoordinates, "port", Integer.TYPE, "8080"), applicationPath, null, null) : new URI("https", null, configurations.getValue(configurationCoordinates, "host", "0.0.0.0"), (Integer)configurations.getValue(configurationCoordinates, "port", Integer.TYPE, "443"), applicationPath, null, null);
                    assert (baseUri != null);
                    BiFunction securityContextBiFunction = null;
                    serverBootstrap.childHandler((ChannelHandler)new JerseyChannelInitializer(baseUri, sslContext, new ApplicationHandler(application), securityContextBiFunction));
                    serverBootstrap.validate();
                    ServerBootstrapConfig config = serverBootstrap.config();
                    assert (config != null);
                    EventLoopGroup group = config.group();
                    assert (group != null);
                    group.terminationFuture().addListener(f -> {
                        block6: {
                            try {
                                Throwable throwable;
                                if (f.isSuccess() || (throwable = f.cause()) == null) break block6;
                                Collection<Throwable> collection = this.shutdownProblems;
                                synchronized (collection) {
                                    this.shutdownProblems.add(throwable);
                                }
                            }
                            finally {
                                this.shutdownLatch.countDown();
                            }
                        }
                    });
                    Collection<EventExecutorGroup> eventExecutorGroups = this.eventExecutorGroups;
                    if (eventExecutorGroups == null) {
                        this.eventExecutorGroups = eventExecutorGroups = new ArrayList<EventExecutorGroup>();
                    }
                    Collection<EventExecutorGroup> collection = eventExecutorGroups;
                    synchronized (collection) {
                        eventExecutorGroups.add((EventExecutorGroup)group);
                    }
                    ChannelFuture bindFuture = config.localAddress() == null ? serverBootstrap.bind(baseUri.getHost(), baseUri.getPort()) : serverBootstrap.bind();
                    bindFuture.addListener(f -> {
                        block7: {
                            try {
                                Throwable throwable;
                                if (f.isSuccess() || (throwable = f.cause()) == null) break block7;
                                Collection collection = bindProblems;
                                synchronized (collection) {
                                    bindProblems.add(throwable);
                                }
                            }
                            finally {
                                CountDownLatch latch = this.bindLatch;
                                if (latch != null) {
                                    latch.countDown();
                                }
                            }
                        }
                    });
                }
                catch (RuntimeException | URISyntaxException throwMe) {
                    JerseyNettyExtension.zeroOut(this.bindLatch);
                    JerseyNettyExtension.zeroOut(this.shutdownLatch);
                    ArrayList arrayList = bindProblems;
                    synchronized (arrayList) {
                        for (Throwable bindProblem : bindProblems) {
                            throwMe.addSuppressed(bindProblem);
                        }
                    }
                    throw throwMe;
                }
            }
            if ((bindLatch = this.bindLatch) != null) {
                try {
                    bindLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                assert (bindLatch.getCount() <= 0L);
                this.bindLatch = null;
            }
            DeploymentException throwMe = null;
            ArrayList arrayList = bindProblems;
            synchronized (arrayList) {
                for (Throwable bindProblem : bindProblems) {
                    if (throwMe == null) {
                        throwMe = new DeploymentException(bindProblem);
                        continue;
                    }
                    throwMe.addSuppressed(bindProblem);
                }
                bindProblems.clear();
            }
            if (throwMe != null) {
                JerseyNettyExtension.zeroOut(this.shutdownLatch);
                throw throwMe;
            }
            this.runLatch = new CountDownLatch(1);
        }
        assert (this.bindLatch == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitForAllServersToStop(@Observes @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        CountDownLatch shutdownLatch;
        Collection<EventExecutorGroup> eventExecutorGroups;
        CountDownLatch runLatch = this.runLatch;
        if (runLatch != null) {
            try {
                runLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            assert (runLatch.getCount() <= 0L);
            this.runLatch = null;
        }
        if ((eventExecutorGroups = this.eventExecutorGroups) != null) {
            Collection<EventExecutorGroup> collection = eventExecutorGroups;
            synchronized (collection) {
                for (EventExecutorGroup group : eventExecutorGroups) {
                    group.shutdownGracefully();
                }
                eventExecutorGroups.clear();
            }
            this.eventExecutorGroups = null;
        }
        if ((shutdownLatch = this.shutdownLatch) != null) {
            try {
                shutdownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            assert (shutdownLatch.getCount() <= 0L);
            this.shutdownLatch = null;
        }
        DeploymentException throwMe = null;
        Collection<Throwable> collection = this.shutdownProblems;
        synchronized (collection) {
            for (Throwable shutdownProblem : this.shutdownProblems) {
                if (throwMe == null) {
                    throwMe = new DeploymentException(shutdownProblem);
                    continue;
                }
                throwMe.addSuppressed(shutdownProblem);
            }
            this.shutdownProblems.clear();
        }
        if (throwMe != null) {
            throw throwMe;
        }
    }

    private static final SslContext getSslContext(BeanManager beanManager, Instance<Object> instance, Annotation[] qualifiersArray, boolean lookup) {
        return JerseyNettyExtension.acquire(beanManager, instance, SslContext.class, qualifiersArray, lookup, (BeanManager bm, Instance<Object> i, Annotation[] qa) -> null);
    }

    private static final ServerBootstrap getServerBootstrap(BeanManager beanManager, Instance<Object> instance, Annotation[] qualifiersArray, boolean lookup) {
        return JerseyNettyExtension.acquire(beanManager, instance, ServerBootstrap.class, qualifiersArray, lookup, (BeanManager bm, Instance<Object> i, Annotation[] qa) -> {
            ServerBootstrap returnValue = new ServerBootstrap();
            returnValue.group(JerseyNettyExtension.getEventLoopGroup(bm, (Instance<Object>)i, qa, true));
            returnValue.channelFactory(JerseyNettyExtension.getChannelFactory(bm, (Instance<Object>)i, qa, true));
            beanManager.getEvent().select(ServerBootstrap.class, qualifiersArray).fire((Object)returnValue);
            return returnValue;
        });
    }

    private static final ChannelFactory<? extends ServerChannel> getChannelFactory(BeanManager beanManager, Instance<Object> instance, Annotation[] qualifiersArray, boolean lookup) {
        return JerseyNettyExtension.acquire(beanManager, instance, new TypeLiteral<ChannelFactory<? extends ServerChannel>>(){
            private static final long serialVersionUID = 1L;
        }, qualifiersArray, lookup, (BeanManager bm, Instance<Object> i, Annotation[] qa) -> {
            SelectorProvider selectorProvider = JerseyNettyExtension.getSelectorProvider(bm, (Instance<Object>)i, qa, true);
            assert (selectorProvider != null);
            return () -> new NioServerSocketChannel(selectorProvider);
        });
    }

    private static final EventLoopGroup getEventLoopGroup(BeanManager beanManager, Instance<Object> instance, Annotation[] qualifiersArray, boolean lookup) {
        return JerseyNettyExtension.acquire(beanManager, instance, EventLoopGroup.class, qualifiersArray, lookup, (BeanManager bm, Instance<Object> i, Annotation[] qa) -> {
            NioEventLoopGroup returnValue = new NioEventLoopGroup(0, JerseyNettyExtension.getExecutor(bm, (Instance<Object>)i, qa, true), JerseyNettyExtension.getEventExecutorChooserFactory(bm, (Instance<Object>)i, qa, true), JerseyNettyExtension.getSelectorProvider(bm, (Instance<Object>)i, qa, true), JerseyNettyExtension.getSelectStrategyFactory(bm, (Instance<Object>)i, qa, true), JerseyNettyExtension.getRejectedExecutionHandler(bm, (Instance<Object>)i, qa, true));
            beanManager.getEvent().select(EventLoopGroup.class, qa).fire((Object)returnValue);
            return returnValue;
        });
    }

    private static final Executor getExecutor(BeanManager beanManager, Instance<Object> instance, Annotation[] qualifiersArray, boolean lookup) {
        return JerseyNettyExtension.acquire(beanManager, instance, Executor.class, qualifiersArray, lookup, (BeanManager bm, Instance<Object> i, Annotation[] qa) -> null);
    }

    private static final RejectedExecutionHandler getRejectedExecutionHandler(BeanManager beanManager, Instance<Object> instance, Annotation[] qualifiersArray, boolean lookup) {
        return JerseyNettyExtension.acquire(beanManager, instance, RejectedExecutionHandler.class, qualifiersArray, lookup, (BeanManager bm, Instance<Object> i, Annotation[] qa) -> RejectedExecutionHandlers.reject());
    }

    private static final SelectorProvider getSelectorProvider(BeanManager beanManager, Instance<Object> instance, Annotation[] qualifiersArray, boolean lookup) {
        return JerseyNettyExtension.acquire(beanManager, instance, SelectorProvider.class, qualifiersArray, lookup, (BeanManager bm, Instance<Object> i, Annotation[] qa) -> SelectorProvider.provider());
    }

    private static final SelectStrategyFactory getSelectStrategyFactory(BeanManager beanManager, Instance<Object> instance, Annotation[] qualifiersArray, boolean lookup) {
        return JerseyNettyExtension.acquire(beanManager, instance, SelectStrategyFactory.class, qualifiersArray, lookup, (BeanManager bm, Instance<Object> i, Annotation[] qa) -> DefaultSelectStrategyFactory.INSTANCE);
    }

    private static final EventExecutorChooserFactory getEventExecutorChooserFactory(BeanManager beanManager, Instance<Object> instance, Annotation[] qualifiersArray, boolean lookup) {
        return JerseyNettyExtension.acquire(beanManager, instance, EventExecutorChooserFactory.class, qualifiersArray, lookup, (BeanManager bm, Instance<Object> i, Annotation[] qa) -> DefaultEventExecutorChooserFactory.INSTANCE);
    }

    private static final <T> T acquire(BeanManager beanManager, Instance<Object> instance, TypeLiteral<T> typeLiteral, Annotation[] qualifiersArray, boolean lookup, DefaultValueFunction<? extends T> defaultValueFunction) {
        Objects.requireNonNull(beanManager);
        Objects.requireNonNull(instance);
        Objects.requireNonNull(typeLiteral);
        Objects.requireNonNull(defaultValueFunction);
        Instance tInstance = lookup ? (qualifiersArray == null || qualifiersArray.length <= 0 ? instance.select(typeLiteral, new Annotation[0]) : instance.select(typeLiteral, qualifiersArray)) : null;
        Object returnValue = tInstance == null || tInstance.isUnsatisfied() ? defaultValueFunction.getDefaultValue(beanManager, instance, qualifiersArray) : tInstance.get();
        return (T)returnValue;
    }

    private static final <T> T acquire(BeanManager beanManager, Instance<Object> instance, Class<T> cls, Annotation[] qualifiersArray, boolean lookup, DefaultValueFunction<? extends T> defaultValueFunction) {
        Objects.requireNonNull(beanManager);
        Objects.requireNonNull(instance);
        Objects.requireNonNull(cls);
        Objects.requireNonNull(defaultValueFunction);
        Instance tInstance = lookup ? (qualifiersArray == null || qualifiersArray.length <= 0 ? instance.select(cls, new Annotation[0]) : instance.select(cls, qualifiersArray)) : null;
        Object returnValue = tInstance == null || tInstance.isUnsatisfied() ? defaultValueFunction.getDefaultValue(beanManager, instance, qualifiersArray) : tInstance.get();
        return (T)returnValue;
    }

    private static final void zeroOut(CountDownLatch latch) {
        if (latch != null) {
            while (latch.getCount() > 0L) {
                latch.countDown();
            }
            assert (latch.getCount() == 0L);
        }
    }

    private static final Map<String, String> toConfigurationCoordinates(Set<? extends Annotation> qualifiers) {
        HashMap<String, String> returnValue = new HashMap<String, String>();
        if (qualifiers != null && !qualifiers.isEmpty()) {
            for (Annotation annotation : qualifiers) {
                if (annotation instanceof Named) {
                    returnValue.put("name", ((Named)annotation).value());
                    continue;
                }
                if (annotation instanceof Default || annotation instanceof Any) continue;
                returnValue.put(annotation.toString(), "");
            }
        }
        return returnValue;
    }

    @FunctionalInterface
    private static interface DefaultValueFunction<T> {
        public T getDefaultValue(BeanManager var1, Instance<Object> var2, Annotation[] var3);
    }
}

