/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.remote;

import mmcorej.CMMCore;
import org.micromanager.acqj.internal.Engine;
import org.micromanager.remote.RemoteAcquisition;
import org.micromanager.remote.RemoteEventSource;
import org.micromanager.remote.RemoteViewerStorageAdapter;
import org.micromanager.remote.XYTiledRemoteAcquisition;

public class RemoteAcquisitionFactory {
    private Engine eng_ = Engine.getInstance();

    public RemoteAcquisitionFactory(CMMCore core) {
        if (this.eng_ == null) {
            this.eng_ = new Engine(core);
        }
    }

    public XYTiledRemoteAcquisition createTiledAcquisition(String dir, String name, boolean showViewer, boolean xyTiled, int tileOverlapX, int tileOverlapY, int maxResLevel, int savingQueueSize, boolean debug) {
        RemoteEventSource eventSource = new RemoteEventSource();
        RemoteViewerStorageAdapter adapter = null;
        if (name != null && dir != null) {
            adapter = new RemoteViewerStorageAdapter(showViewer, dir, name, xyTiled, tileOverlapX, tileOverlapY, maxResLevel == -1 ? null : Integer.valueOf(maxResLevel), savingQueueSize);
        }
        return new XYTiledRemoteAcquisition(eventSource, adapter, debug);
    }

    public RemoteAcquisition createAcquisition(String dir, String name, boolean showViewer, int savingQueueSize, boolean debug) {
        RemoteEventSource eventSource = new RemoteEventSource();
        RemoteViewerStorageAdapter adapter = null;
        if (name != null && dir != null) {
            adapter = new RemoteViewerStorageAdapter(showViewer, dir, name, false, 0, 0, null, savingQueueSize);
        }
        return new RemoteAcquisition(eventSource, adapter, debug);
    }
}

