/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.internal.zmq;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import mmcorej.org.json.JSONArray;
import mmcorej.org.json.JSONException;
import mmcorej.org.json.JSONObject;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

public abstract class ZMQSocketWrapper {
    protected static ZContext context_;
    private static ConcurrentHashMap<Integer, ZMQSocketWrapper> portSocketMap_;
    public static int STARTING_PORT_NUMBER;
    protected SocketType type_;
    protected volatile ZMQ.Socket socket_;
    protected int port_;

    public ZMQSocketWrapper(SocketType type, int port) {
        STARTING_PORT_NUMBER = port;
        this.type_ = type;
        if (context_ == null) {
            context_ = new ZContext();
        }
        this.port_ = ZMQSocketWrapper.nextPortNumber(this);
        this.initialize(this.port_);
    }

    public ZMQSocketWrapper(SocketType type) {
        this(type, STARTING_PORT_NUMBER);
    }

    private static synchronized int nextPortNumber(ZMQSocketWrapper t) {
        int port = STARTING_PORT_NUMBER;
        while (portSocketMap_.containsKey(port)) {
            ++port;
        }
        portSocketMap_.put(port, t);
        return port;
    }

    public int getPort() {
        return this.port_;
    }

    public abstract void initialize(int var1);

    public void close() {
        this.socket_.close();
        portSocketMap_.remove(this.getPort());
    }

    private void recurseBinaryData(ArrayList<byte[]> binaryData, Object json) throws JSONException {
        block5: {
            block4: {
                if (!(json instanceof JSONObject)) break block4;
                Iterator keys = ((JSONObject)json).keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    Object value = ((JSONObject)json).get(key);
                    if (value instanceof byte[]) {
                        binaryData.add((byte[])value);
                        continue;
                    }
                    if (!(value instanceof JSONObject) && !(value instanceof JSONArray)) continue;
                    this.recurseBinaryData(binaryData, value);
                }
                break block5;
            }
            if (!(json instanceof JSONArray)) break block5;
            for (int i = 0; i < ((JSONArray)json).length(); ++i) {
                Object value = ((JSONArray)json).get(i);
                if (value instanceof byte[]) {
                    binaryData.add((byte[])value);
                    continue;
                }
                if (!(value instanceof JSONObject) && !(value instanceof JSONArray)) continue;
                this.recurseBinaryData(binaryData, value);
            }
        }
    }

    public void sendMessage(JSONObject json) {
        ArrayList<byte[]> byteData = new ArrayList<byte[]>();
        try {
            this.recurseBinaryData(byteData, json);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        if (byteData.size() == 0) {
            this.socket_.send(json.toString().getBytes(StandardCharsets.ISO_8859_1));
        } else {
            this.socket_.sendMore(json.toString().getBytes(StandardCharsets.ISO_8859_1));
            for (int i = 0; i < byteData.size() - 1; ++i) {
                this.socket_.sendMore(ByteBuffer.allocate(4).order(ByteOrder.nativeOrder()).putInt(System.identityHashCode(byteData.get(i))).array());
                this.socket_.sendMore(byteData.get(i));
            }
            this.socket_.sendMore(ByteBuffer.allocate(4).order(ByteOrder.nativeOrder()).putInt(System.identityHashCode(byteData.get(byteData.size() - 1))).array());
            this.socket_.send(byteData.get(byteData.size() - 1));
        }
    }

    private void insertByteBuffer(Object json, long hash, byte[] value) throws JSONException {
        block7: {
            block6: {
                if (!(json instanceof JSONObject)) break block6;
                Iterator keys = ((JSONObject)json).keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    Object o = ((JSONObject)json).get(key);
                    if (o instanceof String && ((String)o).contains("@")) {
                        int intID = Integer.parseInt(((String)o).substring(1).split("_")[0]);
                        int bytesPerEntry = Integer.parseInt(((String)o).substring(1).split("_")[1]);
                        if ((long)intID != hash) continue;
                        ((JSONObject)json).put(key, this.decodeByteArray(value, bytesPerEntry));
                        return;
                    }
                    if (o instanceof JSONObject) {
                        this.insertByteBuffer(o, hash, value);
                        continue;
                    }
                    if (!(o instanceof JSONArray)) continue;
                    this.insertByteBuffer(o, hash, value);
                }
                break block7;
            }
            if (!(json instanceof JSONArray)) break block7;
            for (int i = 0; i < ((JSONArray)json).length(); ++i) {
                Object o = ((JSONArray)json).get(i);
                if (o instanceof String && ((String)o).contains("@")) {
                    int intID = Integer.parseInt(((String)o).substring(1).split("_")[0]);
                    int bytesPerEntry = Integer.parseInt(((String)o).substring(1).split("_")[1]);
                    if ((long)intID != hash) continue;
                    ((JSONArray)json).put(i, this.decodeByteArray(value, bytesPerEntry));
                    return;
                }
                if (o instanceof JSONObject) {
                    this.insertByteBuffer(o, hash, value);
                    continue;
                }
                if (!(o instanceof JSONArray)) continue;
                this.insertByteBuffer(o, hash, value);
            }
        }
    }

    private Object decodeByteArray(byte[] value, int bytesPerEntry) {
        if (bytesPerEntry == 0) {
            return value;
        }
        if (bytesPerEntry == 1) {
            return value;
        }
        if (bytesPerEntry == 2) {
            short[] shorts = new short[value.length / 2];
            ByteBuffer.wrap(value).order(ByteOrder.nativeOrder()).asShortBuffer().get(shorts);
            return shorts;
        }
        if (bytesPerEntry == 4) {
            int[] ints = new int[value.length / 4];
            ByteBuffer.wrap(value).order(ByteOrder.nativeOrder()).asIntBuffer().get(ints);
            return ints;
        }
        throw new RuntimeException("unknown bytes per pixel");
    }

    public JSONObject receiveMessage() {
        JSONObject json;
        ArrayList<byte[]> byteData = new ArrayList<byte[]>();
        String message = new String(this.socket_.recv(), StandardCharsets.ISO_8859_1);
        try {
            json = new JSONObject(message);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        while (this.socket_.hasReceiveMore()) {
            byteData.add(this.socket_.recv());
        }
        for (int i = 0; i < byteData.size(); i += 2) {
            ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])byteData.get(i));
            int hash = byteBuffer.order(ByteOrder.nativeOrder()).asIntBuffer().get();
            byte[] value = (byte[])byteData.get(i + 1);
            try {
                this.insertByteBuffer(json, hash, value);
                continue;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return json;
    }

    static {
        portSocketMap_ = new ConcurrentHashMap();
        STARTING_PORT_NUMBER = 4827;
    }
}

