/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.explore.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.EventListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.micromanager.acqj.internal.Engine;
import org.micromanager.acqj.internal.ZAxis;
import org.micromanager.explore.ExploreAcquisition;
import org.micromanager.explore.gui.ColorableScrollbarUI;

public class ZAxisLimitControlPanel
extends JPanel {
    private JScrollBar zTopScrollbar_;
    private JScrollBar zBottomScrollbar_;
    private JTextField zTopTextField_;
    private JTextField zBottomTextField_;
    private double zStep_;
    private double zOrigin_;
    private int displayHeight_ = -1;
    private int minZExplored_ = Integer.MAX_VALUE;
    private int maxZExplored_ = Integer.MIN_VALUE;
    private static final DecimalFormat TWO_DECIMAL_FORMAT = new DecimalFormat("0.00");
    private final String name_;
    private final ExploreAcquisition acquisition_;

    public ZAxisLimitControlPanel(ExploreAcquisition acquisition, ZAxis zaxis) {
        super((LayoutManager)new MigLayout("insets 0", "[][][grow]", ""));
        double zPos;
        this.name_ = zaxis.name_;
        this.zStep_ = zaxis.zStep_um_;
        this.zOrigin_ = zaxis.zOrigin_um_;
        this.acquisition_ = acquisition;
        try {
            this.zTopScrollbar_ = new JScrollBar(0, 0, 1, -1, 2);
            this.zBottomScrollbar_ = new JScrollBar(0, 0, 1, -1, 2);
            this.zTopScrollbar_.setUI(new ColorableScrollbarUI(zaxis.name_));
            this.zBottomScrollbar_.setUI(new ColorableScrollbarUI(zaxis.name_));
        }
        catch (Exception e) {
            throw new RuntimeException("problem creating z limit scrollbars");
        }
        this.zTopTextField_ = new JTextField(TWO_DECIMAL_FORMAT.format(this.zOrigin_));
        this.zTopTextField_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ZAxisLimitControlPanel.this.zTopTextFieldAction();
            }
        });
        this.zBottomTextField_ = new JTextField(TWO_DECIMAL_FORMAT.format(this.zOrigin_));
        this.zBottomTextField_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ZAxisLimitControlPanel.this.zBottomTextFieldAction();
            }
        });
        this.zTopScrollbar_.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent ae) {
                ZAxisLimitControlPanel.this.zTopSliderAdjustment();
            }
        });
        this.zBottomScrollbar_.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent ae) {
                ZAxisLimitControlPanel.this.zBottomSliderAdjustment();
            }
        });
        try {
            zPos = Engine.getCore().getPosition(this.name_);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.zTopTextField_.setText(TWO_DECIMAL_FORMAT.format(zPos));
        this.zBottomTextField_.setText(TWO_DECIMAL_FORMAT.format(zPos));
        this.zTopTextField_.getActionListeners()[0].actionPerformed(null);
        this.zBottomTextField_.getActionListeners()[0].actionPerformed(null);
        this.add((Component)new JLabel(zaxis.name_ + " limits"), "span 1 2");
        if (ZAxisLimitControlPanel.isMac()) {
            this.add((Component)this.zTopTextField_, "w 80!");
            this.add((Component)this.zTopScrollbar_, "growx, wrap");
            this.add((Component)this.zBottomTextField_, "w 80!");
            this.add((Component)this.zBottomScrollbar_, "growx");
        } else {
            this.add((Component)this.zTopTextField_, "w 50!");
            this.add((Component)this.zTopScrollbar_, "growx, wrap");
            this.add((Component)this.zBottomTextField_, "w 50!");
            this.add((Component)this.zBottomScrollbar_, "growx");
        }
    }

    private static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("mac") >= 0;
    }

    private void zTopSliderAdjustment() {
        if (this.zTopScrollbar_.getValue() > this.zBottomScrollbar_.getValue()) {
            this.zBottomScrollbar_.setValue(this.zTopScrollbar_.getValue());
        }
        this.expandZLimitsIfNeeded(this.zTopScrollbar_.getValue(), this.zBottomScrollbar_.getValue());
        this.updateZTopAndBottom();
    }

    private void zBottomSliderAdjustment() {
        if (this.zTopScrollbar_.getValue() > this.zBottomScrollbar_.getValue()) {
            this.zTopScrollbar_.setValue(this.zBottomScrollbar_.getValue());
        }
        this.expandZLimitsIfNeeded(this.zTopScrollbar_.getValue(), this.zBottomScrollbar_.getValue());
        this.updateZTopAndBottom();
    }

    private void updateZTopAndBottom() {
        double zBottom = this.zStep_ * (double)this.zBottomScrollbar_.getValue() + this.zOrigin_;
        this.zBottomTextField_.setText(TWO_DECIMAL_FORMAT.format(zBottom));
        double zTop = this.zStep_ * (double)this.zTopScrollbar_.getValue() + this.zOrigin_;
        this.zTopTextField_.setText(TWO_DECIMAL_FORMAT.format(zTop));
        this.acquisition_.setZLimits(this.name_, zTop, zBottom);
    }

    public void expandZLimitSliders(int sliceIndex) {
        if (this.zTopScrollbar_.getMaximum() < sliceIndex + 1) {
            this.zTopScrollbar_.setMaximum(sliceIndex + 2);
        }
        if (this.zBottomScrollbar_.getMaximum() < sliceIndex + 1) {
            this.zBottomScrollbar_.setMaximum(sliceIndex + 2);
        }
        if (this.zTopScrollbar_.getMinimum() > sliceIndex - 1) {
            this.zTopScrollbar_.setMinimum(sliceIndex - 1);
        }
        if (this.zBottomScrollbar_.getMinimum() > sliceIndex - 1) {
            this.zBottomScrollbar_.setMinimum(sliceIndex - 1);
        }
        this.repaint();
    }

    private void expandZLimitsIfNeeded(int topScrollbarIndex, int bottomScrollbarIndex) {
        if (topScrollbarIndex >= this.zTopScrollbar_.getMaximum() - 1 || bottomScrollbarIndex >= this.zBottomScrollbar_.getMaximum() - 1) {
            this.zTopScrollbar_.setMaximum(Math.max(topScrollbarIndex, bottomScrollbarIndex) + 2);
            this.zBottomScrollbar_.setMaximum(Math.max(topScrollbarIndex, bottomScrollbarIndex) + 2);
        }
        if (bottomScrollbarIndex <= this.zBottomScrollbar_.getMinimum() || topScrollbarIndex <= this.zTopScrollbar_.getMinimum()) {
            this.zTopScrollbar_.setMinimum(Math.min(bottomScrollbarIndex, topScrollbarIndex) - 1);
            this.zBottomScrollbar_.setMinimum(Math.min(bottomScrollbarIndex, topScrollbarIndex) - 1);
        }
        this.repaint();
    }

    public void onDisplayClose() {
        if (this.zBottomScrollbar_ != null) {
            for (AdjustmentListener adjustmentListener : this.zBottomScrollbar_.getAdjustmentListeners()) {
                this.zBottomScrollbar_.removeAdjustmentListener(adjustmentListener);
            }
            for (AdjustmentListener adjustmentListener : this.zTopScrollbar_.getAdjustmentListeners()) {
                this.zTopScrollbar_.removeAdjustmentListener(adjustmentListener);
            }
            for (EventListener eventListener : this.zBottomTextField_.getActionListeners()) {
                this.zBottomTextField_.removeActionListener((ActionListener)eventListener);
            }
            for (EventListener eventListener : this.zTopTextField_.getActionListeners()) {
                this.zTopTextField_.removeActionListener((ActionListener)eventListener);
            }
        }
    }

    private void zTopTextFieldAction() {
        double val = ZAxisLimitControlPanel.parseDouble(this.zTopTextField_.getText());
        int newSliderindex = (int)Math.round((val - this.zOrigin_) / this.zStep_);
        this.expandZLimitsIfNeeded(newSliderindex, this.zBottomScrollbar_.getValue());
        this.zTopScrollbar_.setValue(newSliderindex);
        this.updateZTopAndBottom();
    }

    private void zBottomTextFieldAction() {
        double val = ZAxisLimitControlPanel.parseDouble(this.zBottomTextField_.getText());
        int newSliderindex = (int)Math.round((val - this.zOrigin_) / this.zStep_);
        this.expandZLimitsIfNeeded(this.zTopScrollbar_.getValue(), newSliderindex);
        this.zBottomScrollbar_.setValue(newSliderindex);
        this.updateZTopAndBottom();
    }

    private static double parseDouble(String s) {
        try {
            return DecimalFormat.getNumberInstance().parse(s).doubleValue();
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void updateZDrivelocation(Integer zIndex) {
        this.minZExplored_ = Math.min(this.minZExplored_, zIndex);
        this.maxZExplored_ = Math.max(this.maxZExplored_, zIndex);
        ((ColorableScrollbarUI)this.zTopScrollbar_.getUI()).setHighlightedIndices(zIndex, this.minZExplored_, this.maxZExplored_);
        ((ColorableScrollbarUI)this.zBottomScrollbar_.getUI()).setHighlightedIndices(zIndex, this.minZExplored_, this.maxZExplored_);
        this.expandZLimitSliders(zIndex);
        this.repaint();
    }
}

