/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.explore.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.micromanager.acqj.internal.ZAxis;
import org.micromanager.explore.ChannelGroupSettings;
import org.micromanager.explore.ExploreAcquisition;
import org.micromanager.explore.gui.ExploreZSliders;
import org.micromanager.explore.gui.SimpleChannelTableModel;
import org.micromanager.ndviewer.api.ControlsPanelInterface;
import org.micromanager.ndviewer.api.OverlayerPlugin;

public class ExploreControlsPanel
extends JPanel
implements ControlsPanelInterface {
    private ChannelGroupSettings channels_;
    private ExploreAcquisition acquisition_;
    private HashMap<String, ExploreZSliders> zSlidersList_ = new HashMap();
    private OverlayerPlugin overlayer_;
    private JButton acquireAtCurrentButton_;
    private JTable channelsTable_;
    private JPanel jPanel1;
    private JScrollPane channelsScrollPane_;
    private JButton selectUseAllButton_;
    private JButton syncExposuresButton_;
    private JPanel zPanelPanel_;

    public ExploreControlsPanel(ExploreAcquisition acquisition, OverlayerPlugin overlayer, ChannelGroupSettings channels, HashMap<String, ZAxis> zAxes) {
        this.channels_ = channels;
        this.overlayer_ = overlayer;
        this.acquisition_ = acquisition;
        try {
            for (String name : zAxes.keySet()) {
                this.zSlidersList_.put(name, new ExploreZSliders(acquisition, zAxes.get(name)));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.initComponents();
        JTextField tf = new JTextField();
        tf.setHorizontalAlignment(2);
        DefaultCellEditor ed = new DefaultCellEditor(tf);
        this.channelsTable_.getColumnModel().getColumn(2).setCellEditor(ed);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(2);
        this.channelsTable_.getColumnModel().getColumn(2).setCellRenderer(renderer);
        this.channelsTable_.getColumnModel().getColumn(0).setMaxWidth(30);
        if (this.channels_ == null) {
            this.channelsScrollPane_.setVisible(false);
            this.selectUseAllButton_.setVisible(false);
            this.syncExposuresButton_.setVisible(false);
        }
    }

    public void updateGUIToReflectHardwareZPosition(String name, Integer zIndex) {
        for (String slidersName : this.zSlidersList_.keySet()) {
            if (!slidersName.equals(name)) continue;
            this.zSlidersList_.get(name).updateZDrivelocation(zIndex);
        }
    }

    public void selected() {
    }

    public void deselected() {
    }

    public String getTitle() {
        return "Explore controls";
    }

    public void close() {
        this.acquisition_ = null;
        this.channelsTable_ = null;
        for (ExploreZSliders zSliders : this.zSlidersList_.values()) {
            zSliders.onDisplayClose();
        }
        this.zSlidersList_ = null;
    }

    private void initComponents() {
        this.acquireAtCurrentButton_ = new JButton();
        this.selectUseAllButton_ = new JButton();
        this.syncExposuresButton_ = new JButton();
        this.channelsScrollPane_ = new JScrollPane();
        this.channelsTable_ = new JTable();
        this.acquireAtCurrentButton_.setText("Acquire at current position");
        this.acquireAtCurrentButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExploreControlsPanel.this.acquireAtCurrentButtonActionPerformed(evt);
            }
        });
        this.selectUseAllButton_.setText("Select all");
        this.selectUseAllButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExploreControlsPanel.this.selectUseAllButtonActionPerformed(evt);
            }
        });
        this.syncExposuresButton_.setText("Sync exposures");
        this.syncExposuresButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExploreControlsPanel.this.syncExposuresButtonActionPerformed(evt);
            }
        });
        this.channelsTable_.setModel(new SimpleChannelTableModel(this.channels_));
        this.channelsScrollPane_.setViewportView(this.channelsTable_);
        this.setLayout((LayoutManager)new MigLayout());
        this.setMaximumSize(new Dimension(this.getPreferredSize().width, this.getPreferredSize().height));
        this.add((Component)this.acquireAtCurrentButton_, "wrap");
        JPanel sliderPanel = new JPanel((LayoutManager)new MigLayout());
        for (ExploreZSliders zSliders : this.zSlidersList_.values()) {
            sliderPanel.add((Component)zSliders, "grow, wrap");
        }
        this.add((Component)sliderPanel, "growx, wrap");
        sliderPanel.setPreferredSize(new Dimension(650, sliderPanel.getPreferredSize().height));
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.selectUseAllButton_);
        buttonPanel.add(this.syncExposuresButton_);
        this.add((Component)buttonPanel, "wrap");
        this.add((Component)this.channelsScrollPane_, "growx");
    }

    private void syncExposuresButtonActionPerformed(ActionEvent evt) {
        ((SimpleChannelTableModel)this.channelsTable_.getModel()).synchronizeExposures();
        ((SimpleChannelTableModel)this.channelsTable_.getModel()).fireTableDataChanged();
    }

    private void selectUseAllButtonActionPerformed(ActionEvent evt) {
        ((SimpleChannelTableModel)this.channelsTable_.getModel()).selectAllChannels();
        ((SimpleChannelTableModel)this.channelsTable_.getModel()).fireTableDataChanged();
    }

    private void acquireAtCurrentButtonActionPerformed(ActionEvent evt) {
        try {
            this.acquisition_.acquireTileAtCurrentLocation();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
        }
    }
}

