/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.explore;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import javax.swing.SwingUtilities;
import mmcorej.TaggedImage;
import mmcorej.org.json.JSONException;
import mmcorej.org.json.JSONObject;
import org.micromanager.acqj.api.AcqEngJDataSink;
import org.micromanager.acqj.internal.Engine;
import org.micromanager.acqj.main.AcqEngMetadata;
import org.micromanager.acqj.main.Acquisition;
import org.micromanager.explore.ChannelGroupSettings;
import org.micromanager.explore.ExploreAcquisition;
import org.micromanager.explore.gui.ExploreControlsPanel;
import org.micromanager.explore.gui.ExploreMouseListener;
import org.micromanager.explore.gui.ExploreOverlayer;
import org.micromanager.ndtiffstorage.MultiresNDTiffAPI;
import org.micromanager.ndtiffstorage.NDTiffStorage;
import org.micromanager.ndviewer.api.CanvasMouseListenerInterface;
import org.micromanager.ndviewer.api.ControlsPanelInterface;
import org.micromanager.ndviewer.api.NDViewerAPI;
import org.micromanager.ndviewer.api.NDViewerAcqInterface;
import org.micromanager.ndviewer.api.NDViewerDataSource;
import org.micromanager.ndviewer.api.OverlayerPlugin;
import org.micromanager.ndviewer.main.NDViewer;
import org.micromanager.remote.PycroManagerCompatibleUI;

public class ExploreAcqUIAndStorage
implements AcqEngJDataSink,
NDViewerDataSource,
PycroManagerCompatibleUI {
    private static final int SAVING_QUEUE_SIZE = 30;
    protected MultiresNDTiffAPI storage_;
    private ExecutorService displayCommunicationExecutor_;
    public final boolean loadedData_;
    private String dir_;
    private String name_;
    private final boolean showDisplay_;
    protected NDViewer display_;
    private JSONObject summaryMetadata_;
    private CopyOnWriteArrayList<String> channelNames_ = new CopyOnWriteArrayList();
    private LinkedList<Consumer<HashMap<String, Object>>> displayUpdateOnImageHooks_ = new LinkedList();
    private OverlayerPlugin overlayer_;
    protected ExploreAcquisition acq_;
    protected ExploreMouseListener mouseListener_;
    protected ExploreControlsPanel exploreControlsPanel_;
    private Consumer<String> logger_;
    private ChannelGroupSettings channels_;

    public static ExploreAcqUIAndStorage create(String dir, String name, int overlapX, int overlapY, double zStep, String channelGroup) throws Exception {
        ChannelGroupSettings channels = new ChannelGroupSettings(channelGroup);
        ExploreAcqUIAndStorage exploreAcqUIAndStorage = new ExploreAcqUIAndStorage(dir, name, true, channels, s -> {});
        ExploreAcquisition acquisition = new ExploreAcquisition(overlapX, overlapY, zStep, channels, exploreAcqUIAndStorage);
        return exploreAcqUIAndStorage;
    }

    public ExploreAcqUIAndStorage(String dir, String name, boolean showDisplay, ChannelGroupSettings exploreChannels, Consumer<String> logger) {
        this.displayCommunicationExecutor_ = Executors.newSingleThreadExecutor(r -> new Thread(r, "Magellan viewer communication thread"));
        this.logger_ = logger;
        this.dir_ = dir;
        this.name_ = name;
        this.loadedData_ = false;
        this.showDisplay_ = showDisplay;
        this.channels_ = exploreChannels;
    }

    public ExploreAcqUIAndStorage(String dir, String name, boolean showDisplay, ChannelGroupSettings exploreChannels) {
        this(dir, name, showDisplay, exploreChannels, s -> {});
    }

    public ExploreAcqUIAndStorage(String dir, Consumer<String> logger) throws IOException {
        this.logger_ = logger;
        this.displayCommunicationExecutor_ = Executors.newSingleThreadExecutor(r -> new Thread(r, "Magellan viewer communication thread"));
        this.storage_ = new NDTiffStorage(dir);
        this.dir_ = dir;
        this.loadedData_ = true;
        this.showDisplay_ = true;
        this.summaryMetadata_ = this.storage_.getSummaryMetadata();
        this.createDisplay();
    }

    @Override
    public NDViewerAPI getViewer() {
        return this.display_;
    }

    public ExploreAcquisition getAcquisition() {
        return this.acq_;
    }

    public void initialize(Acquisition acq, JSONObject summaryMetadata) {
        this.acq_ = (ExploreAcquisition)acq;
        this.summaryMetadata_ = summaryMetadata;
        AcqEngMetadata.setHeight((JSONObject)summaryMetadata, (int)((int)Engine.getCore().getImageHeight()));
        AcqEngMetadata.setWidth((JSONObject)summaryMetadata, (int)((int)Engine.getCore().getImageWidth()));
        this.storage_ = new NDTiffStorage(this.dir_, this.name_, summaryMetadata, AcqEngMetadata.getPixelOverlapX((JSONObject)summaryMetadata), AcqEngMetadata.getPixelOverlapY((JSONObject)summaryMetadata), true, null, 30, Engine.getCore().debugLogEnabled() ? s -> Engine.getCore().logMessage(s) : null, true);
        boolean addExploreControls = true;
        if (this.showDisplay_) {
            this.createDisplay();
        }
        this.name_ = this.getUniqueAcqName();
    }

    public MultiresNDTiffAPI getStorage() {
        return this.storage_;
    }

    private void moveViewToVisibleArea() {
        HashSet<Point> tiles = new HashSet<Point>();
        for (String zName : this.acq_.getZAxes().keySet()) {
            tiles.addAll(this.getTileIndicesWithDataAt(zName, (Integer)this.display_.getAxisPosition(zName)));
        }
        if (tiles.size() == 0) {
            return;
        }
        double minDistance = 2.147483647E9;
        long currentX = (long)this.display_.getViewOffset().x;
        long currentY = (long)this.display_.getViewOffset().y;
        for (Point point : tiles) {
            long tileX1 = (long)((0.1 + (double)point.x) * (double)this.acq_.getPixelStageTranslator().getDisplayTileWidth());
            long tileX2 = (long)((0.9 + (double)point.x) * (double)this.acq_.getPixelStageTranslator().getDisplayTileWidth());
            long tileY1 = (long)((0.1 + (double)point.y) * (double)this.acq_.getPixelStageTranslator().getDisplayTileHeight());
            long tileY2 = (long)((0.9 + (double)point.y) * (double)this.acq_.getPixelStageTranslator().getDisplayTileHeight());
            long fovX1 = (long)this.display_.getViewOffset().x;
            long fovY1 = (long)this.display_.getViewOffset().y;
            long fovX2 = (long)((double)fovX1 + this.display_.getFullResSourceDataSize().x);
            long fovY2 = (long)((double)fovY1 + this.display_.getFullResSourceDataSize().y);
            boolean xInView = fovX1 < tileX2 && fovX2 > tileX1;
            boolean yInView = fovY1 < tileY2 && fovY2 > tileY1;
            boolean intersection = xInView && yInView;
            if (!intersection) continue;
            return;
        }
        ArrayList<Point2D.Double> newPos = new ArrayList<Point2D.Double>();
        for (Point p : tiles) {
            long newY;
            long newX;
            currentX = (long)this.display_.getViewOffset().x;
            currentY = (long)this.display_.getViewOffset().y;
            long tileX1 = (long)((0.1 + (double)p.x) * (double)this.acq_.getPixelStageTranslator().getDisplayTileWidth());
            long tileX2 = (long)((0.9 + (double)p.x) * (double)this.acq_.getPixelStageTranslator().getDisplayTileWidth());
            long tileY1 = (long)((0.1 + (double)p.y) * (double)this.acq_.getPixelStageTranslator().getDisplayTileHeight());
            long tileY2 = (long)((0.9 + (double)p.y) * (double)this.acq_.getPixelStageTranslator().getDisplayTileHeight());
            long fovX1 = (long)this.display_.getViewOffset().x;
            long fovY1 = (long)this.display_.getViewOffset().y;
            long fovX2 = (long)((double)fovX1 + this.display_.getFullResSourceDataSize().x);
            long fovY2 = (long)((double)fovY1 + this.display_.getFullResSourceDataSize().y);
            boolean xInView = fovX1 < tileX2 && fovX2 > tileX1;
            boolean yInView = fovY1 < tileY2 && fovY2 > tileY1;
            double tl = (tileX1 - fovX2) * (tileX1 - fovX2) + (tileY1 - fovY2) * (tileY1 - fovY2);
            double tr = (tileX2 - fovX1) * (tileX2 - fovX1) + (tileY1 - fovY2) * (tileY1 - fovY2);
            double bl = (tileX1 - fovX2) * (tileX1 - fovX2) + (tileY2 - fovY1) * (tileY2 - fovY1);
            double br = (tileX1 - fovX1) * (tileX1 - fovX1) + (tileY2 - fovY1) * (tileY2 - fovY1);
            double closestCornerDistance = Math.min(Math.min(tl, tr), Math.min(bl, br));
            if (!(closestCornerDistance < minDistance)) continue;
            minDistance = closestCornerDistance;
            if (tl <= tr && tl <= bl && tl <= br) {
                newX = (long)(xInView ? (double)currentX : (double)tileX1 - this.display_.getFullResSourceDataSize().x);
                newY = (long)(yInView ? (double)currentY : (double)tileY1 - this.display_.getFullResSourceDataSize().y);
            } else if (tr <= tl && tr <= bl && tr <= br) {
                newX = xInView ? currentX : tileX2;
                newY = (long)(yInView ? (double)currentY : (double)tileY1 - this.display_.getFullResSourceDataSize().y);
            } else if (bl <= tl && bl <= tr && bl <= br) {
                newX = (long)(xInView ? (double)currentX : (double)tileX1 - this.display_.getFullResSourceDataSize().x);
                newY = yInView ? currentY : tileY2;
            } else {
                newX = xInView ? currentX : tileX2;
                newY = yInView ? currentY : tileY2;
            }
            newPos.add(new Point2D.Double(newX, newY));
        }
        long l = currentX;
        long finalCurrentY = currentY;
        DoubleStream dists = newPos.stream().mapToDouble(value -> Math.pow(value.x - (double)finalCurrentX, 2.0) + Math.pow(value.y - (double)finalCurrentY, 2.0));
        double minDist = dists.min().getAsDouble();
        Point2D.Double newPoint = (Point2D.Double)newPos.stream().filter(value -> Math.pow(value.x - (double)finalCurrentX, 2.0) + Math.pow(value.y - (double)finalCurrentY, 2.0) == minDist).collect(Collectors.toList()).get(0);
        this.display_.setViewOffset(newPoint.x, newPoint.y);
    }

    public void pan(int dx, int dy) {
        this.display_.pan(dx, dy);
        if (this.getBounds() == null) {
            this.moveViewToVisibleArea();
            this.display_.update();
        }
    }

    public void zoom(double factor, Point mouseLocation) {
        this.display_.zoom(factor, mouseLocation);
        if (this.getBounds() == null) {
            this.moveViewToVisibleArea();
            this.display_.update();
        }
    }

    private void createDisplay() {
        try {
            this.display_ = new NDViewer((NDViewerDataSource)this, (NDViewerAcqInterface)this.acq_, this.summaryMetadata_, AcqEngMetadata.getPixelSizeUm((JSONObject)this.summaryMetadata_), AcqEngMetadata.isRGB((JSONObject)this.summaryMetadata_));
            this.display_.setWindowTitle(this.getUniqueAcqName() + (this.acq_ != null ? (this.acq_.isFinished() ? " (Finished)" : " (Running)") : " (Loaded)"));
            this.display_.setReadTimeMetadataFunction(tags -> AcqEngMetadata.getElapsedTimeMs((JSONObject)tags));
            this.display_.setReadZMetadataFunction(tags -> AcqEngMetadata.getStageZIntended((JSONObject)tags));
            this.mouseListener_ = this.createMouseListener();
            this.overlayer_ = this.createOverlayer();
            this.display_.setOverlayerPlugin(this.overlayer_);
            this.exploreControlsPanel_ = new ExploreControlsPanel(this.acq_, this.overlayer_, this.channels_, this.acq_.getZAxes());
            this.display_.addControlPanel((ControlsPanelInterface)this.exploreControlsPanel_);
            this.display_.setCustomCanvasMouseListener((CanvasMouseListenerInterface)this.mouseListener_);
            this.display_.addSetImageHook((Consumer)new Consumer<HashMap<String, Object>>(){

                @Override
                public void accept(HashMap<String, Object> axes) {
                    for (String name : ExploreAcqUIAndStorage.this.acq_.getZAxes().keySet()) {
                        if (!axes.containsKey(name)) continue;
                        Integer i = (Integer)axes.get(name);
                        ExploreAcqUIAndStorage.this.exploreControlsPanel_.updateGUIToReflectHardwareZPosition(name, i);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger_.accept("Couldn't create display succesfully");
        }
    }

    protected OverlayerPlugin createOverlayer() {
        return new ExploreOverlayer((NDViewerAPI)this.display_, this.mouseListener_, this.acq_);
    }

    protected ExploreMouseListener createMouseListener() {
        return new ExploreMouseListener(this.acq_, this.display_, this.logger_);
    }

    public void putImage(final TaggedImage taggedImg) {
        boolean newChannel;
        String channelName = (String)AcqEngMetadata.getAxes((JSONObject)taggedImg.tags).get("channel");
        boolean bl = newChannel = !this.channelNames_.contains(channelName);
        if (newChannel) {
            this.channelNames_.add(channelName);
        }
        HashMap axes = AcqEngMetadata.getAxes((JSONObject)taggedImg.tags);
        final Future added = this.storage_.putImageMultiRes(taggedImg.pix, taggedImg.tags, axes, AcqEngMetadata.isRGB((JSONObject)taggedImg.tags), AcqEngMetadata.getBitDepth((JSONObject)taggedImg.tags), AcqEngMetadata.getHeight((JSONObject)taggedImg.tags), AcqEngMetadata.getWidth((JSONObject)taggedImg.tags));
        if (this.showDisplay_) {
            this.displayCommunicationExecutor_.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        added.get();
                        HashMap axes = AcqEngMetadata.getAxes((JSONObject)taggedImg.tags);
                        axes.remove("row");
                        axes.remove("column");
                        ExploreAcqUIAndStorage.this.display_.newImageArrived(axes);
                        for (Consumer displayHook : ExploreAcqUIAndStorage.this.displayUpdateOnImageHooks_) {
                            displayHook.accept(axes);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    public void finish() {
        if (!this.storage_.isFinished()) {
            JSONObject displaySettings = this.display_.getDisplaySettingsJSON();
            this.storage_.setDisplaySettings(displaySettings);
            this.storage_.finishedWriting();
        }
        this.display_.setWindowTitle(this.getUniqueAcqName() + " (Finished)");
        this.displayCommunicationExecutor_.shutdown();
        this.displayCommunicationExecutor_ = null;
    }

    public boolean isFinished() {
        return this.storage_.isFinished();
    }

    public String getDiskLocation() {
        return this.storage_.getDiskLocation();
    }

    public JSONObject getDisplayJSON() {
        try {
            return this.storage_.getDisplaySettings() == null ? null : new JSONObject(this.storage_.getDisplaySettings().toString());
        }
        catch (JSONException ex) {
            throw new RuntimeException("THis shouldnt happen");
        }
    }

    public void close() {
        if (this.storage_.isFinished()) {
            this.storage_.close();
            this.storage_ = null;
            this.displayUpdateOnImageHooks_ = null;
            this.mouseListener_ = null;
            this.overlayer_ = null;
            this.display_ = null;
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExploreAcqUIAndStorage.this.close();
                }
            });
        }
    }

    public int getImageBitDepth(HashMap<String, Object> axesPositions) {
        block1: {
            axesPositions = new HashMap<String, Object>(axesPositions);
            Iterator iterator = this.storage_.getAxesSet().iterator();
            if (!iterator.hasNext()) break block1;
            HashMap storedAxesPosition = (HashMap)iterator.next();
            for (String axis : axesPositions.keySet()) {
                if (storedAxesPosition.containsKey(axis) && axesPositions.containsKey(axis)) continue;
            }
            axesPositions = storedAxesPosition;
        }
        return this.storage_.getEssentialImageMetadata(axesPositions).bitDepth;
    }

    public JSONObject getSummaryMD() {
        if (this.storage_ == null) {
            this.logger_.accept("imageStorage_ is null in getSummaryMetadata");
            return null;
        }
        try {
            return new JSONObject(this.storage_.getSummaryMetadata().toString());
        }
        catch (JSONException ex) {
            throw new RuntimeException("This shouldnt happen");
        }
    }

    public int[] getBounds() {
        return null;
    }

    public TaggedImage getImageForDisplay(HashMap<String, Object> axes, int resolutionindex, double xOffset, double yOffset, int imageWidth, int imageHeight) {
        return this.storage_.getDisplayImage(axes, resolutionindex, (int)xOffset, (int)yOffset, imageWidth, imageHeight);
    }

    public Set<HashMap<String, Object>> getImageKeys() {
        return this.storage_.getAxesSet().stream().map(new Function<HashMap<String, Object>, HashMap<String, Object>>(){

            @Override
            public HashMap<String, Object> apply(HashMap<String, Object> axes) {
                HashMap<String, Object> copy = new HashMap<String, Object>(axes);
                copy.remove("row");
                copy.remove("column");
                return copy;
            }
        }).collect(Collectors.toSet());
    }

    public boolean anythingAcquired() {
        return this.storage_ == null || !this.storage_.getAxesSet().isEmpty();
    }

    public String getName() {
        return this.name_;
    }

    public String getDir() {
        return this.dir_;
    }

    public String getUniqueAcqName() {
        if (this.loadedData_) {
            return this.dir_;
        }
        File file = new File(this.storage_.getDiskLocation());
        String simpleFileName = file.getName();
        return simpleFileName;
    }

    public int getMaxResolutionIndex() {
        return this.storage_.getNumResLevels() - 1;
    }

    public Set<Point> getTileIndicesWithDataAt(String zName, int zIndex) {
        return this.storage_.getTileIndicesWithDataAt(zName, zIndex);
    }

    public Point2D.Double getStageCoordinateOfViewCenter() {
        return this.acq_.getPixelStageTranslator().getStageCoordsFromPixelCoords((long)(this.display_.getViewOffset().x + this.display_.getFullResSourceDataSize().x / 2.0), (long)(this.display_.getViewOffset().y + this.display_.getFullResSourceDataSize().y / 2.0));
    }

    public void initializeViewerToLoaded(HashMap<String, Object> axisMins, HashMap<String, Object> axisMaxs) {
        LinkedList<String> channelNames = new LinkedList<String>();
        for (HashMap axes : this.storage_.getAxesSet()) {
            if (!axes.containsKey("channel") || channelNames.contains(axes.get("channel"))) continue;
            channelNames.add((String)axes.get("channel"));
        }
        this.display_.initializeViewerToLoaded(channelNames, this.storage_.getDisplaySettings(), axisMins, axisMaxs);
    }
}

