/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.explore;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import mmcorej.CMMCore;
import mmcorej.StrVector;
import org.micromanager.acqj.internal.Engine;
import org.micromanager.acqj.util.ChannelSetting;

public class ChannelGroupSettings {
    private static final String PREF_EXPOSURE = "EXPOSURE";
    private static final String PREF_COLOR = "COLOR";
    private static final String PREF_USE = "USE";
    private static final String PREF_OFFSET = "OFFSET";
    private static final Color[] DEFAULT_COLORS = new Color[]{new Color(160, 32, 240), Color.blue, Color.green, Color.yellow, Color.red, Color.pink};
    protected ArrayList<ChannelSetting> channels_;
    private static CMMCore core_;
    protected String group_;

    public ChannelGroupSettings(String channelGroup) {
        this.group_ = channelGroup;
        core_ = Engine.getCore();
        this.updateChannelGroup(channelGroup);
    }

    public List<String> getChannelNames() {
        LinkedList<String> names = new LinkedList<String>();
        for (ChannelSetting c : this.channels_) {
            names.add(c.config_);
        }
        return names;
    }

    public ChannelSetting getChannelSetting(String name) {
        if (name == null) {
            return this.channels_.get(0);
        }
        for (ChannelSetting c : this.channels_) {
            if (!c.config_.equals(name)) continue;
            return c;
        }
        throw new RuntimeException("channel with name " + name + " not found");
    }

    public void updateChannelGroup(String channelGroup) {
        this.group_ = channelGroup;
        if (this.channels_ != null && !this.channels_.isEmpty() && this.channels_.get((int)0).group_.equals(channelGroup)) {
            return;
        }
        int numCamChannels = (int)core_.getNumberOfCameraChannels();
        this.channels_ = new ArrayList();
        if (numCamChannels <= 1) {
            for (String config : ChannelGroupSettings.getChannelConfigs(channelGroup)) {
                this.channels_.add(new ChannelSetting(channelGroup, channelGroup == null || channelGroup.equals("") ? null : config, 1.0, 0.0));
            }
        }
        for (ChannelSetting c : this.channels_) {
            this.setValuesFromPrefs(c);
        }
    }

    public void setUseOnAll(boolean use) {
        for (ChannelSetting c : this.channels_) {
            c.use_ = use;
        }
    }

    public void synchronizeExposures() {
        double e = this.channels_.get((int)0).exposure_;
        for (ChannelSetting c : this.channels_) {
            c.exposure_ = e;
        }
    }

    public int getNumChannels() {
        return this.channels_.size();
    }

    public ChannelSetting getChannelListSetting(int i) {
        return this.channels_.get(i);
    }

    private static String[] getChannelConfigs(String channelGroup) {
        if (channelGroup == null || channelGroup.equals("")) {
            return new String[0];
        }
        StrVector configs = core_.getAvailableConfigs(channelGroup);
        String[] names = new String[(int)configs.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = configs.get(i);
        }
        return names;
    }

    public String getConfigName(int index) {
        return this.channels_.get((int)index).config_;
    }

    public String getChannelGroup() {
        return this.channels_.isEmpty() ? null : this.channels_.get((int)0).group_;
    }

    public String nextActiveChannel(String channelName) {
        if (channelName == null) {
            for (ChannelSetting c : this.channels_) {
                if (!c.use_) continue;
                return c.config_;
            }
            return null;
        }
        ChannelSetting current = this.getChannelSetting(channelName);
        int currentInd = this.channels_.indexOf(current);
        for (int i = currentInd + 1; i < this.channels_.size(); ++i) {
            if (!this.channels_.get((int)i).use_) continue;
            return this.channels_.get((int)i).config_;
        }
        return null;
    }

    private void setValuesFromPrefs(ChannelSetting setting) {
        String prefix = "CHANNELGROUP" + setting.group_ + "CHANNELNAME" + setting.config_;
        Preferences prefs = Preferences.systemNodeForPackage(ChannelGroupSettings.class);
        try {
            setting.exposure_ = prefs.getDouble(prefix + PREF_EXPOSURE, Engine.getCore().getExposure());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        setting.offset_ = prefs.getDouble(prefix + PREF_OFFSET, 0.0);
        setting.use_ = prefs.getBoolean(prefix + PREF_USE, true);
    }

    public void storeValuesInPrefs() {
        Preferences prefs = Preferences.systemNodeForPackage(ChannelGroupSettings.class);
        for (ChannelSetting setting : this.channels_) {
            String prefix = "CHANNELGROUP" + setting.group_ + "CHANNELNAME" + setting.config_;
            prefs.putBoolean(prefix + PREF_USE, setting.use_);
            prefs.putDouble(prefix + PREF_EXPOSURE, setting.exposure_);
            prefs.putDouble(prefix + PREF_OFFSET, setting.offset_);
        }
    }
}

