package org.micromanager.explore.gui;

import javax.swing.*;
import javax.swing.table.DefaultTableCellRenderer;

import net.miginfocom.swing.MigLayout;
import org.micromanager.explore.ChannelGroupSettings;
import org.micromanager.acqj.internal.ZAxis;
import org.micromanager.explore.ExploreAcquisition;
import org.micromanager.ndviewer.api.ControlsPanelInterface;
import org.micromanager.ndviewer.api.OverlayerPlugin;

import java.awt.*;
import java.util.HashMap;

/**
 *
 * @author henrypinkard
 */
public class ExploreControlsPanel extends javax.swing.JPanel implements ControlsPanelInterface {

   private ChannelGroupSettings channels_;
   private ExploreAcquisition acquisition_;
   private HashMap<String, ExploreZSliders> zSlidersList_ = new HashMap<>();
   private OverlayerPlugin overlayer_;

   /**
    * Creates new form ExploreChannelsPanel.
    */
   public ExploreControlsPanel(ExploreAcquisition acquisition, OverlayerPlugin overlayer,
                               ChannelGroupSettings channels, HashMap<String, ZAxis> zAxes) {
      channels_ = channels;
      overlayer_ = overlayer;
      acquisition_ = acquisition;
      try {
         for (String name : zAxes.keySet()) {
            zSlidersList_.put(name, new ExploreZSliders(acquisition, zAxes.get(name)));
         }
      } catch (Exception e) {
         throw new RuntimeException(e);
      }
      initComponents();


      //left justified editor
      JTextField tf = new JTextField();
      tf.setHorizontalAlignment(SwingConstants.LEFT);
      DefaultCellEditor ed = new DefaultCellEditor(tf);
      channelsTable_.getColumnModel().getColumn(2).setCellEditor(ed);
      //and renderer
      DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
      renderer.setHorizontalAlignment(SwingConstants.LEFT); // left justify
      channelsTable_.getColumnModel().getColumn(2).setCellRenderer(renderer);
      channelsTable_.getColumnModel().getColumn(0).setMaxWidth(30); //Acitve checkbox column
      if (channels_ == null) {
         channelsScrollPane_.setVisible(false);
         selectUseAllButton_.setVisible(false);
         syncExposuresButton_.setVisible(false);
      }
   }
   
   public void updateGUIToReflectHardwareZPosition(String name, Integer zIndex) {
      // iterate through zsliders and update the one with the given name
      for (String slidersName : zSlidersList_.keySet()) {
         if (slidersName.equals(name)) {
            zSlidersList_.get(name).updateZDrivelocation(zIndex);
         }
      }
   }

   @Override
   public void selected() {
//      overlayer_.setActive(true);
   }

   @Override
   public void deselected() {
//      overlayer_.setActive(false);
   }

   @Override
   public String getTitle() {
      return "Explore controls";
   }

   @Override
   public void close() {
      acquisition_ = null;
      channelsTable_ = null;
      for (ExploreZSliders zSliders : zSlidersList_.values()) {
         zSliders.onDisplayClose();
      }
      zSlidersList_ = null;
   }



   /**
    * This method is called from within the constructor to initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is always
    * regenerated by the Form Editor.
    */
   @SuppressWarnings("unchecked")
   // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
   private void initComponents() {

      acquireAtCurrentButton_ = new javax.swing.JButton();
      selectUseAllButton_ = new javax.swing.JButton();
      syncExposuresButton_ = new javax.swing.JButton();
      channelsScrollPane_ = new javax.swing.JScrollPane();
      channelsTable_ = new javax.swing.JTable();


      acquireAtCurrentButton_.setText("Acquire at current position");
      acquireAtCurrentButton_.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            acquireAtCurrentButtonActionPerformed(evt);
         }
      });

      selectUseAllButton_.setText("Select all");
      selectUseAllButton_.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            selectUseAllButtonActionPerformed(evt);
         }
      });

      syncExposuresButton_.setText("Sync exposures");
      syncExposuresButton_.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            syncExposuresButtonActionPerformed(evt);
         }
      });


      channelsTable_.setModel(new SimpleChannelTableModel(channels_));
      channelsScrollPane_.setViewportView(channelsTable_);


      this.setLayout(new MigLayout());
      setMaximumSize(new Dimension(getPreferredSize().width, getPreferredSize().height));

      this.add(acquireAtCurrentButton_, "wrap");

      JPanel sliderPanel = new JPanel(new MigLayout());
      for (ExploreZSliders zSliders : zSlidersList_.values()) {
         sliderPanel.add(zSliders, "grow, wrap");
      }

      this.add(sliderPanel, "growx, wrap");
      sliderPanel.setPreferredSize(new Dimension(650,
              sliderPanel.getPreferredSize().height));

      JPanel buttonPanel = new JPanel(new FlowLayout());
      buttonPanel.add(selectUseAllButton_);
      buttonPanel.add(syncExposuresButton_);
      this.add(buttonPanel, "wrap");
      this.add(channelsScrollPane_, "growx" );


   }

   private void syncExposuresButtonActionPerformed(java.awt.event.ActionEvent evt) {
      ((SimpleChannelTableModel) channelsTable_.getModel()).synchronizeExposures();
      ((SimpleChannelTableModel) channelsTable_.getModel()).fireTableDataChanged();
   } //GEN-LAST:event_syncExposuresButton_ActionPerformed

   private void selectUseAllButtonActionPerformed(java.awt.event.ActionEvent evt) {
      ((SimpleChannelTableModel) channelsTable_.getModel()).selectAllChannels();
      ((SimpleChannelTableModel) channelsTable_.getModel()).fireTableDataChanged();
   } //GEN-LAST:event_selectUseAllButton_ActionPerformed

   private void acquireAtCurrentButtonActionPerformed(java.awt.event.ActionEvent evt) {
      try {
         acquisition_.acquireTileAtCurrentLocation();
      } catch (Exception e) {
         e.printStackTrace();
         JOptionPane.showMessageDialog(this, e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
      }
   } //GEN-LAST:event_acquireAtCurrentButton_ActionPerformed


   // Variables declaration - do not modify//GEN-BEGIN:variables
   private javax.swing.JButton acquireAtCurrentButton_;
   private javax.swing.JTable channelsTable_;
   private javax.swing.JPanel jPanel1;
   private javax.swing.JScrollPane channelsScrollPane_;
   private javax.swing.JButton selectUseAllButton_;
   private javax.swing.JButton syncExposuresButton_;
   private javax.swing.JPanel zPanelPanel_;
   // End of variables declaration//GEN-END:variables


}
