/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.zookeeper;

import jakarta.annotation.Resource;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.miaixz.bus.starter.zookeeper.ZookeeperProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={ZookeeperProperties.class})
public class ZookeeperConfiguration {
    @Resource
    ZookeeperProperties properties;

    @Bean(initMethod="start", destroyMethod="close")
    @ConditionalOnMissingBean(value={CuratorFramework.class})
    public CuratorFramework zkClient() {
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(this.properties.getBaseSleepTimeMs(), this.properties.getMaxRetries());
        return CuratorFrameworkFactory.builder().connectString(this.properties.getConnectString()).namespace(this.properties.getNamespace()).sessionTimeoutMs(this.properties.getSessionTimeoutMs()).connectionTimeoutMs(this.properties.getConnectionTimeoutMs()).retryPolicy((RetryPolicy)retryPolicy).build();
    }
}

