/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.wrapper;

import jakarta.annotation.Resource;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.spring.web.WebMvcConfigurer;
import org.miaixz.bus.starter.wrapper.CacheRequestWrapper;
import org.miaixz.bus.starter.wrapper.CacheResponseWrapper;
import org.miaixz.bus.starter.wrapper.WrapperProperties;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Controller;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@EnableConfigurationProperties(value={WrapperProperties.class})
public class WrapperConfiguration
implements WebMvcRegistrations {
    @Resource
    WrapperProperties properties;

    public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
        return new RequestMappingHandler();
    }

    @Bean(value={"registrationBodyCacheFilter"})
    public FilterRegistrationBean registrationBodyCacheFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setEnabled(this.properties.isEnabled());
        registrationBean.setOrder(this.properties.getOrder());
        registrationBean.setFilter((Filter)new BodyCacheFilter(this));
        if (!StringKit.isEmpty((CharSequence)this.properties.getName())) {
            registrationBean.setName(this.properties.getName());
        }
        if (MapKit.isNotEmpty(this.properties.getInitParameters())) {
            registrationBean.setInitParameters(this.properties.getInitParameters());
        }
        if (ObjectKit.isNotEmpty(this.properties.getServletRegistrationBeans())) {
            registrationBean.setServletRegistrationBeans(this.properties.getServletRegistrationBeans());
        }
        if (!CollKit.isEmpty(this.properties.getServletNames())) {
            registrationBean.setServletNames(this.properties.getServletNames());
        }
        return registrationBean;
    }

    @Bean(value={"supportWebMvcConfigurer"})
    public org.springframework.web.servlet.config.annotation.WebMvcConfigurer supportWebMvcConfigurer() {
        return new WebMvcConfigurer(this.properties.getAutoType());
    }

    class RequestMappingHandler
    extends RequestMappingHandlerMapping {
        RequestMappingHandler() {
        }

        protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
            RequestMappingInfo requestMappingInfo = super.getMappingForMethod(method, handlerType);
            if (null != requestMappingInfo && (handlerType.isAnnotationPresent(Controller.class) || handlerType.isAnnotationPresent(RestController.class)) && ObjectKit.isNotEmpty((Object)WrapperConfiguration.this.properties.getBasePackages())) {
                AntPathMatcher antPathMatcher = new AntPathMatcher(".");
                for (String basePackage : WrapperConfiguration.this.properties.getBasePackages()) {
                    String packName = handlerType.getPackageName();
                    if (!antPathMatcher.matchStart(packName, basePackage) && !antPathMatcher.matchStart(basePackage, packName)) continue;
                    String[] arrays = StringKit.splitToArray((CharSequence)basePackage, (CharSequence)".");
                    String prefix = StringKit.splitToArray((CharSequence)packName, (CharSequence)arrays[arrays.length - 1])[1].replace('.', '/');
                    Logger.debug((String)("Create a URL request mapping '" + prefix + Arrays.toString(requestMappingInfo.getPathPatternsCondition().getPatterns().toArray()) + "' for " + packName + "." + handlerType.getSimpleName()), (Object[])new Object[0]);
                    requestMappingInfo = RequestMappingInfo.paths((String[])new String[]{prefix}).options(this.getBuilderConfiguration()).build().combine(requestMappingInfo);
                }
            }
            return requestMappingInfo;
        }
    }

    class BodyCacheFilter
    extends OncePerRequestFilter {
        BodyCacheFilter(WrapperConfiguration this$0) {
        }

        protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
            String method = request.getMethod();
            if (("POST".equals(method) || "PATCH".equals(method) || "PUT".equals(method)) && !(request instanceof CacheRequestWrapper)) {
                request = new CacheRequestWrapper((HttpServletRequest)request);
            }
            if (!(response instanceof CacheResponseWrapper)) {
                response = new CacheResponseWrapper((HttpServletResponse)response);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

