/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.wrapper;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.miaixz.bus.core.lang.ansi.Ansi4BitColor;
import org.miaixz.bus.core.lang.ansi.AnsiEncoder;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.NetKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.starter.wrapper.CacheRequestWrapper;
import org.miaixz.bus.starter.wrapper.CacheResponseWrapper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class GenieWrapperHandler
implements HandlerInterceptor {
    public static String getClientIP(HttpServletRequest request, String ... otherHeaderNames) {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayKit.isNotEmpty((Object[])otherHeaderNames)) {
            headers = (String[])ArrayKit.addAll((Object[][])new String[][]{headers, otherHeaderNames});
        }
        return GenieWrapperHandler.getClientIPByHeader(request, headers);
    }

    public static String getClientIPByHeader(HttpServletRequest request, String ... headerNames) {
        String ip;
        for (String header : headerNames) {
            ip = request.getHeader(header);
            if (NetKit.isUnknown((String)ip)) continue;
            return NetKit.getMultistageReverseProxyIp((String)ip);
        }
        ip = request.getRemoteAddr();
        return NetKit.getMultistageReverseProxyIp((String)ip);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String method = request.getMethod().toUpperCase();
        this.requestInfo(request, method);
        if (("GET".equals(method) || "POST".equals(method) || "PATCH".equals(method) || "PUT".equals(method)) && request instanceof CacheRequestWrapper) {
            CacheRequestWrapper cacheRequestWrapper = (CacheRequestWrapper)request;
            Logger.info((String)"==> {}", (Object[])new Object[]{new String(cacheRequestWrapper.getBody())});
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        String method = request.getMethod();
        if (("POST".equals(method) || "PATCH".equals(method) || "PUT".equals(method)) && response instanceof CacheResponseWrapper) {
            CacheResponseWrapper cacheResponseWrapper = (CacheResponseWrapper)response;
            Logger.info((String)"<== {}", (Object[])new Object[]{new String(cacheResponseWrapper.getBody()).length()});
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    private void requestInfo(HttpServletRequest request, String method) {
        String requestMethod = AnsiEncoder.encode((Object[])new Object[]{Ansi4BitColor.GREEN, " %s ", method});
        switch (method) {
            case "ALL": {
                requestMethod = AnsiEncoder.encode((Object[])new Object[]{Ansi4BitColor.WHITE, " %s ", method});
                break;
            }
            case "POST": {
                requestMethod = AnsiEncoder.encode((Object[])new Object[]{Ansi4BitColor.MAGENTA, " %s ", method});
                break;
            }
            case "DELETE": {
                requestMethod = AnsiEncoder.encode((Object[])new Object[]{Ansi4BitColor.BLUE, " %s ", method});
                break;
            }
            case "PUT": {
                requestMethod = AnsiEncoder.encode((Object[])new Object[]{Ansi4BitColor.RED, " %s ", method});
                break;
            }
            case "OPTIONS": {
                requestMethod = AnsiEncoder.encode((Object[])new Object[]{Ansi4BitColor.YELLOW, " %s ", method});
                break;
            }
            case "BEFORE": {
                requestMethod = AnsiEncoder.encode((Object[])new Object[]{Ansi4BitColor.BLACK, " %s ", method});
                break;
            }
            case "AFTER": {
                requestMethod = AnsiEncoder.encode((Object[])new Object[]{Ansi4BitColor.CYAN, " %s ", method});
            }
        }
        Logger.info((String)"{} {} {}", (Object[])new Object[]{"==>", GenieWrapperHandler.getClientIP(request, new String[0]), requestMethod, request.getRequestURL().toString()});
    }
}

