/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.validate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.validate.Builder;
import org.miaixz.bus.validate.Context;
import org.springframework.core.DefaultParameterNameDiscoverer;

public class AutoValidateAdvice {
    public Object access(JoinPoint joinPoint) throws Throwable {
        int i;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Object[] arguments = joinPoint.getArgs();
        if (method.getDeclaringClass().isInterface()) {
            try {
                method = joinPoint.getTarget().getClass().getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                Logger.info((String)"Cannot find the specified method in the implementation class, skipping validation, method: {}", (Object[])new Object[]{method.getName()});
                return joinPoint.getArgs();
            }
        }
        Annotation[][] annotations = method.getParameterAnnotations();
        String[] names = new DefaultParameterNameDiscoverer().getParameterNames(method);
        if (names == null || names.length == 0) {
            names = new String[arguments.length];
            for (i = 0; i < names.length; ++i) {
                names[i] = "" + i;
            }
        }
        for (i = 0; i < arguments.length; ++i) {
            Builder.on((Object)arguments[i], (Annotation[])annotations[i], (Context)Context.newInstance(), (String)names[i]);
        }
        return this.proceed(joinPoint, arguments);
    }

    private Object proceed(JoinPoint joinPoint, Object[] arguments) throws Throwable {
        if (joinPoint instanceof ProceedingJoinPoint) {
            return ((ProceedingJoinPoint)joinPoint).proceed(arguments);
        }
        return arguments;
    }
}

