/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.storage;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.cache.metric.ExtendCache;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.starter.storage.StorageProperties;
import org.miaixz.bus.storage.Context;
import org.miaixz.bus.storage.Provider;
import org.miaixz.bus.storage.Registry;
import org.miaixz.bus.storage.cache.StorageCache;
import org.miaixz.bus.storage.magic.ErrorCode;
import org.miaixz.bus.storage.metric.AliYunOssProvider;
import org.miaixz.bus.storage.metric.AmazonS3Provider;
import org.miaixz.bus.storage.metric.BaiduBosProvider;
import org.miaixz.bus.storage.metric.FtpFileProvider;
import org.miaixz.bus.storage.metric.GitlabFileProvider;
import org.miaixz.bus.storage.metric.GoogleCsProvider;
import org.miaixz.bus.storage.metric.HuaweiObsProvider;
import org.miaixz.bus.storage.metric.JdOssProvider;
import org.miaixz.bus.storage.metric.LocalFileProvider;
import org.miaixz.bus.storage.metric.MinioOssProvider;
import org.miaixz.bus.storage.metric.QiniuOssProvider;
import org.miaixz.bus.storage.metric.SftpFileProvider;
import org.miaixz.bus.storage.metric.TencentCosProvider;
import org.miaixz.bus.storage.metric.UpyunOssProvider;
import org.miaixz.bus.storage.metric.WebDavProvider;

public class StorageProviderService {
    private static Map<Registry, Context> CACHE = new ConcurrentHashMap<Registry, Context>();
    public StorageProperties properties;
    public ExtendCache extendCache;

    public StorageProviderService(StorageProperties properties) {
        this(properties, (ExtendCache)StorageCache.INSTANCE);
    }

    public StorageProviderService(StorageProperties properties, ExtendCache extendCache) {
        this.properties = properties;
        this.extendCache = extendCache;
    }

    public static void register(Registry type, Context context) {
        if (CACHE.containsKey(type)) {
            throw new InternalException("\u91cd\u590d\u6ce8\u518c\u540c\u540d\u79f0\u7684\u7ec4\u4ef6\uff1a" + type.name());
        }
        CACHE.putIfAbsent(type, context);
    }

    public Provider require(Registry type) {
        Context context = CACHE.get(type);
        if (ObjectKit.isEmpty((Object)context)) {
            context = this.properties.getType().get(type);
        }
        if (Registry.ALIYUN.equals((Object)type)) {
            return new AliYunOssProvider(context);
        }
        if (Registry.AMAZON.equals((Object)type)) {
            return new AmazonS3Provider(context);
        }
        if (Registry.BAIDU.equals((Object)type)) {
            return new BaiduBosProvider(context);
        }
        if (Registry.FTP.equals((Object)type)) {
            return new FtpFileProvider(context);
        }
        if (Registry.GITLAB.equals((Object)type)) {
            return new GitlabFileProvider(context);
        }
        if (Registry.GOOGLE.equals((Object)type)) {
            return new GoogleCsProvider(context);
        }
        if (Registry.HUAWEI.equals((Object)type)) {
            return new HuaweiObsProvider(context);
        }
        if (Registry.JD.equals((Object)type)) {
            return new JdOssProvider(context);
        }
        if (Registry.LOCAL.equals((Object)type)) {
            return new LocalFileProvider(context);
        }
        if (Registry.MINIO.equals((Object)type)) {
            return new MinioOssProvider(context);
        }
        if (Registry.QINIU.equals((Object)type)) {
            return new QiniuOssProvider(context);
        }
        if (Registry.TENCENT.equals((Object)type)) {
            return new TencentCosProvider(context);
        }
        if (Registry.SFTP.equals((Object)type)) {
            return new SftpFileProvider(context);
        }
        if (Registry.UPYUN.equals((Object)type)) {
            return new UpyunOssProvider(context);
        }
        if (Registry.WEBDAV.equals((Object)type)) {
            return new WebDavProvider(context);
        }
        throw new InternalException(ErrorCode._100508.getValue());
    }
}

