/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.storage;

import jakarta.annotation.Resource;
import org.miaixz.bus.cache.metric.ExtendCache;
import org.miaixz.bus.starter.storage.StorageProperties;
import org.miaixz.bus.starter.storage.StorageProviderService;
import org.miaixz.bus.storage.cache.StorageCache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={StorageProperties.class})
public class StorageConfiguration {
    @Resource
    StorageProperties properties;

    @Bean
    public StorageProviderService storageProviderFactory(ExtendCache extendCache) {
        return new StorageProviderService(this.properties, extendCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={ExtendCache.class})
    @ConditionalOnProperty(name={"bus.storage.cache.type"}, havingValue="default", matchIfMissing=true)
    public ExtendCache storageCache() {
        return StorageCache.INSTANCE;
    }
}

