/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.pay;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.cache.metric.ExtendCache;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.pay.Complex;
import org.miaixz.bus.pay.Context;
import org.miaixz.bus.pay.Provider;
import org.miaixz.bus.pay.Registry;
import org.miaixz.bus.pay.magic.ErrorCode;
import org.miaixz.bus.pay.metric.alipay.AliPayProvider;
import org.miaixz.bus.pay.metric.jdpay.JdPayProvider;
import org.miaixz.bus.pay.metric.paypal.PaypalProvider;
import org.miaixz.bus.pay.metric.tenpay.TenpayProvider;
import org.miaixz.bus.pay.metric.unionpay.UnionPayProvider;
import org.miaixz.bus.pay.metric.wechat.WechatPayProvider;
import org.miaixz.bus.starter.pay.PayProperties;

public class PayProviderService {
    private static Map<Registry, Context> CACHE = new ConcurrentHashMap<Registry, Context>();
    public PayProperties properties;
    public ExtendCache cache;
    public Complex complex;

    public PayProviderService(PayProperties properties) {
        this.properties = properties;
    }

    public PayProviderService(PayProperties properties, Complex complex) {
        this.properties = properties;
        this.complex = complex;
    }

    public PayProviderService(PayProperties properties, Complex complex, ExtendCache cache) {
        this.properties = properties;
        this.complex = complex;
        this.cache = cache;
    }

    public static void register(Registry registry, Context context) {
        if (CACHE.containsKey(registry)) {
            throw new InternalException("\u91cd\u590d\u6ce8\u518c\u540c\u540d\u79f0\u7684\u7ec4\u4ef6\uff1a" + registry.name());
        }
        CACHE.putIfAbsent(registry, context);
    }

    public Provider require(Registry registry) {
        Context context = CACHE.get(registry);
        if (ObjectKit.isEmpty((Object)context)) {
            context = this.properties.getType().get(registry);
        }
        if (Registry.ALIPAY.equals((Object)registry)) {
            return new AliPayProvider(context, this.complex, this.cache);
        }
        if (Registry.JDPAY.equals((Object)registry)) {
            return new JdPayProvider(context, this.complex, this.cache);
        }
        if (Registry.PAYPAL.equals((Object)registry)) {
            return new PaypalProvider(context, this.complex, this.cache);
        }
        if (Registry.TENPAY.equals((Object)registry)) {
            return new TenpayProvider(context, this.complex, this.cache);
        }
        if (Registry.UNIONPAY.equals((Object)registry)) {
            return new UnionPayProvider(context, this.complex, this.cache);
        }
        if (Registry.WECHAT.equals((Object)registry)) {
            return new WechatPayProvider(context, this.complex, this.cache);
        }
        throw new InternalException(ErrorCode._100508.getValue());
    }
}

