/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.pay;

import jakarta.annotation.Resource;
import org.miaixz.bus.cache.metric.ExtendCache;
import org.miaixz.bus.pay.Complex;
import org.miaixz.bus.pay.cache.PayCache;
import org.miaixz.bus.starter.pay.PayProperties;
import org.miaixz.bus.starter.pay.PayProviderService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={PayProperties.class})
public class PayConfiguration {
    @Resource
    PayProperties properties;

    @Bean
    public PayProviderService payProviderFactory(Complex complex, ExtendCache cache) {
        return new PayProviderService(this.properties, complex, cache);
    }

    @Bean
    @ConditionalOnMissingBean(value={ExtendCache.class})
    @ConditionalOnProperty(name={"bus.pay.cache.type"}, havingValue="default", matchIfMissing=true)
    public ExtendCache cache() {
        return PayCache.INSTANCE;
    }
}

