/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.notify;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.notify.Context;
import org.miaixz.bus.notify.Provider;
import org.miaixz.bus.notify.Registry;
import org.miaixz.bus.notify.magic.ErrorCode;
import org.miaixz.bus.notify.metric.aliyun.AliyunEmailProvider;
import org.miaixz.bus.notify.metric.aliyun.AliyunSmsProvider;
import org.miaixz.bus.notify.metric.aliyun.AliyunVmsProvider;
import org.miaixz.bus.notify.metric.baidu.BaiduSmsProvider;
import org.miaixz.bus.notify.metric.dingtalk.DingTalkProvider;
import org.miaixz.bus.notify.metric.generic.GenericEmailProvider;
import org.miaixz.bus.notify.metric.huawei.HuaweiSmsProvider;
import org.miaixz.bus.notify.metric.jdcloud.JdcloudSmsProvider;
import org.miaixz.bus.notify.metric.jpush.JpushSmsProvider;
import org.miaixz.bus.notify.metric.netease.NeteaseSmsProvider;
import org.miaixz.bus.notify.metric.qiniu.QiniuSmsProvider;
import org.miaixz.bus.notify.metric.tencent.TencentSmsProvider;
import org.miaixz.bus.notify.metric.upyun.UpyunSmsProvider;
import org.miaixz.bus.notify.metric.wechat.WechatCpProvider;
import org.miaixz.bus.notify.metric.wechat.WechatKfProvider;
import org.miaixz.bus.notify.metric.wechat.WechatMiniProvider;
import org.miaixz.bus.notify.metric.wechat.WechatMpProvider;
import org.miaixz.bus.notify.metric.yunpian.YunpianSmsProvider;
import org.miaixz.bus.starter.notify.NotifyProperties;

public class NotifyProviderService {
    private static Map<Registry, Context> CACHE = new ConcurrentHashMap<Registry, Context>();
    public NotifyProperties properties;

    public NotifyProviderService(NotifyProperties properties) {
        this.properties = properties;
    }

    public static void register(Registry registry, Context context) {
        if (CACHE.containsKey(registry)) {
            throw new InternalException("\u91cd\u590d\u6ce8\u518c\u540c\u540d\u79f0\u7684\u7ec4\u4ef6\uff1a" + registry.name());
        }
        CACHE.putIfAbsent(registry, context);
    }

    public Provider require(Registry registry) {
        Context context = CACHE.get(registry);
        if (ObjectKit.isEmpty((Object)context)) {
            context = this.properties.getType().get(registry);
        }
        if (Registry.ALIYUN_SMS.equals((Object)registry)) {
            return new AliyunSmsProvider(context);
        }
        if (Registry.ALIYUN_VMS.equals((Object)registry)) {
            return new AliyunVmsProvider(context);
        }
        if (Registry.ALIYUN_EDM.equals((Object)registry)) {
            return new AliyunEmailProvider(context);
        }
        if (Registry.BAIDU_SMS.equals((Object)registry)) {
            return new BaiduSmsProvider(context);
        }
        if (Registry.DINGTALK.equals((Object)registry)) {
            return new DingTalkProvider(context);
        }
        if (Registry.GENERIC_EDM.equals((Object)registry)) {
            return new GenericEmailProvider(context);
        }
        if (Registry.HUAWEI_SMS.equals((Object)registry)) {
            return new HuaweiSmsProvider(context);
        }
        if (Registry.JDCLOUD_SMS.equals((Object)registry)) {
            return new JdcloudSmsProvider(context);
        }
        if (Registry.JPUSH_SMS.equals((Object)registry)) {
            return new JpushSmsProvider(context);
        }
        if (Registry.NETEASE_SMS.equals((Object)registry)) {
            return new NeteaseSmsProvider(context);
        }
        if (Registry.QINIU_SMS.equals((Object)registry)) {
            return new QiniuSmsProvider(context);
        }
        if (Registry.TENCENT_SMS.equals((Object)registry)) {
            return new TencentSmsProvider(context);
        }
        if (Registry.UPYUN_SMS.equals((Object)registry)) {
            return new UpyunSmsProvider(context);
        }
        if (Registry.WECHAT_CP.equals((Object)registry)) {
            return new WechatCpProvider(context);
        }
        if (Registry.WECHAT_KF.equals((Object)registry)) {
            return new WechatKfProvider(context);
        }
        if (Registry.WECHAT_MINI.equals((Object)registry)) {
            return new WechatMiniProvider(context);
        }
        if (Registry.WECHAT_MP.equals((Object)registry)) {
            return new WechatMpProvider(context);
        }
        if (Registry.YUNPIAN_SMS.equals((Object)registry)) {
            return new YunpianSmsProvider(context);
        }
        throw new InternalException(ErrorCode._100508.getValue());
    }
}

