/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.mongo;

import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterType;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="bus.mongo")
public class MongoProperties {
    @NestedConfigurationProperty
    private Socket socket;
    @NestedConfigurationProperty
    private Socket heartbeatSocket;
    @NestedConfigurationProperty
    private Cluster cluster;
    @NestedConfigurationProperty
    private Server server;
    @NestedConfigurationProperty
    private Connection connectionPool;
    @NestedConfigurationProperty
    private Ssl ssl;

    @Generated
    public Socket getSocket() {
        return this.socket;
    }

    @Generated
    public Socket getHeartbeatSocket() {
        return this.heartbeatSocket;
    }

    @Generated
    public Cluster getCluster() {
        return this.cluster;
    }

    @Generated
    public Server getServer() {
        return this.server;
    }

    @Generated
    public Connection getConnectionPool() {
        return this.connectionPool;
    }

    @Generated
    public Ssl getSsl() {
        return this.ssl;
    }

    @Generated
    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    @Generated
    public void setHeartbeatSocket(Socket heartbeatSocket) {
        this.heartbeatSocket = heartbeatSocket;
    }

    @Generated
    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    @Generated
    public void setServer(Server server) {
        this.server = server;
    }

    @Generated
    public void setConnectionPool(Connection connectionPool) {
        this.connectionPool = connectionPool;
    }

    @Generated
    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public static class Socket {
        private long connectTimeoutMilliSeconds = 10000L;
        private long readTimeoutMilliSeconds = 10000L;
        private int receiveBufferSize;
        private int sendBufferSize;

        @Generated
        public Socket() {
        }

        @Generated
        public long getConnectTimeoutMilliSeconds() {
            return this.connectTimeoutMilliSeconds;
        }

        @Generated
        public long getReadTimeoutMilliSeconds() {
            return this.readTimeoutMilliSeconds;
        }

        @Generated
        public int getReceiveBufferSize() {
            return this.receiveBufferSize;
        }

        @Generated
        public int getSendBufferSize() {
            return this.sendBufferSize;
        }

        @Generated
        public void setConnectTimeoutMilliSeconds(long connectTimeoutMilliSeconds) {
            this.connectTimeoutMilliSeconds = connectTimeoutMilliSeconds;
        }

        @Generated
        public void setReadTimeoutMilliSeconds(long readTimeoutMilliSeconds) {
            this.readTimeoutMilliSeconds = readTimeoutMilliSeconds;
        }

        @Generated
        public void setReceiveBufferSize(int receiveBufferSize) {
            this.receiveBufferSize = receiveBufferSize;
        }

        @Generated
        public void setSendBufferSize(int sendBufferSize) {
            this.sendBufferSize = sendBufferSize;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Socket)) {
                return false;
            }
            Socket other = (Socket)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getConnectTimeoutMilliSeconds() != other.getConnectTimeoutMilliSeconds()) {
                return false;
            }
            if (this.getReadTimeoutMilliSeconds() != other.getReadTimeoutMilliSeconds()) {
                return false;
            }
            if (this.getReceiveBufferSize() != other.getReceiveBufferSize()) {
                return false;
            }
            return this.getSendBufferSize() == other.getSendBufferSize();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Socket;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $connectTimeoutMilliSeconds = this.getConnectTimeoutMilliSeconds();
            result = result * 59 + (int)($connectTimeoutMilliSeconds >>> 32 ^ $connectTimeoutMilliSeconds);
            long $readTimeoutMilliSeconds = this.getReadTimeoutMilliSeconds();
            result = result * 59 + (int)($readTimeoutMilliSeconds >>> 32 ^ $readTimeoutMilliSeconds);
            result = result * 59 + this.getReceiveBufferSize();
            result = result * 59 + this.getSendBufferSize();
            return result;
        }

        @Generated
        public String toString() {
            return "MongoProperties.Socket(connectTimeoutMilliSeconds=" + this.getConnectTimeoutMilliSeconds() + ", readTimeoutMilliSeconds=" + this.getReadTimeoutMilliSeconds() + ", receiveBufferSize=" + this.getReceiveBufferSize() + ", sendBufferSize=" + this.getSendBufferSize() + ")";
        }
    }

    public static class Cluster {
        private ClusterConnectionMode mode;
        private ClusterType requiredClusterType = ClusterType.UNKNOWN;
        private String requiredReplicaSetName;
        private long localThresholdMilliSeconds = 15L;
        private long serverSelectionTimeoutMilliSeconds = 30000L;

        @Generated
        public Cluster() {
        }

        @Generated
        public ClusterConnectionMode getMode() {
            return this.mode;
        }

        @Generated
        public ClusterType getRequiredClusterType() {
            return this.requiredClusterType;
        }

        @Generated
        public String getRequiredReplicaSetName() {
            return this.requiredReplicaSetName;
        }

        @Generated
        public long getLocalThresholdMilliSeconds() {
            return this.localThresholdMilliSeconds;
        }

        @Generated
        public long getServerSelectionTimeoutMilliSeconds() {
            return this.serverSelectionTimeoutMilliSeconds;
        }

        @Generated
        public void setMode(ClusterConnectionMode mode) {
            this.mode = mode;
        }

        @Generated
        public void setRequiredClusterType(ClusterType requiredClusterType) {
            this.requiredClusterType = requiredClusterType;
        }

        @Generated
        public void setRequiredReplicaSetName(String requiredReplicaSetName) {
            this.requiredReplicaSetName = requiredReplicaSetName;
        }

        @Generated
        public void setLocalThresholdMilliSeconds(long localThresholdMilliSeconds) {
            this.localThresholdMilliSeconds = localThresholdMilliSeconds;
        }

        @Generated
        public void setServerSelectionTimeoutMilliSeconds(long serverSelectionTimeoutMilliSeconds) {
            this.serverSelectionTimeoutMilliSeconds = serverSelectionTimeoutMilliSeconds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cluster)) {
                return false;
            }
            Cluster other = (Cluster)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLocalThresholdMilliSeconds() != other.getLocalThresholdMilliSeconds()) {
                return false;
            }
            if (this.getServerSelectionTimeoutMilliSeconds() != other.getServerSelectionTimeoutMilliSeconds()) {
                return false;
            }
            ClusterConnectionMode this$mode = this.getMode();
            ClusterConnectionMode other$mode = other.getMode();
            if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
                return false;
            }
            ClusterType this$requiredClusterType = this.getRequiredClusterType();
            ClusterType other$requiredClusterType = other.getRequiredClusterType();
            if (this$requiredClusterType == null ? other$requiredClusterType != null : !this$requiredClusterType.equals(other$requiredClusterType)) {
                return false;
            }
            String this$requiredReplicaSetName = this.getRequiredReplicaSetName();
            String other$requiredReplicaSetName = other.getRequiredReplicaSetName();
            return !(this$requiredReplicaSetName == null ? other$requiredReplicaSetName != null : !this$requiredReplicaSetName.equals(other$requiredReplicaSetName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Cluster;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $localThresholdMilliSeconds = this.getLocalThresholdMilliSeconds();
            result = result * 59 + (int)($localThresholdMilliSeconds >>> 32 ^ $localThresholdMilliSeconds);
            long $serverSelectionTimeoutMilliSeconds = this.getServerSelectionTimeoutMilliSeconds();
            result = result * 59 + (int)($serverSelectionTimeoutMilliSeconds >>> 32 ^ $serverSelectionTimeoutMilliSeconds);
            ClusterConnectionMode $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
            ClusterType $requiredClusterType = this.getRequiredClusterType();
            result = result * 59 + ($requiredClusterType == null ? 43 : $requiredClusterType.hashCode());
            String $requiredReplicaSetName = this.getRequiredReplicaSetName();
            result = result * 59 + ($requiredReplicaSetName == null ? 43 : $requiredReplicaSetName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MongoProperties.Cluster(mode=" + String.valueOf(this.getMode()) + ", requiredClusterType=" + String.valueOf(this.getRequiredClusterType()) + ", requiredReplicaSetName=" + this.getRequiredReplicaSetName() + ", localThresholdMilliSeconds=" + this.getLocalThresholdMilliSeconds() + ", serverSelectionTimeoutMilliSeconds=" + this.getServerSelectionTimeoutMilliSeconds() + ")";
        }
    }

    public static class Server {
        private long heartbeatFrequencyMilliSeconds = 10000L;
        private long minHeartbeatFrequencyMilliSeconds = 500L;

        @Generated
        public Server() {
        }

        @Generated
        public long getHeartbeatFrequencyMilliSeconds() {
            return this.heartbeatFrequencyMilliSeconds;
        }

        @Generated
        public long getMinHeartbeatFrequencyMilliSeconds() {
            return this.minHeartbeatFrequencyMilliSeconds;
        }

        @Generated
        public void setHeartbeatFrequencyMilliSeconds(long heartbeatFrequencyMilliSeconds) {
            this.heartbeatFrequencyMilliSeconds = heartbeatFrequencyMilliSeconds;
        }

        @Generated
        public void setMinHeartbeatFrequencyMilliSeconds(long minHeartbeatFrequencyMilliSeconds) {
            this.minHeartbeatFrequencyMilliSeconds = minHeartbeatFrequencyMilliSeconds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Server)) {
                return false;
            }
            Server other = (Server)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getHeartbeatFrequencyMilliSeconds() != other.getHeartbeatFrequencyMilliSeconds()) {
                return false;
            }
            return this.getMinHeartbeatFrequencyMilliSeconds() == other.getMinHeartbeatFrequencyMilliSeconds();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Server;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $heartbeatFrequencyMilliSeconds = this.getHeartbeatFrequencyMilliSeconds();
            result = result * 59 + (int)($heartbeatFrequencyMilliSeconds >>> 32 ^ $heartbeatFrequencyMilliSeconds);
            long $minHeartbeatFrequencyMilliSeconds = this.getMinHeartbeatFrequencyMilliSeconds();
            result = result * 59 + (int)($minHeartbeatFrequencyMilliSeconds >>> 32 ^ $minHeartbeatFrequencyMilliSeconds);
            return result;
        }

        @Generated
        public String toString() {
            return "MongoProperties.Server(heartbeatFrequencyMilliSeconds=" + this.getHeartbeatFrequencyMilliSeconds() + ", minHeartbeatFrequencyMilliSeconds=" + this.getMinHeartbeatFrequencyMilliSeconds() + ")";
        }
    }

    public static class Connection {
        private int maxSize = 100;
        private int minSize;
        private long maxWaitTimeMilliSeconds = 120000L;
        private long maxConnectionLifeTimeMilliSeconds;
        private long maxConnectionIdleTimeMilliSeconds;
        private long maintenanceInitialDelayMilliSeconds;
        private long maintenanceFrequencyMilliSeconds = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES);

        @Generated
        public Connection() {
        }

        @Generated
        public int getMaxSize() {
            return this.maxSize;
        }

        @Generated
        public int getMinSize() {
            return this.minSize;
        }

        @Generated
        public long getMaxWaitTimeMilliSeconds() {
            return this.maxWaitTimeMilliSeconds;
        }

        @Generated
        public long getMaxConnectionLifeTimeMilliSeconds() {
            return this.maxConnectionLifeTimeMilliSeconds;
        }

        @Generated
        public long getMaxConnectionIdleTimeMilliSeconds() {
            return this.maxConnectionIdleTimeMilliSeconds;
        }

        @Generated
        public long getMaintenanceInitialDelayMilliSeconds() {
            return this.maintenanceInitialDelayMilliSeconds;
        }

        @Generated
        public long getMaintenanceFrequencyMilliSeconds() {
            return this.maintenanceFrequencyMilliSeconds;
        }

        @Generated
        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }

        @Generated
        public void setMinSize(int minSize) {
            this.minSize = minSize;
        }

        @Generated
        public void setMaxWaitTimeMilliSeconds(long maxWaitTimeMilliSeconds) {
            this.maxWaitTimeMilliSeconds = maxWaitTimeMilliSeconds;
        }

        @Generated
        public void setMaxConnectionLifeTimeMilliSeconds(long maxConnectionLifeTimeMilliSeconds) {
            this.maxConnectionLifeTimeMilliSeconds = maxConnectionLifeTimeMilliSeconds;
        }

        @Generated
        public void setMaxConnectionIdleTimeMilliSeconds(long maxConnectionIdleTimeMilliSeconds) {
            this.maxConnectionIdleTimeMilliSeconds = maxConnectionIdleTimeMilliSeconds;
        }

        @Generated
        public void setMaintenanceInitialDelayMilliSeconds(long maintenanceInitialDelayMilliSeconds) {
            this.maintenanceInitialDelayMilliSeconds = maintenanceInitialDelayMilliSeconds;
        }

        @Generated
        public void setMaintenanceFrequencyMilliSeconds(long maintenanceFrequencyMilliSeconds) {
            this.maintenanceFrequencyMilliSeconds = maintenanceFrequencyMilliSeconds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Connection)) {
                return false;
            }
            Connection other = (Connection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxSize() != other.getMaxSize()) {
                return false;
            }
            if (this.getMinSize() != other.getMinSize()) {
                return false;
            }
            if (this.getMaxWaitTimeMilliSeconds() != other.getMaxWaitTimeMilliSeconds()) {
                return false;
            }
            if (this.getMaxConnectionLifeTimeMilliSeconds() != other.getMaxConnectionLifeTimeMilliSeconds()) {
                return false;
            }
            if (this.getMaxConnectionIdleTimeMilliSeconds() != other.getMaxConnectionIdleTimeMilliSeconds()) {
                return false;
            }
            if (this.getMaintenanceInitialDelayMilliSeconds() != other.getMaintenanceInitialDelayMilliSeconds()) {
                return false;
            }
            return this.getMaintenanceFrequencyMilliSeconds() == other.getMaintenanceFrequencyMilliSeconds();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Connection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxSize();
            result = result * 59 + this.getMinSize();
            long $maxWaitTimeMilliSeconds = this.getMaxWaitTimeMilliSeconds();
            result = result * 59 + (int)($maxWaitTimeMilliSeconds >>> 32 ^ $maxWaitTimeMilliSeconds);
            long $maxConnectionLifeTimeMilliSeconds = this.getMaxConnectionLifeTimeMilliSeconds();
            result = result * 59 + (int)($maxConnectionLifeTimeMilliSeconds >>> 32 ^ $maxConnectionLifeTimeMilliSeconds);
            long $maxConnectionIdleTimeMilliSeconds = this.getMaxConnectionIdleTimeMilliSeconds();
            result = result * 59 + (int)($maxConnectionIdleTimeMilliSeconds >>> 32 ^ $maxConnectionIdleTimeMilliSeconds);
            long $maintenanceInitialDelayMilliSeconds = this.getMaintenanceInitialDelayMilliSeconds();
            result = result * 59 + (int)($maintenanceInitialDelayMilliSeconds >>> 32 ^ $maintenanceInitialDelayMilliSeconds);
            long $maintenanceFrequencyMilliSeconds = this.getMaintenanceFrequencyMilliSeconds();
            result = result * 59 + (int)($maintenanceFrequencyMilliSeconds >>> 32 ^ $maintenanceFrequencyMilliSeconds);
            return result;
        }

        @Generated
        public String toString() {
            return "MongoProperties.Connection(maxSize=" + this.getMaxSize() + ", minSize=" + this.getMinSize() + ", maxWaitTimeMilliSeconds=" + this.getMaxWaitTimeMilliSeconds() + ", maxConnectionLifeTimeMilliSeconds=" + this.getMaxConnectionLifeTimeMilliSeconds() + ", maxConnectionIdleTimeMilliSeconds=" + this.getMaxConnectionIdleTimeMilliSeconds() + ", maintenanceInitialDelayMilliSeconds=" + this.getMaintenanceInitialDelayMilliSeconds() + ", maintenanceFrequencyMilliSeconds=" + this.getMaintenanceFrequencyMilliSeconds() + ")";
        }
    }

    public static class Ssl {
        private boolean enabled;
        private boolean invalidHostNameAllowed;

        @Generated
        public Ssl() {
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isInvalidHostNameAllowed() {
            return this.invalidHostNameAllowed;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setInvalidHostNameAllowed(boolean invalidHostNameAllowed) {
            this.invalidHostNameAllowed = invalidHostNameAllowed;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ssl)) {
                return false;
            }
            Ssl other = (Ssl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            return this.isInvalidHostNameAllowed() == other.isInvalidHostNameAllowed();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Ssl;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + (this.isInvalidHostNameAllowed() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "MongoProperties.Ssl(enabled=" + this.isEnabled() + ", invalidHostNameAllowed=" + this.isInvalidHostNameAllowed() + ")";
        }
    }
}

