/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.mongo;

import jakarta.annotation.Resource;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.miaixz.bus.starter.mongo.MongoProperties;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@EnableConfigurationProperties(value={MongoProperties.class})
public class MongoConfiguration {
    @Resource
    MongoProperties properties;

    @Bean
    @Order(value=0)
    public MongoClientSettingsBuilderCustomizer socketSettings() {
        return builder -> Optional.ofNullable(this.properties.getSocket()).ifPresent(socketSettings -> builder.applyToSocketSettings(socket -> socket.readTimeout((long)Long.valueOf(socketSettings.getReadTimeoutMilliSeconds()).intValue(), TimeUnit.MILLISECONDS).connectTimeout((long)Long.valueOf(socketSettings.getConnectTimeoutMilliSeconds()).intValue(), TimeUnit.MILLISECONDS).receiveBufferSize(socketSettings.getReceiveBufferSize()).sendBufferSize(socketSettings.getSendBufferSize())));
    }

    @Bean
    @Order(value=1)
    public MongoClientSettingsBuilderCustomizer heartbeatSocketSettings() {
        return builder -> Optional.ofNullable(this.properties.getHeartbeatSocket()).ifPresent(heartbeatSocketSettings -> builder.applyToSocketSettings(heartBeatSocket -> heartBeatSocket.readTimeout((long)Long.valueOf(heartbeatSocketSettings.getReadTimeoutMilliSeconds()).intValue(), TimeUnit.MILLISECONDS).connectTimeout((long)Long.valueOf(heartbeatSocketSettings.getConnectTimeoutMilliSeconds()).intValue(), TimeUnit.MILLISECONDS).receiveBufferSize(heartbeatSocketSettings.getReceiveBufferSize()).sendBufferSize(heartbeatSocketSettings.getSendBufferSize())));
    }

    @Bean
    @Order(value=2)
    public MongoClientSettingsBuilderCustomizer clusterSettings() {
        return builder -> Optional.ofNullable(this.properties.getCluster()).ifPresent(clusterSettings -> builder.applyToClusterSettings(cluster -> {
            Optional.ofNullable(clusterSettings.getMode()).ifPresent(mode -> cluster.mode(mode));
            Optional.ofNullable(clusterSettings.getRequiredClusterType()).ifPresent(requiredClusterType -> cluster.requiredClusterType(requiredClusterType));
            Optional.ofNullable(clusterSettings.getRequiredReplicaSetName()).ifPresent(requiredReplicaSetName -> cluster.requiredReplicaSetName(requiredReplicaSetName));
            cluster.localThreshold(clusterSettings.getLocalThresholdMilliSeconds(), TimeUnit.MILLISECONDS).serverSelectionTimeout(clusterSettings.getServerSelectionTimeoutMilliSeconds(), TimeUnit.MILLISECONDS);
        }));
    }

    @Bean
    @Order(value=3)
    public MongoClientSettingsBuilderCustomizer serverSettings() {
        return builder -> Optional.ofNullable(this.properties.getServer()).ifPresent(serverSettings -> builder.applyToServerSettings(server -> server.heartbeatFrequency(serverSettings.getHeartbeatFrequencyMilliSeconds(), TimeUnit.MILLISECONDS).minHeartbeatFrequency(serverSettings.getMinHeartbeatFrequencyMilliSeconds(), TimeUnit.MILLISECONDS)));
    }

    @Bean
    @Order(value=4)
    public MongoClientSettingsBuilderCustomizer connectionSettings() {
        return builder -> Optional.ofNullable(this.properties.getConnectionPool()).ifPresent(connectionSettings -> builder.applyToConnectionPoolSettings(connection -> connection.maxSize(connectionSettings.getMaxSize()).minSize(connectionSettings.getMinSize()).maxWaitTime(connectionSettings.getMaxWaitTimeMilliSeconds(), TimeUnit.MILLISECONDS).maxConnectionLifeTime(connectionSettings.getMaxConnectionLifeTimeMilliSeconds(), TimeUnit.MILLISECONDS).maxConnectionIdleTime(connectionSettings.getMaxConnectionIdleTimeMilliSeconds(), TimeUnit.MILLISECONDS).maintenanceFrequency(connectionSettings.getMaintenanceFrequencyMilliSeconds(), TimeUnit.MILLISECONDS).maintenanceInitialDelay(connectionSettings.getMaintenanceInitialDelayMilliSeconds(), TimeUnit.MILLISECONDS)));
    }

    @Bean
    @Order(value=5)
    public MongoClientSettingsBuilderCustomizer sslSettings() {
        return builder -> Optional.ofNullable(this.properties.getSsl()).ifPresent(sslSettings -> builder.applyToSslSettings(ssl -> ssl.enabled(sslSettings.isEnabled()).invalidHostNameAllowed(sslSettings.isInvalidHostNameAllowed())));
    }
}

