/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import lombok.Generated;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

@ConfigurationProperties(prefix="bus.mybatis")
public class MybatisProperties {
    private static final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
    private String[] basePackage;
    private String configLocation;
    private String[] mapperLocations;
    private String typeAliasesPackage;
    private Class<?> typeAliasesSuperType;
    private String typeHandlersPackage;
    private boolean checkConfigLocation = false;
    private ExecutorType executorType;
    private Properties configurationProperties;
    @NestedConfigurationProperty
    private Configuration configuration;
    private String params;
    private String autoDelimitKeywords;
    private String reasonable;
    private String supportMethodsArguments;

    public Resource[] resolveMapperLocations() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.mapperLocations != null) {
            for (String mapperLocation : this.mapperLocations) {
                resources.addAll(Arrays.asList(this.getResources(mapperLocation)));
            }
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    private Resource[] getResources(String location) {
        try {
            return resourceResolver.getResources(location);
        }
        catch (IOException e) {
            return new Resource[0];
        }
    }

    @Generated
    public String[] getBasePackage() {
        return this.basePackage;
    }

    @Generated
    public String getConfigLocation() {
        return this.configLocation;
    }

    @Generated
    public String[] getMapperLocations() {
        return this.mapperLocations;
    }

    @Generated
    public String getTypeAliasesPackage() {
        return this.typeAliasesPackage;
    }

    @Generated
    public Class<?> getTypeAliasesSuperType() {
        return this.typeAliasesSuperType;
    }

    @Generated
    public String getTypeHandlersPackage() {
        return this.typeHandlersPackage;
    }

    @Generated
    public boolean isCheckConfigLocation() {
        return this.checkConfigLocation;
    }

    @Generated
    public ExecutorType getExecutorType() {
        return this.executorType;
    }

    @Generated
    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public String getParams() {
        return this.params;
    }

    @Generated
    public String getAutoDelimitKeywords() {
        return this.autoDelimitKeywords;
    }

    @Generated
    public String getReasonable() {
        return this.reasonable;
    }

    @Generated
    public String getSupportMethodsArguments() {
        return this.supportMethodsArguments;
    }

    @Generated
    public void setBasePackage(String[] basePackage) {
        this.basePackage = basePackage;
    }

    @Generated
    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    @Generated
    public void setMapperLocations(String[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    @Generated
    public void setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
    }

    @Generated
    public void setTypeAliasesSuperType(Class<?> typeAliasesSuperType) {
        this.typeAliasesSuperType = typeAliasesSuperType;
    }

    @Generated
    public void setTypeHandlersPackage(String typeHandlersPackage) {
        this.typeHandlersPackage = typeHandlersPackage;
    }

    @Generated
    public void setCheckConfigLocation(boolean checkConfigLocation) {
        this.checkConfigLocation = checkConfigLocation;
    }

    @Generated
    public void setExecutorType(ExecutorType executorType) {
        this.executorType = executorType;
    }

    @Generated
    public void setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    @Generated
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setParams(String params) {
        this.params = params;
    }

    @Generated
    public void setAutoDelimitKeywords(String autoDelimitKeywords) {
        this.autoDelimitKeywords = autoDelimitKeywords;
    }

    @Generated
    public void setReasonable(String reasonable) {
        this.reasonable = reasonable;
    }

    @Generated
    public void setSupportMethodsArguments(String supportMethodsArguments) {
        this.supportMethodsArguments = supportMethodsArguments;
    }
}

