/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.miaixz.bus.core.Context;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.mapper.handler.MapperHandler;
import org.miaixz.bus.mapper.handler.MybatisInterceptor;
import org.miaixz.bus.pager.handler.OperationHandler;
import org.miaixz.bus.pager.handler.PaginationHandler;
import org.miaixz.bus.pager.handler.TenantHandler;
import org.miaixz.bus.pager.handler.TenantProvider;
import org.miaixz.bus.spring.annotation.PlaceHolderBinder;
import org.miaixz.bus.starter.mapper.MybatisProperties;
import org.springframework.core.env.Environment;

public class MybatisPluginBuilder {
    public static MybatisInterceptor build(Environment environment) {
        ArrayList<MapperHandler> handlers = new ArrayList<MapperHandler>();
        handlers.add((MapperHandler)new OperationHandler());
        if (ObjectKit.isNotEmpty((Object)environment)) {
            MybatisPluginBuilder.configurePagination(environment, handlers);
            MybatisPluginBuilder.configureTenant(environment, handlers);
        }
        MybatisInterceptor interceptor = new MybatisInterceptor();
        interceptor.setHandlers(handlers);
        return interceptor;
    }

    private static void configurePagination(Environment environment, List<MapperHandler> handlers) {
        MybatisProperties properties = PlaceHolderBinder.bind(environment, MybatisProperties.class, "bus.mybatis");
        if (ObjectKit.isNotEmpty((Object)properties)) {
            Properties props = new Properties();
            props.setProperty("autoDelimitKeywords", properties.getAutoDelimitKeywords());
            props.setProperty("reasonable", properties.getReasonable());
            props.setProperty("supportMethodsArguments", properties.getSupportMethodsArguments());
            props.setProperty("params", properties.getParams());
            PaginationHandler paginationHandler = new PaginationHandler();
            paginationHandler.setProperties(props);
            handlers.add((MapperHandler)paginationHandler);
        }
    }

    private static void configureTenant(Environment environment, List<MapperHandler> handlers) {
        MybatisProperties properties = PlaceHolderBinder.bind(environment, MybatisProperties.class, "bus.mybatis");
        if (ObjectKit.isNotEmpty((Object)properties.getConfigurationProperties()) && ObjectKit.isNotEmpty((Object)properties.getConfigurationProperties().get("tenant.column"))) {
            Logger.info((String)"Enable multi-tenant support, all database operations will include tenant ID support.", (Object[])new Object[0]);
            TenantHandler tenantHandler = new TenantHandler();
            tenantHandler.setProvider(new TenantProvider(){

                public String getColumn() {
                    return Context.INSTANCE.getProperty("tenant.column", "tenant_id");
                }

                public boolean ignore(String name) {
                    String prefix = Context.INSTANCE.getProperty("table.prefix", "");
                    String ignoreTables = Context.INSTANCE.getProperty("tenant.ignore", "tenant");
                    List ignoreTableList = Arrays.stream(ignoreTables.split(",")).map(table -> prefix + table.trim()).collect(Collectors.toList());
                    return ignoreTableList.contains(name);
                }
            });
            handlers.add((MapperHandler)tenantHandler);
        }
    }
}

