/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.mapper;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.ibatis.annotations.Mapper;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.spring.annotation.PlaceHolderBinder;
import org.miaixz.bus.starter.annotation.EnableMapper;
import org.miaixz.bus.starter.mapper.ClassPathMapperScanner;
import org.miaixz.bus.starter.mapper.MapperFactoryBean;
import org.miaixz.bus.starter.mapper.MybatisProperties;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;

public class MapperScannerRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private Environment environment;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry, BeanNameGenerator importBeanNameGenerator) {
        super.registerBeanDefinitions(importingClassMetadata, registry, importBeanNameGenerator);
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        Class mapperFactoryBeanClass;
        Class generatorClass;
        Class markerInterface;
        Class annotationClass;
        AnnotationAttributes annoAttrs = AnnotationAttributes.fromMap((Map)annotationMetadata.getAnnotationAttributes(EnableMapper.class.getName()));
        ClassPathMapperScanner scanner = new ClassPathMapperScanner(registry);
        if (this.resourceLoader != null) {
            scanner.setResourceLoader(this.resourceLoader);
        }
        if (!Annotation.class.equals((Object)(annotationClass = annoAttrs.getClass("annotationClass")))) {
            scanner.setAnnotationClass(annotationClass);
        }
        if (!Class.class.equals((Object)(markerInterface = annoAttrs.getClass("markerInterface")))) {
            scanner.setMarkerInterface(markerInterface);
        }
        if (!BeanNameGenerator.class.equals((Object)(generatorClass = annoAttrs.getClass("nameGenerator")))) {
            scanner.setBeanNameGenerator((BeanNameGenerator)ReflectKit.newInstanceIfPossible((Class)generatorClass));
        }
        if (!MapperFactoryBean.class.equals((Object)(mapperFactoryBeanClass = annoAttrs.getClass("factoryBean")))) {
            scanner.setMapperFactoryBean((MapperFactoryBean)((Object)ReflectKit.newInstanceIfPossible((Class)mapperFactoryBeanClass)));
        }
        scanner.setSqlSessionTemplateBeanName(annoAttrs.getString("sqlSessionTemplateRef"));
        scanner.setSqlSessionFactoryBeanName(annoAttrs.getString("sqlSessionFactoryRef"));
        ArrayList<String> basePackage = new ArrayList<String>();
        for (String pkg : annoAttrs.getStringArray("value")) {
            if (!StringKit.hasText((String)pkg)) continue;
            basePackage.add(pkg);
        }
        for (String pkg : annoAttrs.getStringArray("basePackage")) {
            if (!StringKit.hasText((String)pkg)) continue;
            basePackage.add(pkg);
        }
        for (Class clazz : annoAttrs.getClassArray("basePackageClasses")) {
            basePackage.add(ClassKit.getPackageName((Class)clazz));
        }
        if (CollKit.isEmpty(basePackage)) {
            MybatisProperties properties = PlaceHolderBinder.bind(this.environment, MybatisProperties.class, "bus.mybatis");
            if (properties != null && properties.getBasePackage() != null && properties.getBasePackage().length > 0) {
                basePackage.addAll(Arrays.asList(properties.getBasePackage()));
            } else {
                scanner.setAnnotationClass(Mapper.class);
            }
        }
        scanner.registerFilters();
        scanner.doScan((String[])ArrayKit.ofArray(basePackage, String.class));
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

