/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.mapper;

import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.session.Configuration;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.logger.Logger;
import org.mybatis.spring.support.SqlSessionDaoSupport;
import org.springframework.beans.factory.FactoryBean;

public class MapperFactoryBean<T>
extends SqlSessionDaoSupport
implements FactoryBean<T> {
    private Class<T> mapperInterface;

    public MapperFactoryBean() {
    }

    public MapperFactoryBean(Class<T> mapperInterface) {
        this.mapperInterface = mapperInterface;
    }

    protected void checkDaoConfig() {
        super.checkDaoConfig();
        Assert.notNull(this.mapperInterface, (String)"Property 'mapperInterface' is required", (Object[])new Object[0]);
        Configuration configuration = this.getSqlSession().getConfiguration();
        if (!configuration.hasMapper(this.mapperInterface)) {
            try {
                configuration.addMapper(this.mapperInterface);
            }
            catch (Exception e) {
                Logger.error((String)("Error while adding the mapper '" + String.valueOf(this.mapperInterface) + "' to configuration."), (Object[])new Object[]{e});
                throw new IllegalArgumentException(e);
            }
            finally {
                ErrorContext.instance().reset();
            }
        }
    }

    public T getObject() {
        return (T)this.getSqlSession().getMapper(this.mapperInterface);
    }

    public Class<T> getObjectType() {
        return this.mapperInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<T> getMapperInterface() {
        return this.mapperInterface;
    }

    public void setMapperInterface(Class<T> mapperInterface) {
        this.mapperInterface = mapperInterface;
    }
}

