/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.mapper;

import jakarta.annotation.Resource;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.io.VFS;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.miaixz.bus.core.Context;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.starter.mapper.ConfigurationCustomizer;
import org.miaixz.bus.starter.mapper.MapperFactoryBean;
import org.miaixz.bus.starter.mapper.MybatisPluginBuilder;
import org.miaixz.bus.starter.mapper.MybatisProperties;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

@ConditionalOnMissingBean(value={MapperFactoryBean.class})
@EnableConfigurationProperties(value={MybatisProperties.class})
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
@AutoConfigureBefore(name={"org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration"})
public class MapperConfiguration
implements InitializingBean {
    private final Environment environment;
    private final ResourceLoader resourceLoader;
    private final List<ConfigurationCustomizer> configurationCustomizers;
    @Resource
    MybatisProperties properties;

    public MapperConfiguration(Environment environment, ResourceLoader resourceLoader, ObjectProvider<List<ConfigurationCustomizer>> configurationCustomizersProvider) {
        this.environment = environment;
        this.resourceLoader = resourceLoader;
        this.configurationCustomizers = (List)configurationCustomizersProvider.getIfAvailable();
        Logger.info((String)"Initializing MapperConfiguration with provided environment and resource loader", (Object[])new Object[0]);
    }

    public void afterPropertiesSet() {
        if (this.properties.isCheckConfigLocation() && StringKit.hasText((String)this.properties.getConfigLocation())) {
            org.springframework.core.io.Resource resource = this.resourceLoader.getResource(this.properties.getConfigLocation());
            Assert.state((boolean)resource.exists(), (String)("Cannot find config location: " + String.valueOf(resource) + " (please add config file or check your Mybatis configuration)"), (Object[])new Object[0]);
            Logger.debug((String)"Checked MyBatis config location: {}", (Object[])new Object[]{this.properties.getConfigLocation()});
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SqlSessionFactory sqlSessionFactory(DataSource dataSource) throws Exception {
        Configuration configuration;
        Logger.info((String)"Creating SqlSessionFactory with dataSource", (Object[])new Object[0]);
        SqlSessionFactoryBean factory = new SqlSessionFactoryBean();
        factory.setDataSource(dataSource);
        if (this.properties.getConfiguration() == null || this.properties.getConfiguration().getVfsImpl() == null) {
            factory.setVfs(SpringBootVFS.class);
        }
        if (StringKit.hasText((String)this.properties.getConfigLocation())) {
            factory.setConfigLocation(this.resourceLoader.getResource(this.properties.getConfigLocation()));
        }
        if ((configuration = this.properties.getConfiguration()) == null && !StringKit.hasText((String)this.properties.getConfigLocation())) {
            configuration = new Configuration();
        }
        if (configuration != null && !CollKit.isEmpty(this.configurationCustomizers)) {
            for (ConfigurationCustomizer customizer : this.configurationCustomizers) {
                customizer.customize(configuration);
            }
        }
        if (this.properties.getConfigurationProperties() != null) {
            factory.setConfigurationProperties(this.properties.getConfigurationProperties());
            Context.INSTANCE.putAll(this.properties.getConfigurationProperties());
        }
        if (ObjectKit.isEmptyIfString((Object)this.properties.getTypeAliasesPackage())) {
            factory.setTypeAliasesPackage(this.properties.getTypeAliasesPackage());
        }
        if (this.properties.getTypeAliasesSuperType() != null) {
            factory.setTypeAliasesSuperType(this.properties.getTypeAliasesSuperType());
        }
        if (ObjectKit.isEmptyIfString((Object)this.properties.getTypeHandlersPackage())) {
            factory.setTypeHandlersPackage(this.properties.getTypeHandlersPackage());
        }
        if (!ObjectKit.isEmpty((Object)this.properties.resolveMapperLocations())) {
            factory.setMapperLocations(this.properties.resolveMapperLocations());
        }
        factory.setConfiguration(configuration);
        factory.setPlugins(new Interceptor[]{MybatisPluginBuilder.build(this.environment)});
        SqlSessionFactory sqlSessionFactory = factory.getObject();
        Logger.info((String)"SqlSessionFactory created successfully", (Object[])new Object[0]);
        return sqlSessionFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        SqlSessionTemplate template;
        ExecutorType executorType = this.properties.getExecutorType();
        if (executorType != null) {
            template = new SqlSessionTemplate(sqlSessionFactory, executorType);
            Logger.info((String)"Created SqlSessionTemplate with executor type: {}", (Object[])new Object[]{executorType});
        } else {
            template = new SqlSessionTemplate(sqlSessionFactory);
            Logger.info((String)"Created SqlSessionTemplate with default executor type", (Object[])new Object[0]);
        }
        return template;
    }

    class SpringBootVFS
    extends VFS {
        private final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver(((Object)((Object)this)).getClass().getClassLoader());

        public SpringBootVFS(MapperConfiguration this$0) {
            Logger.debug((String)"Initialized SpringBootVFS with resource resolver", (Object[])new Object[0]);
        }

        private String preserveSubpackageName(URI uri, String rootPath) {
            String url = uri.toString();
            return url.substring(url.indexOf(rootPath));
        }

        public boolean isValid() {
            return true;
        }

        protected List<String> list(URL url, String path) throws IOException {
            org.springframework.core.io.Resource[] resources = this.resourceResolver.getResources("classpath*:" + path + "/**/*.class");
            ArrayList<String> resourcePaths = new ArrayList<String>();
            for (org.springframework.core.io.Resource resource : resources) {
                resourcePaths.add(this.preserveSubpackageName(resource.getURI(), path));
            }
            Logger.debug((String)"Listed resources for path: {}", (Object[])new Object[]{path});
            return resourcePaths;
        }
    }
}

