/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.mapper;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import org.apache.ibatis.session.SqlSessionFactory;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.starter.mapper.MapperFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ClassPathMapperScanner
extends ClassPathBeanDefinitionScanner {
    private SqlSessionFactory sqlSessionFactory;
    private SqlSessionTemplate sqlSessionTemplate;
    private String sqlSessionTemplateBeanName;
    private String sqlSessionFactoryBeanName;
    private Class<? extends Annotation> annotationClass;
    private Class<?> markerInterface;
    private String mapperBuilderBeanName;
    private MapperFactoryBean<?> mapperFactoryBean = new MapperFactoryBean();

    public ClassPathMapperScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
    }

    public void registerFilters() {
        boolean acceptAllInterfaces = true;
        if (this.annotationClass != null) {
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(this.annotationClass));
            acceptAllInterfaces = false;
        }
        if (this.markerInterface != null) {
            this.addIncludeFilter((TypeFilter)new AssignableTypeFilter(this, this.markerInterface){

                protected boolean matchClassName(String className) {
                    return false;
                }
            });
            acceptAllInterfaces = false;
        }
        if (acceptAllInterfaces) {
            this.addIncludeFilter((metadataReader, metadataReaderFactory) -> true);
        }
        this.addExcludeFilter((metadataReader, metadataReaderFactory) -> metadataReader.getClassMetadata().getClassName().endsWith("package-info"));
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            Logger.warn((String)"No MyBatis mapper was found in '{}' package. Please check your configuration.", (Object[])new Object[]{Arrays.toString(basePackages)});
        } else {
            this.processBeanDefinitions(beanDefinitions);
        }
        return beanDefinitions;
    }

    private void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            definition.getConstructorArgumentValues().addGenericArgumentValue((Object)definition.getBeanClassName());
            definition.setBeanClass(((Object)this.mapperFactoryBean).getClass());
            if (StringKit.hasText((String)this.mapperBuilderBeanName)) {
                definition.getPropertyValues().add("mapperBuilder", (Object)new RuntimeBeanReference(this.mapperBuilderBeanName));
            }
            boolean explicitFactoryUsed = false;
            if (StringKit.hasText((String)this.sqlSessionFactoryBeanName)) {
                definition.getPropertyValues().add("sqlSessionFactory", (Object)new RuntimeBeanReference(this.sqlSessionFactoryBeanName));
                explicitFactoryUsed = true;
            } else if (this.sqlSessionFactory != null) {
                definition.getPropertyValues().add("sqlSessionFactory", (Object)this.sqlSessionFactory);
                explicitFactoryUsed = true;
            }
            if (StringKit.hasText((String)this.sqlSessionTemplateBeanName)) {
                if (explicitFactoryUsed) {
                    Logger.warn((String)"Cannot use both: sqlSessionTemplate and sqlSessionFactory together. sqlSessionFactory is ignored.", (Object[])new Object[0]);
                }
                definition.getPropertyValues().add("sqlSessionTemplate", (Object)new RuntimeBeanReference(this.sqlSessionTemplateBeanName));
                explicitFactoryUsed = true;
            } else if (this.sqlSessionTemplate != null) {
                if (explicitFactoryUsed) {
                    Logger.warn((String)"Cannot use both: sqlSessionTemplate and sqlSessionFactory together. sqlSessionFactory is ignored.", (Object[])new Object[0]);
                }
                definition.getPropertyValues().add("sqlSessionTemplate", (Object)this.sqlSessionTemplate);
                explicitFactoryUsed = true;
            }
            if (explicitFactoryUsed) continue;
            if (Logger.isDebugEnabled()) {
                Logger.debug((String)"Enabling component by type for MapperFactoryBean with name '{}' and '{}'", (Object[])new Object[]{holder.getBeanName(), definition.getBeanClassName()});
            }
            definition.setAutowireMode(2);
        }
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }

    protected boolean checkCandidate(String beanName, BeanDefinition beanDefinition) {
        if (super.checkCandidate(beanName, beanDefinition)) {
            return true;
        }
        Logger.warn((String)"Skipping MapperFactoryBean with name '{}' and '{}' mapperInterface. Bean already defined with the same name!", (Object[])new Object[]{beanName, beanDefinition.getBeanClassName()});
        return false;
    }

    public void setAnnotationClass(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public void setMapperFactoryBean(MapperFactoryBean<?> mapperFactoryBean) {
        this.mapperFactoryBean = mapperFactoryBean != null ? mapperFactoryBean : new MapperFactoryBean();
    }

    public void setMapperBuilderBeanName(String mapperBuilderBeanName) {
        this.mapperBuilderBeanName = mapperBuilderBeanName;
    }

    public void setMarkerInterface(Class<?> markerInterface) {
        this.markerInterface = markerInterface;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public void setSqlSessionFactoryBeanName(String sqlSessionFactoryBeanName) {
        this.sqlSessionFactoryBeanName = sqlSessionFactoryBeanName;
    }

    public void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.sqlSessionTemplate = sqlSessionTemplate;
    }

    public void setSqlSessionTemplateBeanName(String sqlSessionTemplateBeanName) {
        this.sqlSessionTemplateBeanName = sqlSessionTemplateBeanName;
    }
}

