/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.limiter;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.miaixz.bus.core.lang.tuple.Pair;
import org.miaixz.bus.core.xyz.AnnoKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.limiter.Builder;
import org.miaixz.bus.limiter.Provider;
import org.miaixz.bus.limiter.magic.StrategyMode;
import org.miaixz.bus.limiter.magic.annotation.Downgrade;
import org.miaixz.bus.limiter.magic.annotation.Hotspot;
import org.miaixz.bus.limiter.magic.annotation.Limiting;
import org.miaixz.bus.limiter.metric.MethodManager;
import org.miaixz.bus.limiter.metric.StrategyManager;
import org.miaixz.bus.limiter.proxy.ByteBuddyProxy;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;

public class LimiterScanner
implements InstantiationAwareBeanPostProcessor {
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class clazz = Builder.getUserClass(bean.getClass());
        if (Provider.class.isAssignableFrom(clazz)) {
            StrategyManager.add((Provider)((Provider)bean));
            return bean;
        }
        AtomicBoolean needProxy = new AtomicBoolean(false);
        Arrays.stream(clazz.getMethods()).forEach(method -> {
            Limiting limiting;
            Hotspot hotspot;
            Downgrade downgrade = this.searchAnnotation((Method)method, (Class)Downgrade.class);
            if (ObjectKit.isNotNull((Object)downgrade)) {
                MethodManager.addMethod((String)Builder.resolveMethodName((Method)method), (Pair)new Pair((Object)StrategyMode.FALLBACK, (Object)downgrade));
                needProxy.set(true);
            }
            if (ObjectKit.isNotNull((Object)(hotspot = this.searchAnnotation((Method)method, (Class)Hotspot.class)))) {
                MethodManager.addMethod((String)Builder.resolveMethodName((Method)method), (Pair)new Pair((Object)StrategyMode.HOT_METHOD, (Object)hotspot));
                needProxy.set(true);
            }
            if (ObjectKit.isNotNull((Object)(limiting = this.searchAnnotation((Method)method, (Class)Limiting.class)))) {
                MethodManager.addMethod((String)Builder.resolveMethodName((Method)method), (Pair)new Pair((Object)StrategyMode.REQUEST_LIMIT, (Object)limiting));
                needProxy.set(true);
            }
        });
        if (needProxy.get()) {
            try {
                ByteBuddyProxy buddy = new ByteBuddyProxy(bean, clazz);
                return buddy.proxy();
            }
            catch (Exception e) {
                throw new BeanInitializationException(e.getMessage());
            }
        }
        return bean;
    }

    private <A extends Annotation> A searchAnnotation(Method method, Class<A> annotationType) {
        Annotation anno = AnnoKit.getAnnotation((AnnotatedElement)method, annotationType);
        if (anno == null) {
            Class<?>[] ifaces;
            for (Class<?> ifaceClass : ifaces = method.getDeclaringClass().getInterfaces()) {
                Method ifaceMethod = MethodKit.getMethod(ifaceClass, (String)method.getName(), (Class[])method.getParameterTypes());
                if (ifaceMethod == null) continue;
                anno = this.searchAnnotation(ifaceMethod, annotationType);
                break;
            }
        }
        if (anno == null) {
            Class<?> superClazz = method.getDeclaringClass().getSuperclass();
            if (superClazz != null) {
                Method superMethod = MethodKit.getMethod(superClazz, (String)method.getName(), (Class[])method.getParameterTypes());
                if (superMethod != null) {
                    return this.searchAnnotation(superMethod, annotationType);
                }
                return null;
            }
            return null;
        }
        return (A)anno;
    }
}

