/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.limiter;

import jakarta.annotation.Resource;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.limiter.Supplier;
import org.miaixz.bus.limiter.metric.FallbackProvider;
import org.miaixz.bus.limiter.metric.MethodProvider;
import org.miaixz.bus.limiter.metric.RequestProvider;
import org.miaixz.bus.starter.limiter.LimiterProperties;
import org.miaixz.bus.starter.limiter.LimiterScanner;
import org.miaixz.bus.starter.limiter.LimiterService;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={LimiterProperties.class})
public class LimiterConfiguration {
    @Resource
    LimiterProperties properties;

    @Bean
    public LimiterService limiterService() {
        return new LimiterService(this.properties);
    }

    @Bean
    public RequestProvider requestProvider() {
        Supplier instance;
        RequestProvider strategy = new RequestProvider();
        String implClassName = this.properties.getSupplier();
        if (StringKit.isNotEmpty((CharSequence)implClassName) && Supplier.class.isAssignableFrom((instance = (Supplier)ReflectKit.newInstance((String)implClassName)).getClass())) {
            strategy.setMarkSupplier(instance);
        }
        return strategy;
    }

    @Bean
    public FallbackProvider fallbackProvider() {
        return new FallbackProvider();
    }

    @Bean
    public MethodProvider methodProvider() {
        return new MethodProvider();
    }

    @Bean
    public LimiterScanner scanner() {
        return new LimiterScanner();
    }
}

