/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.jdbc;

import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.miaixz.bus.core.lang.Normal;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.starter.jdbc.DataSourceHolder;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    private static final Set<Object> keySet = new LinkedHashSet<Object>();
    private static final byte[] lock = Normal.EMPTY_BYTE_ARRAY;
    private static volatile DynamicDataSource instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized DynamicDataSource getInstance() {
        if (null != instance) return instance;
        byte[] byArray = lock;
        synchronized (lock) {
            if (null != instance) return instance;
            instance = new DynamicDataSource();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static synchronized void addDataSource(String key, DataSource dataSource) {
        if (null != dataSource && dataSource instanceof AbstractRoutingDataSource) {
            try {
                Field sourceMapField = AbstractRoutingDataSource.class.getDeclaredField("resolvedDataSources");
                sourceMapField.setAccessible(true);
                Map sourceMap = (Map)sourceMapField.get(DynamicDataSource.getInstance().getDefaultDataSource());
                sourceMap.put(key, dataSource);
                keySet.add(key);
                sourceMapField.setAccessible(false);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    public void setTargetDataSources(Map<Object, Object> map) {
        super.setTargetDataSources(map);
        keySet.add(map.keySet());
        this.afterPropertiesSet();
    }

    protected Object determineCurrentLookupKey() {
        String key = DataSourceHolder.getKey();
        if (!keySet.contains(key)) {
            Logger.info((String)String.format("can not found datasource by key: '%s',this session may use default datasource", key), (Object[])new Object[0]);
        }
        Logger.debug((String)"The current datasource key \uff1a{}", (Object[])new Object[]{Objects.requireNonNullElse(key, "dataSource")});
        return key;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        try {
            Field sourceMapField = AbstractRoutingDataSource.class.getDeclaredField("resolvedDataSources");
            sourceMapField.setAccessible(true);
            Map sourceMap = (Map)sourceMapField.get((Object)this);
            keySet.addAll(sourceMap.keySet());
            sourceMapField.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public boolean containsKey(String key) {
        return keySet.contains(key);
    }

    public DataSource getDefaultDataSource() {
        return super.determineTargetDataSource();
    }
}

