/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.health;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.basic.normal.ErrorCode;
import org.miaixz.bus.core.data.id.ID;
import org.miaixz.bus.core.lang.EnumValue;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.health.Provider;
import org.miaixz.bus.health.builtin.TID;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.starter.health.HealthProperties;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.boot.availability.AvailabilityChangeEvent;
import org.springframework.boot.availability.AvailabilityState;
import org.springframework.boot.availability.LivenessState;
import org.springframework.boot.availability.ReadinessState;
import org.springframework.context.ApplicationEventPublisher;

public class HealthProviderService {
    private HealthProperties properties;
    private Provider provider;
    private ApplicationEventPublisher publisher;
    private ApplicationAvailability availability;

    public HealthProviderService(HealthProperties properties, Provider provider, ApplicationEventPublisher publisher, ApplicationAvailability availability) {
        this.properties = properties;
        this.provider = provider;
        this.publisher = publisher;
        this.availability = availability;
    }

    public Object healthz(String tid) {
        try {
            String defaultTids = "liveness,readiness";
            tid = StringKit.isEmpty((CharSequence)tid) ? (this.properties == null || StringKit.isEmpty((CharSequence)this.properties.getType()) ? defaultTids : this.properties.getType().toLowerCase()) : tid.toLowerCase();
            List<String> tidList = Arrays.asList(tid.split(","));
            if (tidList.stream().noneMatch(TID.ALL_TID::contains)) {
                tidList = Arrays.asList("liveness", "readiness");
                Logger.debug((String)"Invalid tid '{}', defaulting to liveness,readiness", (Object[])new Object[]{tid});
            }
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("requestId", ID.objectId());
            try {
                result.putAll("all".equals(tid) ? this.provider.getAll() : this.provider.get(tidList));
            }
            catch (NumberFormatException e) {
                Logger.warn((String)"Invalid number format in provider data for tid '{}': {}", (Object[])new Object[]{tid, e.getMessage()});
                tidList.forEach(type -> this.append((String)type, (Map<String, Object>)result));
            }
            return result;
        }
        catch (Exception e) {
            Logger.error((String)"Failed to retrieve health information for tid '{}': {}", (Object[])new Object[]{tid, e.getMessage(), e});
            return Message.builder().errcode(ErrorCode._FAILURE.getKey()).errmsg("Failed to retrieve health information: " + e.getMessage()).build();
        }
    }

    public Object broken() {
        AvailabilityChangeEvent.publish((ApplicationEventPublisher)this.publisher, (Object)this, (AvailabilityState)LivenessState.BROKEN);
        return this.builder(EnumValue.Probe.BROKEN);
    }

    public Object correct() {
        AvailabilityChangeEvent.publish((ApplicationEventPublisher)this.publisher, (Object)this, (AvailabilityState)LivenessState.CORRECT);
        return this.builder(EnumValue.Probe.CORRECT);
    }

    public Object accept() {
        AvailabilityChangeEvent.publish((ApplicationEventPublisher)this.publisher, (Object)this, (AvailabilityState)ReadinessState.ACCEPTING_TRAFFIC);
        return this.builder(EnumValue.Probe.ACCEPT);
    }

    public Object refuse() {
        AvailabilityChangeEvent.publish((ApplicationEventPublisher)this.publisher, (Object)this, (AvailabilityState)ReadinessState.REFUSING_TRAFFIC);
        return this.builder(EnumValue.Probe.REFUSE);
    }

    public Object builder(EnumValue.Probe probe) {
        return Map.of("state", probe.getValue(), "timestamp:", DateKit.current());
    }

    public void append(String type, Map<String, Object> map) {
        switch (type.toLowerCase()) {
            case "liveness": {
                map.put(type, this.availability.getLivenessState());
                break;
            }
            case "readiness": {
                map.put(type, this.availability.getReadinessState());
                break;
            }
            default: {
                try {
                    this.provider.append(type, map);
                    break;
                }
                catch (Exception e) {
                    Logger.error((String)"Failed to append health data for type {}: {}", (Object[])new Object[]{type, e.getMessage(), e});
                    map.put(type, "Error: " + e.getMessage());
                }
            }
        }
    }
}

