/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.health;

import jakarta.annotation.Resource;
import org.miaixz.bus.health.Provider;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.starter.annotation.EnableHealth;
import org.miaixz.bus.starter.health.HealthController;
import org.miaixz.bus.starter.health.HealthProperties;
import org.miaixz.bus.starter.health.HealthProviderService;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.boot.availability.ApplicationAvailabilityBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@EnableConfigurationProperties(value={HealthProperties.class})
public class HealthConfiguration {
    @Resource
    HealthProperties properties;

    @Bean
    @Conditional(value={EnableHealthCondition.class})
    public Provider provider() {
        try {
            return new Provider();
        }
        catch (Exception e) {
            Logger.error((String)"Failed to initialize Provider: {}", (Object[])new Object[]{e.getMessage(), e});
            throw new IllegalStateException("Failed to initialize Provider: " + e.getMessage(), e);
        }
    }

    @Bean
    @Conditional(value={EnableHealthCondition.class})
    public HealthProviderService healthProviderService(ApplicationEventPublisher publisher, ApplicationAvailability availability, Provider provider) {
        return new HealthProviderService(this.properties, provider, publisher, availability);
    }

    @Bean
    @Conditional(value={EnableHealthCondition.class})
    public ApplicationAvailability availability() {
        return new ApplicationAvailabilityBean();
    }

    @Bean
    @Conditional(value={EnableHealthCondition.class})
    public ApplicationEventPublisher publisher(ApplicationContext applicationContext) {
        return event -> {
            if (event != null) {
                applicationContext.publishEvent(event);
            } else {
                Logger.warn((String)"Null event received", (Object[])new Object[0]);
            }
        };
    }

    @Bean
    @Conditional(value={EnableHealthCondition.class})
    public HealthController healthController(HealthProviderService healthService, RequestMappingHandlerMapping handlerMapping) {
        HealthController controller = new HealthController(healthService);
        try {
            RequestMappingInfo healthzMapping = RequestMappingInfo.paths((String[])new String[]{"/healthz"}).methods(new RequestMethod[]{RequestMethod.GET, RequestMethod.POST}).build();
            handlerMapping.registerMapping(healthzMapping, (Object)controller, HealthController.class.getMethod("healthz", String.class));
            RequestMappingInfo brokenMapping = RequestMappingInfo.paths((String[])new String[]{"/broken"}).methods(new RequestMethod[]{RequestMethod.GET, RequestMethod.POST}).build();
            handlerMapping.registerMapping(brokenMapping, (Object)controller, HealthController.class.getMethod("broken", new Class[0]));
            RequestMappingInfo correctMapping = RequestMappingInfo.paths((String[])new String[]{"/correct"}).methods(new RequestMethod[]{RequestMethod.GET, RequestMethod.POST}).build();
            handlerMapping.registerMapping(correctMapping, (Object)controller, HealthController.class.getMethod("correct", new Class[0]));
            RequestMappingInfo acceptMapping = RequestMappingInfo.paths((String[])new String[]{"/accept"}).methods(new RequestMethod[]{RequestMethod.GET, RequestMethod.POST}).build();
            handlerMapping.registerMapping(acceptMapping, (Object)controller, HealthController.class.getMethod("accept", new Class[0]));
            RequestMappingInfo refuseMapping = RequestMappingInfo.paths((String[])new String[]{"/refuse"}).methods(new RequestMethod[]{RequestMethod.GET, RequestMethod.POST}).build();
            handlerMapping.registerMapping(refuseMapping, (Object)controller, HealthController.class.getMethod("refuse", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            Logger.error((String)"Failed to register HealthController mappings: {}", (Object[])new Object[]{e.getMessage(), e});
            throw new RuntimeException("Failed to register mapping", e);
        }
        return controller;
    }

    static class EnableHealthCondition
    implements Condition {
        EnableHealthCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return context.getBeanFactory().getBeansWithAnnotation(EnableHealth.class).size() > 0;
        }
    }
}

