/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.goalie;

import jakarta.annotation.Resource;
import java.util.List;
import java.util.function.BiFunction;
import org.miaixz.bus.goalie.Athlete;
import org.miaixz.bus.goalie.Config;
import org.miaixz.bus.goalie.filter.AuthorizeFilter;
import org.miaixz.bus.goalie.filter.DecryptFilter;
import org.miaixz.bus.goalie.filter.EncryptFilter;
import org.miaixz.bus.goalie.filter.FormatFilter;
import org.miaixz.bus.goalie.filter.LimitFilter;
import org.miaixz.bus.goalie.filter.PrimaryFilter;
import org.miaixz.bus.goalie.handler.ApiRouterHandler;
import org.miaixz.bus.goalie.handler.ApiWebMvcRegistrations;
import org.miaixz.bus.goalie.handler.GlobalExceptionHandler;
import org.miaixz.bus.goalie.provider.AuthorizeProvider;
import org.miaixz.bus.goalie.registry.AssetsRegistry;
import org.miaixz.bus.goalie.registry.DefaultAssetsRegistry;
import org.miaixz.bus.goalie.registry.DefaultLimiterRegistry;
import org.miaixz.bus.goalie.registry.LimiterRegistry;
import org.miaixz.bus.starter.goalie.GoalieProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.server.WebExceptionHandler;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebHandler;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;
import reactor.netty.http.server.HttpServer;

@ConditionalOnWebApplication
@EnableConfigurationProperties(value={GoalieProperties.class})
public class GoalieConfiguration {
    @Resource
    GoalieProperties goalieProperties;
    @Resource
    List<WebExceptionHandler> webExceptionHandlers;
    @Resource
    List<WebFilter> webFilters;

    @ConditionalOnMissingBean
    @Bean
    AssetsRegistry assetsRegistry() {
        return new DefaultAssetsRegistry();
    }

    @ConditionalOnMissingBean
    @Bean
    LimiterRegistry limiterRegistry() {
        return new DefaultLimiterRegistry();
    }

    @Bean
    WebFilter primaryFilter() {
        return new PrimaryFilter();
    }

    @Bean
    WebFilter decryptFilter() {
        return this.goalieProperties.getServer().getDecrypt().isEnabled() ? new DecryptFilter(this.goalieProperties.getServer().getDecrypt()) : null;
    }

    @Bean
    WebFilter authorizeFilter(AuthorizeProvider authorizeProvider, AssetsRegistry registry) {
        return new AuthorizeFilter(authorizeProvider, registry);
    }

    @Bean
    WebFilter encryptFilter() {
        return this.goalieProperties.getServer().getEncrypt().isEnabled() ? new EncryptFilter(this.goalieProperties.getServer().getEncrypt()) : null;
    }

    @Bean
    WebFilter limitFilter(LimiterRegistry registry) {
        return this.goalieProperties.getServer().getLimit().isEnabled() ? new LimitFilter(registry) : null;
    }

    @Bean
    WebFilter formatFilter() {
        return new FormatFilter();
    }

    @Bean
    WebExceptionHandler webExceptionHandler() {
        return new GlobalExceptionHandler();
    }

    @Bean(initMethod="init", destroyMethod="destroy")
    Athlete athlete() {
        ApiRouterHandler apiRouterHandler = new ApiRouterHandler();
        RouterFunction routerFunction = RouterFunctions.route((RequestPredicate)RequestPredicates.path((String)this.goalieProperties.getServer().getPath()).and(RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.APPLICATION_FORM_URLENCODED})), arg_0 -> ((ApiRouterHandler)apiRouterHandler).handle(arg_0));
        ServerCodecConfigurer configurer = ServerCodecConfigurer.create();
        configurer.defaultCodecs().maxInMemorySize(Config.MAX_INMEMORY_SIZE.intValue());
        WebHandler webHandler = RouterFunctions.toWebHandler((RouterFunction)routerFunction);
        HttpHandler handler = WebHttpHandlerBuilder.webHandler((WebHandler)webHandler).filters(filters -> filters.addAll(this.webFilters)).exceptionHandlers(handlers -> handlers.addAll(this.webExceptionHandlers)).codecConfigurer(configurer).build();
        ReactorHttpHandlerAdapter adapter = new ReactorHttpHandlerAdapter(handler);
        HttpServer server = HttpServer.create().port(this.goalieProperties.getServer().getPort()).handle((BiFunction)adapter);
        return new Athlete(server);
    }

    @Bean
    public WebMvcRegistrations customWebMvcRegistrations() {
        return this.goalieProperties.isCondition() ? null : new ApiWebMvcRegistrations();
    }
}

