/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.elastic;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import jakarta.annotation.Resource;
import java.util.List;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.miaixz.bus.core.basic.normal.Consts;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.starter.elastic.ElasticProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={ElasticProperties.class})
public class ElasticConfiguration {
    @Resource
    private ElasticProperties properties;

    @Bean
    @ConditionalOnClass
    public RestClientBuilder restClientBuilder() {
        if (CollKit.isEmpty(this.properties.getHostList())) {
            Logger.error((String)"[ElasticConfiguration.restClientBuilder] \u521d\u59cb\u5316 RestClient \u5931\u8d25: \u672a\u914d\u7f6e\u96c6\u7fa4\u4e3b\u673a\u4fe1\u606f", (Object[])new Object[0]);
            throw new InternalException("\u521d\u59cb\u5316 RestClient \u5931\u8d25: \u672a\u914d\u7f6e ElasticSearch \u96c6\u7fa4\u4e3b\u673a\u4fe1\u606f");
        }
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])((HttpHost[])this.properties.getHostList().stream().map(this::buildHttpHost).toArray(HttpHost[]::new)));
        restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> {
            requestConfigBuilder.setConnectTimeout(this.properties.getConnectTimeout());
            requestConfigBuilder.setSocketTimeout(this.properties.getSocketTimeout());
            requestConfigBuilder.setConnectionRequestTimeout(this.properties.getConnectionRequestTimeout());
            return requestConfigBuilder;
        });
        restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> {
            httpClientBuilder.setMaxConnTotal(this.properties.getMaxConnectTotal());
            httpClientBuilder.setMaxConnPerRoute(this.properties.getMaxConnectPerRoute());
            return httpClientBuilder;
        });
        return restClientBuilder;
    }

    @Bean
    public ElasticsearchClient elasticsearchClient(RestClientBuilder restClientBuilder) {
        RestClientTransport transport = new RestClientTransport(restClientBuilder.build(), (JsonpMapper)new JacksonJsonpMapper());
        ElasticsearchClient client = new ElasticsearchClient((ElasticsearchTransport)transport);
        return client;
    }

    private HttpHost buildHttpHost(String host) {
        if (StringKit.isBlank((CharSequence)host) || !host.contains(":")) {
            throw new InternalException("ElasticSearch\u96c6\u7fa4\u8282\u70b9\u4fe1\u606f\u914d\u7f6e\u9519\u8bef, \u6b63\u786e\u683c\u5f0f[ ip1:port,ip2:port... ]");
        }
        List hostPort = StringKit.split((CharSequence)host, (CharSequence)":");
        return new HttpHost((String)hostPort.get(Consts.INTEGER_ZERO), Integer.parseInt((String)hostPort.get(Consts.INTEGER_ONE)), this.properties.getSchema());
    }
}

