/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.cache;

import jakarta.annotation.Resource;
import org.miaixz.bus.cache.Context;
import org.miaixz.bus.cache.Hitting;
import org.miaixz.bus.cache.provider.H2Hitting;
import org.miaixz.bus.cache.provider.MemoryHitting;
import org.miaixz.bus.cache.provider.MySQLHitting;
import org.miaixz.bus.cache.provider.SqliteHitting;
import org.miaixz.bus.cache.provider.ZookeeperHitting;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.starter.cache.AspectjCacheProxy;
import org.miaixz.bus.starter.cache.CacheProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={CacheProperties.class})
public class CacheConfiguration {
    @Resource
    CacheProperties properties;

    @Bean
    public AspectjCacheProxy cacheConfigurer() {
        try {
            if (StringKit.isNotEmpty((CharSequence)this.properties.getType())) {
                Class provider = ClassKit.loadClass((String)this.properties.getType());
                Context config = Context.newConfig(this.properties.getMap());
                if (provider instanceof H2Hitting) {
                    config.setHitting((Hitting)new H2Hitting(this.properties.getProvider().getUrl(), this.properties.getProvider().getUsername(), this.properties.getProvider().getPassword()));
                } else if (provider instanceof MySQLHitting) {
                    config.setHitting((Hitting)new MySQLHitting(BeanKit.beanToMap((Object)this.properties, (String[])new String[0])));
                } else if (provider instanceof SqliteHitting) {
                    config.setHitting((Hitting)new SqliteHitting(this.properties.getProvider().getUrl(), this.properties.getProvider().getUsername(), this.properties.getProvider().getPassword()));
                } else if (provider instanceof ZookeeperHitting) {
                    config.setHitting((Hitting)new ZookeeperHitting(this.properties.getProvider().getUrl()));
                } else if (provider instanceof MemoryHitting) {
                    config.setHitting((Hitting)new MemoryHitting());
                }
                return new AspectjCacheProxy(config);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can not resolve class with type: " + this.properties.getType());
        }
        return null;
    }
}

