/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.cache;

import java.lang.reflect.Method;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.cache.Complex;
import org.miaixz.bus.cache.Context;
import org.miaixz.bus.cache.Module;
import org.miaixz.bus.cache.magic.annotation.Cached;
import org.miaixz.bus.cache.magic.annotation.CachedGet;
import org.miaixz.bus.cache.magic.annotation.Invalid;
import org.miaixz.bus.proxy.invoker.InvocationInvoker;
import org.miaixz.bus.proxy.invoker.ProxyChain;

@Aspect
public class AspectjCacheProxy {
    private Complex core;

    public AspectjCacheProxy(Map<String, CacheX> caches) {
        this(Context.newConfig(caches));
    }

    public AspectjCacheProxy(Context config) {
        this.core = Module.coreInstance((Context)config);
    }

    @Around(value="@annotation(org.miaixz.bus.cache.magic.annotation.CachedGet)")
    public Object read(ProceedingJoinPoint point) throws Throwable {
        Method method = this.getMethod((JoinPoint)point);
        CachedGet cachedGet = method.getAnnotation(CachedGet.class);
        return this.core.read(cachedGet, method, (ProxyChain)new InvocationInvoker(point));
    }

    @Around(value="@annotation(org.miaixz.bus.cache.magic.annotation.Cached)")
    public Object readWrite(ProceedingJoinPoint point) throws Throwable {
        Method method = this.getMethod((JoinPoint)point);
        Cached cached = method.getAnnotation(Cached.class);
        return this.core.readWrite(cached, method, (ProxyChain)new InvocationInvoker(point));
    }

    @After(value="@annotation(org.miaixz.bus.cache.magic.annotation.Invalid)")
    public void remove(JoinPoint point) throws Throwable {
        Method method = this.getMethod(point);
        Invalid invalid = method.getAnnotation(Invalid.class);
        this.core.remove(invalid, method, point.getArgs());
    }

    private Method getMethod(JoinPoint point) throws NoSuchMethodException {
        MethodSignature ms = (MethodSignature)point.getSignature();
        Method method = ms.getMethod();
        if (method.getDeclaringClass().isInterface()) {
            method = point.getTarget().getClass().getDeclaredMethod(ms.getName(), method.getParameterTypes());
        }
        return method;
    }
}

