/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.starter.bridge;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Router;
import jakarta.annotation.Resource;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.starter.bridge.BridgeProperties;
import org.miaixz.bus.starter.bridge.Resolvable;

public class BridgeVerticleService
extends AbstractVerticle {
    private final BridgeProperties properties;
    @Resource
    Vertx vertx;
    @Resource
    Resolvable resolvable;

    public BridgeVerticleService(BridgeProperties properties) {
        this.properties = properties;
    }

    public void start() {
        if (this.properties.getPort() <= 0 || this.properties.getPort() > 65535) {
            return;
        }
        Router router = Router.router((Vertx)this.vertx);
        router.route("/profile/get").handler(context -> {
            String result;
            try {
                BridgeProperties properties = (BridgeProperties)JsonKit.toPojo((String)context.body().asString(), BridgeProperties.class);
                Message message = Message.builder().data(this.resolvable.find(properties)).build();
                Logger.info((String)"request:{},response:{}", (Object[])new Object[]{properties, message});
                result = JsonKit.toJsonString((Object)message);
            }
            catch (Exception e) {
                Logger.error((String)"get error", (Object[])new Object[]{e});
                result = JsonKit.toJsonString((Object)Message.builder().errcode("-1").build());
            }
            context.response().putHeader("Content-Type", "application/json").end(result);
        });
        this.vertx.createHttpServer().requestHandler((Handler)router).listen(this.properties.getPort());
        Logger.info((String)"Vert.x is listening {}", (Object[])new Object[]{this.properties.getPort()});
    }

    public void stop() {
        if (ObjectKit.isNotEmpty((Object)this.vertx)) {
            this.vertx.close();
        }
    }
}

